/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util.imageinfo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.CheckedException;
import oracle.install.commons.util.exception.DefaultErrorMessage;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.library.resource.CommonErrorCode;

public class ImageInfoUtil {
    private String imageFilePath = "";

    public ImageInfoUtil(String oracleHome) {
        this.imageFilePath = oracleHome + File.separator + "install" + File.separator + ".img.bin";
    }

    private boolean checkWrittenPermissions(String filePath) {
        File imageInfo = new File(filePath);
        boolean validFile = false;
        if (imageInfo.exists()) {
            if (imageInfo.canWrite() && imageInfo.isFile()) {
                validFile = true;
            }
        } else {
            File imageInfoDirectory = imageInfo.getParentFile();
            if (imageInfoDirectory.exists() && imageInfoDirectory.isDirectory() && imageInfoDirectory.canExecute() && imageInfoDirectory.canWrite()) {
                validFile = true;
            }
        }
        return validFile;
    }

    private boolean checkReadPermissions(String filePath) {
        File imageInfo = new File(filePath);
        return imageInfo.length() != 0L && imageInfo.exists() && imageInfo.canRead() && !imageInfo.isDirectory();
    }

    public boolean encodeFile(String encodeFilePath) throws CheckedException {
        boolean result = false;
        if (!this.checkReadPermissions(encodeFilePath)) {
            throw new CheckedException((ErrorCode)CommonErrorCode.IMAGE_INFO_CANNOT_READ_ENCODE_FILE, new Object[0]);
        }
        if (!this.checkWrittenPermissions(this.imageFilePath)) {
            throw new CheckedException((ErrorCode)CommonErrorCode.IMAGE_INFO_CANNOT_WRITE_IMAGE_INFO_FILE, new Object[0]);
        }
        try (FileInputStream fileReader = new FileInputStream(encodeFilePath);
             FileOutputStream fileWriter = new FileOutputStream(this.imageFilePath);){
            byte[] inputBytes = new byte[fileReader.available()];
            fileReader.read(inputBytes, 0, inputBytes.length);
            byte[] outputBytes = this.encodeBytes(inputBytes);
            if (outputBytes != null && outputBytes.length > 0) {
                fileWriter.write(outputBytes);
                result = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean encode(String text) throws CheckedException {
        if (text == null || text.length() == 0) {
            throw new CheckedException((ErrorCode)CommonErrorCode.IMAGE_INFO_EMPTY_ENCODE_STRING, new Object[0]);
        }
        if (!this.checkWrittenPermissions(this.imageFilePath)) {
            throw new CheckedException((ErrorCode)CommonErrorCode.IMAGE_INFO_CANNOT_WRITE_IMAGE_INFO_FILE, new Object[0]);
        }
        byte[] inputBytes = text.getBytes();
        boolean result = false;
        try (FileOutputStream fileWriter = new FileOutputStream(this.imageFilePath);){
            byte[] outputBytes = this.encodeBytes(inputBytes);
            if (outputBytes != null && outputBytes.length > 0) {
                fileWriter.write(outputBytes);
                result = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private byte[] encodeBytes(byte[] data) {
        int dataSize = data.length;
        int headerPointer = 0;
        int footerPointer = dataSize - 1;
        int bitCount = 0;
        byte[] encodedData = new byte[dataSize + 8];
        for (int i = 7; i >= 0; --i) {
            encodedData[i] = (byte)((long)dataSize >> 8 * i);
        }
        while (headerPointer < footerPointer) {
            encodedData[headerPointer + 8] = this.rotateLeft(data[headerPointer], bitCount += Integer.bitCount(data[headerPointer]) + Integer.bitCount(data[footerPointer]));
            encodedData[footerPointer + 8] = this.rotateLeft(data[footerPointer], bitCount);
            ++headerPointer;
            --footerPointer;
        }
        if (headerPointer == footerPointer) {
            encodedData[headerPointer + 8] = data[headerPointer];
        }
        return encodedData;
    }

    private byte rotateLeft(byte bits, int shift) {
        int bitsToShift = Math.abs(shift);
        bitsToShift = bitsToShift % 4 == 0 ? 4 : bitsToShift % 4;
        return (byte)((bits & 0xFF) >>> bitsToShift | (bits & 0xFF) << 8 - bitsToShift);
    }

    public String decode() throws CheckedException {
        String decodedText = null;
        if (!this.checkReadPermissions(this.imageFilePath)) {
            throw new CheckedException((ErrorCode)CommonErrorCode.IMAGE_INFO_CANNOT_READ_IMAGE_INFO_FILE, new Object[0]);
        }
        try (FileInputStream fileReader = new FileInputStream(this.imageFilePath);){
            byte[] inputBytes = new byte[fileReader.available()];
            fileReader.read(inputBytes, 0, inputBytes.length);
            if (!this.verifyChecksum(inputBytes)) {
                throw new CheckedException((ErrorCode)CommonErrorCode.IMAGE_INFO_WRONG_CHECKSUM, new Object[0]);
            }
            byte[] outputBytes = this.decodeBytes(inputBytes);
            if (outputBytes != null && outputBytes.length > 0) {
                decodedText = new String(outputBytes);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return decodedText;
    }

    private boolean verifyChecksum(byte[] data) {
        int originalChecksum = 0;
        int newChecksum = data.length - 8;
        for (int i = 7; i >= 0; --i) {
            originalChecksum |= (data[i] & 0xFF) << 8 * i;
        }
        return originalChecksum == newChecksum;
    }

    private byte[] decodeBytes(byte[] data) {
        int dataSize = data.length;
        int headerPointer = 8;
        int bitCount = 0;
        for (int footerPointer = dataSize - 1; headerPointer < footerPointer; ++headerPointer, --footerPointer) {
            data[headerPointer] = this.rotateRight(data[headerPointer], bitCount += Integer.bitCount(0xFF & data[headerPointer]) + Integer.bitCount(0xFF & data[footerPointer]));
            data[footerPointer] = this.rotateRight(data[footerPointer], bitCount);
        }
        return Arrays.copyOfRange(data, 8, data.length);
    }

    private byte rotateRight(byte bits, int shift) {
        int bitsToShift = Math.abs(shift);
        bitsToShift = bitsToShift % 4 == 0 ? 4 : bitsToShift % 4;
        return (byte)((bits & 0xFF) << bitsToShift | (bits & 0xFF) >>> 8 - bitsToShift);
    }

    private static void printErrorExit(ErrorCode errorCode) {
        DefaultErrorMessage dfe = new DefaultErrorMessage(errorCode, new Object[0]);
        System.out.println(dfe.getMessage());
        System.exit(Application.CommonExitStatus.FAILURE.getIntValue());
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            if (args[0] != null && !args[0].isEmpty()) {
                String oracleH = args[0];
                ImageInfoUtil imageInfoUtl = new ImageInfoUtil(oracleH);
                String decodedText = null;
                try {
                    decodedText = imageInfoUtl.decode();
                }
                catch (CheckedException e) {
                    ImageInfoUtil.printErrorExit(e.getErrorCode());
                }
                if (decodedText != null) {
                    System.out.println(decodedText);
                    System.exit(Application.CommonExitStatus.SUCCESS.getIntValue());
                }
                ImageInfoUtil.printErrorExit(CommonErrorCode.IMAGE_INFO_UNABLE_TO_DECODE_IMAGE_INFO);
            }
            ImageInfoUtil.printErrorExit(CommonErrorCode.IMAGE_INFO_EMPTY_ORACLE_HOME);
        }
        ImageInfoUtil.printErrorExit(CommonErrorCode.IMAGE_INFO_MISSING_ARGUMENTS);
    }
}

