/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.HelpManager;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ExceptionManager;

@ViewDef(id="ConfigurationScriptDialog")
public class ConfigurationScriptDialog
extends JDialog {
    private Resource resource;
    public static final int OK = 0;
    public static final int CANCEL = -1;
    private static int value = -1;
    private MultilineLabel lblDescription;
    private JButton btnOK;
    private JButton btnCancel;
    private JButton btnHelp;
    private MultilineLabel lblinstructions;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private boolean displayNodes;
    private String promptForConfigScript;
    private String executionStepsPromptForConfigScript;
    private String orderOfExectionPromptForConfigScript;
    private MultilineLabel lblOrderOfExecutionText;

    public ConfigurationScriptDialog(Frame owner, LinkedHashMap<String, List<String>> map, boolean displayNodes) {
        this(owner, map, displayNodes, null, null, null);
    }

    public ConfigurationScriptDialog(Frame owner, LinkedHashMap<String, List<String>> map, boolean displayNodes, String promptForConfigScript, String executionStepsPromptForConfigScript, String orderOfExectionPromptForConfigScript) {
        super(owner, "root", true);
        this.displayNodes = displayNodes;
        this.promptForConfigScript = promptForConfigScript;
        this.executionStepsPromptForConfigScript = executionStepsPromptForConfigScript;
        this.orderOfExectionPromptForConfigScript = orderOfExectionPromptForConfigScript;
        this.resource = Application.getInstance().getResource("oracle.install.commons.base.interview.common.resource.StringResourceBundle");
        this.setResizable(true);
        this.setVisible(false);
        this.lblDescription = new MultilineLabel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        this.btnHelp = new JButton();
        this.lblinstructions = new MultilineLabel();
        if (orderOfExectionPromptForConfigScript != null) {
            this.lblOrderOfExecutionText = new MultilineLabel();
        }
        this.mainPanel = new JPanel();
        this.buttonPanel = new JPanel();
        JTable scriptsTable = new JTable(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                int height = 0;
                int margin = 2;
                for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                    TableCellRenderer renderer = this.getCellRenderer(rowIndex, 0);
                    Component comp = this.prepareRenderer(renderer, rowIndex, 0);
                    int compPreferredHieght = comp.getPreferredSize().height + 2 * margin;
                    height += Math.max(this.getRowHeight(), compPreferredHieght);
                }
                size.height = height + 100 + 25;
                return size;
            }
        };
        ScriptTableModel scriptsTableModel = new ScriptTableModel(map, displayNodes);
        scriptsTable.setModel(scriptsTableModel);
        scriptsTable.setCellSelectionEnabled(true);
        scriptsTable.setSelectionMode(0);
        scriptsTable.getColumnModel().getColumn(0).setCellEditor(new ScriptsTableEditor(new JTextField()));
        scriptsTable.setAutoResizeMode(0);
        this.setPreferredSizeForColumn(scriptsTable);
        this.btnOK.setActionCommand("ok");
        this.btnOK.setName("ConfigurationScriptDialog.btnOK");
        this.btnCancel.setActionCommand("cancel");
        this.btnCancel.setName("ConfigurationScriptDialog.btnCancel");
        this.btnHelp.setActionCommand("help");
        this.btnHelp.setName("ConfigurationScriptDialog.btnHelp");
        JScrollPane scrollPane = new JScrollPane(scriptsTable, 20, 30);
        scrollPane.getViewport().setBackground(scriptsTable.getBackground());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        LayoutUtils.addComponent(this.lblDescription, this.mainPanel, 0, 0, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(Box.createRigidArea(new Dimension(0, 1)), this.mainPanel, 0, 1, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(scrollPane, this.mainPanel, 0, 2, 1, 1, 1, 18, 1.0, 8.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.lblinstructions, this.mainPanel, 0, 3, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        if (orderOfExectionPromptForConfigScript != null) {
            LayoutUtils.addComponent(this.lblOrderOfExecutionText, this.mainPanel, 0, 4, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        }
        LayoutUtils.addComponent(Box.createRigidArea(new Dimension(0, 5)), this.mainPanel, 0, 5, 2, 1, 2, 18, 1.0, 0.0, new Insets(5, 5, 5, 5));
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnOK, this.buttonPanel, 0, 0, 1, 1, 0, 12, 1.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnCancel, this.buttonPanel, 2, 0, 1, 1, 0, 12, 0.0, 0.0, new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent(this.btnHelp, this.buttonPanel, 0, 0, 1, 1, 0, 16, 1.0, 0.0, new Insets(5, 5, 5, 5));
        Container contentPane = this.getContentPane();
        contentPane.add((Component)this.mainPanel, "Center");
        contentPane.add((Component)this.buttonPanel, "Last");
        this.setLocationRelativeTo(this.getParent());
        this.pack();
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if (actionCommand.equalsIgnoreCase("ok")) {
                    value = 0;
                } else {
                    value = -1;
                }
                ConfigurationScriptDialog.this.setVisible(false);
            }
        };
        ActionListener helpListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpManager helpManager;
                String actionCommand = e.getActionCommand();
                if (actionCommand.equalsIgnoreCase("help") && (helpManager = Application.getInstance().getHelpManager()) != null) {
                    try {
                        helpManager.showHelpForComponent(ConfigurationScriptDialog.this, ConfigurationScriptDialog.this.getParent());
                    }
                    catch (Throwable e1) {
                        ExceptionManager.report(e1);
                    }
                }
            }
        };
        this.btnOK.addActionListener(listener);
        this.btnCancel.addActionListener(listener);
        this.btnHelp.addActionListener(helpListener);
        Application.getInstance().registerComponentForHelp(this, "ConfigurationScriptDialog");
        this.localize();
    }

    @Override
    public Dimension getPreferredSize() {
        int height = super.getPreferredSize().height;
        Dimension preferredDimension = new Dimension(590, height);
        return preferredDimension;
    }

    public void setPreferredSizeForColumn(JTable table) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        double minimumWidthForColum = (this.getPreferredSize().getWidth() - 30.0) / (double)table.getColumnCount();
        int margin = 2;
        for (int i = 0; i < table.getColumnCount(); ++i) {
            TableColumn col = colModel.getColumn(i);
            int width = 0;
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            width = comp.getPreferredSize().width;
            for (int row = 0; row < table.getRowCount(); ++row) {
                renderer = table.getCellRenderer(row, i);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(row, i), false, false, row, i);
                width = Math.max(width, comp.getPreferredSize().width);
            }
            if ((double)(width += 2 * margin) < minimumWidthForColum) {
                width = (int)minimumWidthForColum;
            }
            col.setPreferredWidth(width);
        }
    }

    public void localize() {
        String text = this.resource.getString("ConfigurationScriptDialog.title", "Execute Configuration Scripts", new Object[0]);
        this.setTitle(text);
        text = this.promptForConfigScript;
        if (text == null) {
            text = this.displayNodes ? this.resource.getString("ConfigurationScriptDialog.execution.description", "The following configuration scripts need to be executed as the \"root\" user on each listed cluster node.  Each script in the list below is followed by a list of nodes on which it has to be executed.", new Object[0]) : this.resource.getString("ConfigurationScriptDialog.executionWithoutNodes.description", "The following script needs to be executed as the \"root\" user.", new Object[0]);
        }
        this.lblDescription.setText(text);
        text = this.resource.getString("ConfigurationScriptDialog.OK", "&OK", new Object[0]);
        SwingUtils.setText(this.btnOK, text);
        text = this.resource.getString("ConfigurationScriptDialog.Cancel", "&Cancel", new Object[0]);
        SwingUtils.setText(this.btnCancel, text);
        text = this.resource.getString("ConfigurationScriptDialog.Help", "&Help", new Object[0]);
        SwingUtils.setText(this.btnHelp, text);
        text = this.executionStepsPromptForConfigScript;
        if (text == null) {
            text = this.resource.getString("ConfigurationScriptDialog.instructions", "To execute the configuration scripts:\n    1. Open a terminal window\n    2. Login as \"root\"\n    3. Run the scripts\n    4. Return to this window and click \"OK\" to continue", new Object[0]);
        }
        this.lblinstructions.setText(text);
        if (this.orderOfExectionPromptForConfigScript != null) {
            this.lblOrderOfExecutionText.setText(this.orderOfExectionPromptForConfigScript);
        }
    }

    private class ScriptTableModel
    extends DefaultTableModel {
        String[] columnNames;

        @Override
        public boolean isCellEditable(int row, int column) {
            boolean value = true;
            if (column == 1) {
                return false;
            }
            return value;
        }

        public ScriptTableModel(HashMap<String, List<String>> map, boolean displayNodes) {
            this.columnNames = new String[displayNodes ? 2 : 1];
            this.columnNames[0] = ConfigurationScriptDialog.this.resource.getString("ConfigurationScriptDialog.lblScript", "Scripts", new Object[0]);
            if (displayNodes) {
                this.columnNames[1] = ConfigurationScriptDialog.this.resource.getString("ConfigurationScriptDialog.lblNodes", "Nodes", new Object[0]);
            }
            Set<String> keys = map.keySet();
            int rowCount = keys.size();
            this.setRowCount(rowCount);
            this.setColumnCount(this.columnNames.length);
            int iterator = 0;
            List<Object> nodes = new ArrayList();
            for (String key : keys) {
                super.setValueAt(key, iterator, 0);
                nodes = map.get(key);
                if (nodes != null && displayNodes) {
                    super.setValueAt(nodes.toString().substring(1, nodes.toString().length() - 1), iterator, 1);
                }
                ++iterator;
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }
    }

    class ScriptsTableEditor
    extends DefaultCellEditor {
        public ScriptsTableEditor(JTextField textField) {
            super(textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (component instanceof JTextComponent) {
                final JTextComponent textComponent = (JTextComponent)component;
                textComponent.requestFocus();
                textComponent.setEditable(false);
                textComponent.setBackground(table.getBackground());
                textComponent.setForeground(table.getForeground());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textComponent.selectAll();
                    }
                });
            }
            return component;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }
    }
}

