/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean;

import java.io.InputStream;
import java.io.OutputStream;
import oracle.install.commons.bean.BeanStoreEvent;
import oracle.install.commons.bean.BeanStoreEventListener;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreReader;
import oracle.install.commons.bean.BeanStoreWriter;
import oracle.install.commons.util.EventSupport;

public abstract class BeanStore<W extends BeanStoreWriter, R extends BeanStoreReader> {
    private AccessMode accessMode;
    private boolean secure;
    private String beanStoreName;
    private EventSupport<BeanStoreEvent> eventSupport;
    public static final String DEFAULT_BEANSTORE_NAME = "beanstore";

    protected BeanStore() {
        this(null);
    }

    protected BeanStore(String beanStoreName) {
        this(beanStoreName, null);
    }

    protected BeanStore(String beanStoreName, AccessMode accessMode) {
        this.beanStoreName = beanStoreName == null || beanStoreName.length() == 0 ? DEFAULT_BEANSTORE_NAME : beanStoreName;
        this.accessMode = accessMode == null ? AccessMode.READ_ONLY : accessMode;
        this.secure = false;
        this.eventSupport = new EventSupport();
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.accessMode = accessMode;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getBeanStoreName() {
        return this.beanStoreName;
    }

    public void setBeanStoreName(String name) {
        this.beanStoreName = name == null ? DEFAULT_BEANSTORE_NAME : name;
    }

    public void load() throws BeanStoreException {
    }

    public void load(InputStream in) throws BeanStoreException {
    }

    public void save() throws BeanStoreException {
        if (this.accessMode == AccessMode.READ_ONLY) {
            throw new BeanStoreException();
        }
    }

    public void save(OutputStream out) throws BeanStoreException {
    }

    public R newBeanStoreReader() throws BeanStoreException {
        return null;
    }

    public W newBeanStoreWriter() throws BeanStoreException {
        return null;
    }

    public void close() throws BeanStoreException {
    }

    public void addApplicationListener(BeanStoreEventListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeApplicationListener(BeanStoreEventListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    protected void fireApplicationEvent(BeanStoreEvent e) {
        this.eventSupport.fireEvent(e);
    }

    public static enum AccessMode {
        READ_ONLY,
        READ_WRITE,
        WRITE_ONLY;

    }
}

