/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import oracle.install.commons.util.StringUtils;

public class FileChooserDialog {
    private String title;
    private String approveBtnText;
    private Component parent;
    private int mode = 2;

    public FileChooserDialog(Component parent) {
        this(null, null, parent, 2);
    }

    public FileChooserDialog(String title, String approveBtnText, Component parent, int mode) {
        this.title = title;
        this.approveBtnText = approveBtnText;
        this.parent = parent;
        this.mode = mode;
    }

    public String showDialog(String defaultPath) {
        return this.showDialog(defaultPath, false);
    }

    public String showDialog(String defaultPath, boolean enableMultipleSelection) {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(enableMultipleSelection);
        String filePath = null;
        switch (this.mode) {
            case 2: {
                chooser.setFileSelectionMode(2);
                break;
            }
            case 1: {
                chooser.setFileSelectionMode(1);
                break;
            }
            case 0: {
                chooser.setFileSelectionMode(0);
            }
        }
        if (this.title != null) {
            chooser.setDialogTitle(this.title);
        }
        if (this.approveBtnText != null && this.approveBtnText.length() > 0) {
            chooser.setApproveButtonText(this.approveBtnText);
        } else {
            chooser.setApproveButtonText("OK");
        }
        if (defaultPath != null && !defaultPath.isEmpty()) {
            chooser.setCurrentDirectory(new File(defaultPath));
        }
        if ((returnVal = chooser.showOpenDialog(this.parent)) == 0) {
            if (enableMultipleSelection) {
                Object[] selectedFiles = chooser.getSelectedFiles();
                if (selectedFiles != null && selectedFiles.length != 0) {
                    filePath = StringUtils.getCommaSeparatedString(selectedFiles);
                }
            } else {
                filePath = chooser.getSelectedFile().getPath();
            }
        }
        return filePath;
    }
}

