/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ExitStatus;

public class ExitStatusSet
extends LinkedHashSet<ExitStatus> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ExitStatusSet.class.getName());
    private Map<ExitStatus, ExitStatus> aliasMap;
    private Comparator<ExitStatus> comparator = new ExitStatusComparator();

    public ExitStatusSet() {
        this.aliasMap = new HashMap<ExitStatus, ExitStatus>();
    }

    public Comparator<ExitStatus> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<ExitStatus> comparator) {
        if (comparator != null) {
            this.comparator = comparator;
        }
    }

    public void setAlias(ExitStatus exitStatus, ExitStatus alias) {
        if (exitStatus != null && alias != null) {
            logger.log(Level.INFO, "Setting alias for exit status {0} as {1}", new Object[]{exitStatus, alias});
            this.aliasMap.put(exitStatus, alias);
        }
    }

    public ExitStatus getAlias(ExitStatus exitStatus) {
        return this.aliasMap.get(exitStatus);
    }

    @Override
    public boolean add(ExitStatus exitStatus) {
        boolean ret = false;
        if (exitStatus != null) {
            ExitStatus alias = this.getAlias(exitStatus);
            exitStatus = alias != null ? alias : exitStatus;
            logger.log(Level.INFO, "Adding ExitStatus {0} to the exit status set", exitStatus);
            ret = super.add(exitStatus);
        }
        return ret;
    }

    public ExitStatus getExitStatus() {
        ExitStatus exitStatus = null;
        if (!this.isEmpty()) {
            logger.log(Level.INFO, "Finding the most appropriate exit status for the current application");
            ExitStatus[] array = this.toArray(new ExitStatus[0]);
            Arrays.sort(array, this.comparator);
            exitStatus = array[0];
        } else {
            exitStatus = this.getAlias(Application.CommonExitStatus.SUCCESS);
            if (exitStatus == null) {
                exitStatus = Application.CommonExitStatus.SUCCESS;
            }
        }
        return exitStatus;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        if (exitStatus != null) {
            logger.log(Level.INFO, "Reseting the exit status set with exit status {0}", exitStatus);
            this.clear();
            this.add(exitStatus);
        }
    }

    private class ExitStatusComparator
    implements Comparator<ExitStatus> {
        private ExitStatusComparator() {
        }

        @Override
        public int compare(ExitStatus o1, ExitStatus o2) {
            int ret = -1;
            Level level1 = o1.getLevel();
            int intValue1 = Math.abs(o1.getIntValue());
            Level level2 = o2.getLevel();
            int intValue2 = Math.abs(o2.getIntValue());
            ret = level1.intValue() > level2.intValue() ? -1 : (level1.intValue() < level2.intValue() ? 1 : 0);
            if (ret == 0) {
                ret = intValue1 > intValue2 ? -1 : (intValue1 < intValue2 ? 1 : 0);
            }
            return ret;
        }
    }
}

