/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.exception;

import java.awt.Component;
import java.util.logging.Level;
import oracle.install.commons.util.DefaultStatusMessage;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.AbstractErrorAdvisor;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ErrorMessage;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.exception.Severity;

public class SilentErrMsgAdvisor
extends AbstractErrorAdvisor {
    @Override
    public Advice advise(Object observer, StatusMessages<? extends ErrorMessage> errorMessages, String detailedMessage) {
        Advice advice = Advice.CONTINUE;
        System.out.print(detailedMessage);
        Level aggregateLevel = errorMessages.getAggregateLevel();
        if (ExceptionManager.getSeverity(aggregateLevel) == Severity.FATAL) {
            advice = Advice.ABORT;
        }
        return advice;
    }

    @Override
    public Option adviceMessages(Component owner, String title, StatusMessages<? extends DefaultStatusMessage> messages, Option defaultOption, Option ... options) {
        if (messages != null && !messages.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            for (DefaultStatusMessage defaultStatusMessage : messages) {
                Level level = defaultStatusMessage.getLevel();
                Severity severity = ExceptionManager.getSeverity(level);
                buffer.append(String.format("[%s] %s", new Object[]{severity, defaultStatusMessage.getMessage()}));
                System.out.println(buffer.toString());
                buffer.setLength(0);
            }
        }
        return defaultOption;
    }
}

