/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ApplicationProgressEvent;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressModel;
import oracle.install.commons.util.progress.ProgressModelEvent;
import oracle.install.commons.util.progress.ProgressModelListener;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Status;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

public class DefaultTextualProgressUI
implements ProgressUI<Void> {
    private ProgressModel progressModel;
    private static final Logger logger = Logger.getLogger(DefaultTextualProgressUI.class.getName());
    private int dotsOnScreen = 0;
    private Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    public static final int PROGRESS_PER_LINE = 50;
    public static final String PRINT_JOB_PROGRESS_STATUS = "oracle.install.job.printProgresStatus";

    public DefaultTextualProgressUI() {
        this.progressModel = new ProgressModel();
        this.progressModel.addProgressModelListener(new ProgressModelListener(){

            @Override
            public void update(ProgressModelEvent e) {
                if (e.getType() == ProgressModelEvent.Type.JOB_STATUS_CHANGED) {
                    Job job = e.getJob();
                    Status status = job.getStatus();
                    String description = job.getDescription();
                    if (description != null && description.length() > 0) {
                        switch (status) {
                            case SUCCEEDED: 
                            case SUCCEEDED_PARTIALLY: {
                                Application.setApplicationProgress(description, description + " successful.", ApplicationProgressEvent.Type.END);
                                break;
                            }
                            case FAILED: {
                                Application.setApplicationProgress(description, description + " failed.", ApplicationProgressEvent.Type.END);
                                break;
                            }
                            case INPROGRESS: {
                                Application.setApplicationProgress(description, description + " in progress.", ApplicationProgressEvent.Type.START);
                            }
                        }
                    }
                }
            }
        });
    }

    @Override
    public void setCompositeJobs(CompositeJob ... jobs) {
        if (this.progressModel != null) {
            this.progressModel.setCompositeJobs(jobs);
        }
    }

    @Override
    public Void getOwner() {
        return null;
    }

    @Override
    public ProgressModel getProgressModel() {
        return this.progressModel;
    }

    @Override
    public void setLogLocation(String logLocation) {
        logger.log(Level.INFO, "New Log Location " + logLocation);
    }

    @Override
    public void log(Level level, String message, Object ... args) {
        logger.log(level, message, args);
    }

    @Override
    public void reset() {
    }

    @Override
    public void setProgressModel(ProgressModel taskModel) {
        this.progressModel = taskModel;
        this.progressModel.addChangeListener(new ChangeListener(){
            int previousProgress = 0;

            @Override
            public void stateChanged(ChangeEvent e) {
                int currentCount = DefaultTextualProgressUI.this.progressModel.getValue();
                if (currentCount >= this.previousProgress + 5 || currentCount >= 95) {
                    int remainingDots = 50 - DefaultTextualProgressUI.this.dotsOnScreen;
                    if (remainingDots > 0) {
                        for (int i = 0; i < remainingDots; ++i) {
                            System.out.print(".");
                        }
                    }
                    System.out.println("   " + currentCount + "% " + DefaultTextualProgressUI.this.resource.getString("TextualProgress.DONE.text", "Done", new Object[0]));
                    this.previousProgress = currentCount;
                    DefaultTextualProgressUI.this.dotsOnScreen = 0;
                } else if (this.previousProgress < currentCount) {
                    System.out.print("..........");
                    DefaultTextualProgressUI.this.dotsOnScreen = DefaultTextualProgressUI.this.dotsOnScreen + 10;
                }
            }
        });
        this.progressModel.addProgressModelListener(new ProgressModelListener(){

            @Override
            public void update(ProgressModelEvent e) {
                if (e.getType() == ProgressModelEvent.Type.JOB_STATUS_CHANGED) {
                    boolean printProgress;
                    Job job = e.getJob();
                    Status status = job.getStatus();
                    String description = job.getDescription();
                    boolean bl = job.getClientProperty(DefaultTextualProgressUI.PRINT_JOB_PROGRESS_STATUS) == null ? true : (printProgress = Boolean.valueOf(job.getClientProperty(DefaultTextualProgressUI.PRINT_JOB_PROGRESS_STATUS).toString() == "false") == false);
                    if (!(description == null || description.length() <= 0 || job instanceof CompositeJob && ((CompositeJob)job).getJobs().size() != 0)) {
                        switch (status) {
                            case SUCCEEDED: 
                            case SUCCEEDED_PARTIALLY: {
                                if (printProgress) {
                                    System.out.println();
                                    System.out.println(DefaultTextualProgressUI.this.resource.getString("TextualProgress.SUCCEEDED.text", description + " successful.", description));
                                    DefaultTextualProgressUI.this.dotsOnScreen = 0;
                                }
                                Application.setApplicationProgress(description, description + " successful.", ApplicationProgressEvent.Type.END);
                                break;
                            }
                            case FAILED: {
                                if (printProgress) {
                                    System.out.println();
                                    System.out.println(DefaultTextualProgressUI.this.resource.getString("TextualProgress.FAILED.text", description + " failed.", description));
                                    DefaultTextualProgressUI.this.dotsOnScreen = 0;
                                }
                                Application.setApplicationProgress(description, description + " failed.", ApplicationProgressEvent.Type.END);
                                break;
                            }
                            case INPROGRESS: {
                                if (printProgress) {
                                    System.out.println();
                                    System.out.println(DefaultTextualProgressUI.this.resource.getString("TextualProgress.INPROGRESS.text", description + " in progress.", description));
                                    DefaultTextualProgressUI.this.dotsOnScreen = 0;
                                }
                                Application.setApplicationProgress(description, description + " in progress.", ApplicationProgressEvent.Type.START);
                            }
                        }
                    }
                }
            }
        });
    }
}

