/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import oracle.install.commons.swing.treetable.JTreeTableEx;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.CompositeJob;
import oracle.install.commons.util.progress.JobHelper;
import oracle.install.commons.util.progress.Status;
import oracle.install.commons.util.progress.resource.ObjectResourceBundle;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

class StatusCellRenderer
extends DefaultTableCellRenderer {
    private Resource iconTable;
    private Resource stringTable;
    private boolean distinguishCompositeJobStatus;

    public StatusCellRenderer() {
        Application application = Application.getInstance();
        this.iconTable = application.getResource(ObjectResourceBundle.class.getName());
        this.stringTable = application.getResource(StringResourceBundle.class.getName());
        this.distinguishCompositeJobStatus = true;
    }

    public boolean isDistinguishCompositeJobStatus() {
        return this.distinguishCompositeJobStatus;
    }

    public void setDistinguishCompositeJobStatus(boolean compositeJobStatusVisible) {
        this.distinguishCompositeJobStatus = compositeJobStatusVisible;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof Status) {
            Status status = (Status)((Object)value);
            if (column == 0) {
                if (status != Status.PENDING) {
                    this.setIcon(this.iconTable.getIcon(status.toString(), new Object[0]));
                } else {
                    this.setIcon(null);
                }
                this.setText("");
            } else {
                TableModel model;
                Object col2Value;
                boolean distinguish = false;
                String text = this.stringTable.getString(status.toString(), status.toString(), new Object[0]);
                if (!this.distinguishCompositeJobStatus && (col2Value = (model = table.getModel()).getValueAt(row, 1)) instanceof CompositeJob && table instanceof JTreeTableEx) {
                    CompositeJob compositeJob = (CompositeJob)col2Value;
                    JTreeTableEx treeTable = (JTreeTableEx)table;
                    if (treeTable.getTree().isExpanded(row)) {
                        text = "";
                    } else {
                        int count;
                        Status s = compositeJob.getStatus();
                        if (s == Status.FAILED && (count = JobHelper.getJobCountByStatus(compositeJob, Status.FAILED)) != compositeJob.getJobs().size()) {
                            distinguish = true;
                        }
                    }
                }
                if (distinguish) {
                    this.setForeground(Color.gray);
                } else {
                    this.setForeground(Color.black);
                }
                this.setText(text);
                this.setIcon(null);
            }
        }
        return component;
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text" || propertyName == "icon") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

