/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.ClusterVerification;
import oracle.cluster.verification.VerificationException;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.driver.common.SetupMode;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.ScriptExecutor;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.ConfigAssistantJob;
import oracle.install.driver.oui.ConfigHelper;
import oracle.install.driver.oui.ConfigJob;
import oracle.install.driver.oui.ConfigProgressMonitor;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.OUIMetadata;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.PrepareConfigJob;
import oracle.install.driver.oui.PrepareConfigJobEx;
import oracle.install.driver.oui.SessionDetails;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.config.ConfigClient;
import oracle.install.driver.oui.resource.OUIErrorCode;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.emCfg.common.CfwException;
import oracle.sysman.emCfg.common.IAggregate;
import oracle.sysman.emCfg.common.IMicroStepStateReference;
import oracle.sysman.emCfg.types.ActionType;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixCFOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixWinOps;

public abstract class OUIInstallDriver<T>
extends OUISetupDriver<T> {
    public static final String ORAINST_ROOT_SCRIPT_FILE = "orainstRoot.sh";
    private static Logger logger = Logger.getLogger(OUISetupDriver.class.getName());
    private static final boolean isSetupWizard = Boolean.getBoolean("oracle.installer.setupWizard");
    private static final String EXECUTE_CONFIG_TOOL_PREFIX = "oracle.install.config.";

    @Override
    protected void prepareConfig(PrepareConfigJob configJob) throws SetupDriverException, IOException {
        logger.log(Level.INFO, "Preparing configuration");
        boolean isConfigToolFailed = false;
        String runConfigCommand = "";
        ConfigClient configClient = ConfigClient.getConfigClient();
        SetupJob setupJob = configJob.getSetupJob();
        SessionDetails sessionDetails = setupJob.getSessionDetails();
        String oracleHome = sessionDetails.getOHLoc();
        String topAggrId = null;
        String[] topLevelComponent = (String[])sessionDetails.getVariableMap().get("TOPLEVEL_COMPONENT");
        if (topLevelComponent != null) {
            topAggrId = topLevelComponent[0];
        }
        try {
            configClient.init(oracleHome, false, topAggrId);
            IAggregate aggregate = configClient.getTopLevelAggregate();
            if (aggregate == null) {
                configJob.setStatus(Status.SUCCEEDED);
                return;
            }
            Map<String, String> defaultConfigParams = configJob.getDefaultConfigParameters();
            Map<String, Map<String, String>> params = configJob.getTransientParametersMap();
            configClient.updateTransientParameters(params, defaultConfigParams);
            String logDir = oracleHome + File.separator + "cfgtoollogs";
            configClient.setLogDirectory(logDir);
            runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
            OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
            this.updateSetupSummary(configJob);
            configClient.saveSession();
            configClient.endSession();
        }
        catch (CfwException e) {
            throw new SetupDriverException(e);
        }
        logger.log(Level.INFO, "Completed preparation for configuration");
    }

    @Override
    protected void prepareConfig(PrepareConfigJobEx configJob, String oracleHome, String aggCfgID) throws SetupDriverException, IOException {
        logger.log(Level.INFO, "Preparing configuration");
        boolean isConfigToolFailed = false;
        String runConfigCommand = "";
        ConfigClient configClient = ConfigClient.getConfigClient();
        try {
            configClient.init(oracleHome, false, aggCfgID);
            IAggregate aggregate = configClient.getTopLevelAggregate();
            if (aggregate == null) {
                configJob.setStatus(Status.SUCCEEDED);
                return;
            }
            Map<String, String> defaultConfigParams = configJob.getDefaultConfigParameters();
            Map<String, Map<String, String>> params = configJob.getTransientParametersMap();
            configClient.updateTransientParameters(params, defaultConfigParams);
            String logDir = oracleHome + File.separator + "cfgtoollogs";
            configClient.setLogDirectory(logDir);
            runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
            OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
            configClient.saveSession();
            configClient.endSession();
        }
        catch (CfwException e) {
            throw new SetupDriverException(e);
        }
        logger.log(Level.INFO, "Completed preparation for configuration");
    }

    private List<String> getToolsNames(ConfigClient configClient, IMicroStepStateReference[] tools) {
        ArrayList<String> toolsNames = new ArrayList<String>();
        if (configClient != null && tools != null && tools.length > 0) {
            for (IMicroStepStateReference tool : tools) {
                String toolName = null;
                try {
                    toolName = configClient.getToolName(tool);
                }
                catch (CfwException e) {
                    logger.log(Level.WARNING, "Could not get the name of the config tool.", e);
                }
                if (toolName == null) continue;
                toolsNames.add(toolName);
            }
        }
        return toolsNames;
    }

    private boolean isRunningFailedAndPendingJobsOnly() {
        boolean runFailedAndPendingJobsOnly = false;
        CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        if (cmdLineArgumentHandler != null && cmdLineArgumentHandler.isArgumentPassed("executeConfigTools") && !cmdLineArgumentHandler.isArgumentPassed("all")) {
            runFailedAndPendingJobsOnly = true;
            logger.log(Level.INFO, "Only execute the failed and pending config tools.");
        } else if (cmdLineArgumentHandler != null && cmdLineArgumentHandler.isArgumentPassed("executeConfigTools") && cmdLineArgumentHandler.isArgumentPassed("all")) {
            logger.log(Level.INFO, "All the config tools will be executed, even those that have already suceeded.");
        }
        return runFailedAndPendingJobsOnly;
    }

    private IMicroStepStateReference[] removeSkippedConfigTools(ConfigClient configClient, IMicroStepStateReference[] tools) {
        ArrayList<IMicroStepStateReference> toolsList = new ArrayList<IMicroStepStateReference>();
        if (configClient != null && tools != null && tools.length > 0) {
            toolsList.addAll(Arrays.asList(tools));
            for (IMicroStepStateReference tool : tools) {
                String propName;
                boolean execute;
                String name = null;
                try {
                    name = configClient.getToolName(tool);
                }
                catch (CfwException e) {
                    logger.log(Level.INFO, "Could not get the name of config tool.", e);
                }
                if (name == null || (execute = Boolean.valueOf(System.getProperty(propName = EXECUTE_CONFIG_TOOL_PREFIX + name, "true")).booleanValue())) continue;
                logger.log(Level.INFO, "Config tool marked to be skipped: " + name);
                toolsList.remove(tool);
            }
        }
        return toolsList.toArray(new IMicroStepStateReference[0]);
    }

    @Override
    protected void config(ConfigJob configJob, String oracleHome, String aggCfgID, boolean retry) throws SetupDriverException, IOException {
        boolean runFailedAndPendingJobsOnly = this.isRunningFailedAndPendingJobsOnly();
        this.config(configJob, oracleHome, aggCfgID, retry, runFailedAndPendingJobsOnly);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void config(ConfigJob configJob, String oracleHome, String aggCfgID, boolean retry, boolean runFailedAndPendingJobsOnly) throws SetupDriverException, IOException {
        IMicroStepStateReference[] tools;
        ArrayList<IMicroStepStateReference> selectedTools;
        IAggregate aggregate2;
        ConfigProgressMonitor configProgressMonitor;
        ConfigClient configClient;
        String runConfigCommand;
        boolean isConfigToolFailed;
        boolean silentMode;
        ActionType actionType;
        block31: {
            block32: {
                block30: {
                    logger.log(Level.INFO, "Performing Configuration");
                    actionType = ActionType.CONFIGURATION;
                    silentMode = this.getSetupMode() == SetupMode.SILENT;
                    isConfigToolFailed = false;
                    runConfigCommand = "";
                    configClient = ConfigClient.getConfigClient();
                    configProgressMonitor = null;
                    configClient.init(oracleHome, false, aggCfgID);
                    configProgressMonitor = new ConfigProgressMonitor(configJob, null);
                    if (configProgressMonitor != null) {
                        configJob.setConfigProgressMonitor(configProgressMonitor);
                        configProgressMonitor.setProgressUI(this.progressUI);
                    }
                    if ((aggregate2 = configClient.getTopLevelAggregate()) != null) break block30;
                    configJob.setStatus(Status.SUCCEEDED);
                    Summary.getInstance().setSuccessfulConfig(true);
                    try {
                        configClient.unregisterEventListener(configProgressMonitor);
                        return;
                    }
                    catch (CfwException cfwException) {
                        // empty catch block
                    }
                    return;
                }
                Map<String, String> defaultConfigParams = configJob.getDefaultConfigParameters();
                Map<String, Map<String, String>> params = configJob.getTransientParametersMap();
                configClient.updateTransientParameters(params, defaultConfigParams);
                selectedTools = null;
                tools = null;
                if (runFailedAndPendingJobsOnly) {
                    IMicroStepStateReference[] allTools = configClient.getToolsList(false, false, false, true, actionType);
                    List<String> allToolsNames = this.getToolsNames(configClient, allTools);
                    tools = configClient.getToolsList(false, false, true, true, actionType);
                    List<String> toolsNames = this.getToolsNames(configClient, tools);
                    ArrayList<String> succeededTools = new ArrayList<String>();
                    succeededTools.addAll(allToolsNames);
                    succeededTools.removeAll(toolsNames);
                    if (!succeededTools.isEmpty()) {
                        for (String succeededTool : succeededTools) {
                            logger.log(Level.INFO, "Skipping already succeeded config tool: '" + succeededTool + "'");
                        }
                    }
                } else {
                    tools = configClient.getToolsList(false, false, false, true, actionType);
                }
                tools = this.removeSkippedConfigTools(configClient, tools);
                if (retry) break block31;
                configJob.removeAll();
                if (tools != null && tools.length != 0) break block32;
                configJob.setStatus(Status.SUCCEEDED);
                Summary.getInstance().setSuccessfulConfig(true);
                try {
                    configClient.unregisterEventListener(configProgressMonitor);
                    return;
                }
                catch (CfwException allTools) {
                    // empty catch block
                }
                return;
            }
            try {
                for (IMicroStepStateReference entry : tools) {
                    String pluginId = configClient.getToolName(entry);
                    String displayName = configClient.getLocalizedDisplayName(entry);
                    if (displayName == null || displayName.trim().length() == 0) {
                        displayName = pluginId;
                    }
                    boolean required = configClient.isRequiredTool(entry);
                    ConfigAssistantJob task = new ConfigAssistantJob(pluginId, displayName, entry, required);
                    logger.log(Level.INFO, "Created config job for " + pluginId);
                    configJob.add(task);
                }
            }
            catch (CfwException e) {
                try {
                    throw new SetupDriverException(e);
                }
                catch (Throwable throwable) {
                    try {
                        configClient.unregisterEventListener(configProgressMonitor);
                        throw throwable;
                    }
                    catch (CfwException cfwException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            configJob.calibrate();
        }
        if (retry || runFailedAndPendingJobsOnly) {
            selectedTools = new ArrayList<IMicroStepStateReference>();
            List<Job> retriableJobs = configJob.getRetriableJobs();
            block18: for (Job job : retriableJobs) {
                for (IMicroStepStateReference tool : tools) {
                    String pluginId = configClient.getToolName(tool);
                    if (!job.getId().equals(pluginId)) continue;
                    selectedTools.add(tool);
                    continue block18;
                }
            }
        }
        try {
            configClient.registerEventListener(configProgressMonitor);
        }
        catch (CfwException e) {
            throw new SetupDriverException(e);
        }
        String logDir = oracleHome + File.separator + "cfgtoollogs";
        configClient.setLogDirectory(logDir);
        runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
        OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
        if (selectedTools != null) {
            configClient.executeSelectedToolsInAggregate(true, silentMode, false, true, actionType, aggregate2, selectedTools.toArray(new IMicroStepStateReference[0]));
        } else {
            configClient.executeSelectedToolsInAggregate(true, silentMode, false, true, actionType, aggregate2, tools);
        }
        if (isConfigToolFailed = configJob.getStatus() != Status.SUCCEEDED) {
            runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
            OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
        }
        Summary.getInstance().setSuccessfulConfig(!isConfigToolFailed);
        if (isConfigToolFailed) {
            Application.addExitStatus(OUIExitStatus.SUCCESS_MINUS_RECTOOL);
        }
        configClient.saveSession();
        configClient.endSession();
        try {
            configClient.unregisterEventListener(configProgressMonitor);
        }
        catch (CfwException aggregate2) {}
        logger.log(Level.INFO, "Completed Configuration");
    }

    @Override
    public void load() throws SetupDriverException {
        super.load();
        String scratch_path = System.getProperty("oracle.installer.scratchPath");
        if (scratch_path == null) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.SCRATCHPATH_NOT_DEFINED, new Object[0]);
        }
        if (!new File(scratch_path).exists()) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.INSTALL_COMMON_INVALID_SCRATCHPATH, scratch_path);
        }
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        int returnCodeInvCheck = -1;
        try {
            returnCodeInvCheck = apiInstaller.initInstallEnvironment(this.properties, true, 1);
        }
        catch (OiicIllegalStateException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        catch (OiicInstallAPIException e) {
            throw new SetupDriverException((Throwable)e, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        catch (Throwable t) {
            throw new SetupDriverException(t, (ErrorCode)InstallEngineErrorCode.DRIVER_INIT_FAILED, new Object[0]);
        }
        if (returnCodeInvCheck == 1001 && !OiiiInstallAreaControl.isCleanMachine()) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.INVENTORY_INIT_FAILED, new Object[0]);
        }
        String logLocation = System.getProperty("oracle.installer.prereqLogLoc");
        if (logLocation == null || logLocation.length() == 0) {
            String defaultLogLocation = apiInstaller.getDefaultLogLoc();
            if (defaultLogLocation == null) {
                File file = new File("logs");
                file.mkdir();
                if (file.exists() && file.isDirectory()) {
                    defaultLogLocation = file.getAbsolutePath();
                    System.setProperty("oracle.installer.prereqLogLoc", defaultLogLocation);
                }
            } else {
                System.setProperty("oracle.installer.prereqLogLoc", defaultLogLocation);
            }
        }
        OUILogHandler.setDirectLoggingEnabled(true);
        if (!Application.isCommandLineSwitchEnabled("-debug")) {
            String outFile = OUILogHandler.getLogLocation() + File.separator + "oraInstall" + OiiolLoggerUtil.getTimeStamp() + ".out";
            Trace.enableTracing();
            Trace.configure((boolean)false, (boolean)false, (boolean)true, (boolean)true, (String)outFile, (boolean)true, (boolean)true);
            DriverHelper.addCleanupTask(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Trace.close();
                    return null;
                }
            });
        }
        ConfigHelper.init();
        String path = System.getProperty("oracle.installer.scratchPath");
        String startupLocation = System.getProperty("oracle.installer.startup_location");
        String workDir = new File(path).getParentFile().getAbsolutePath();
        String frameworkHome = startupLocation + "/../stage/cvu";
        String refDataFile = frameworkHome + "/cvu_prereq.xml";
        try {
            ClusterVerification clusterVerification = ClusterVerification.getInstance((String)workDir, (String)frameworkHome);
        }
        catch (VerificationException e) {
            ExceptionManager.handle(e);
        }
        if (!DriverHelper.isCVUEnabled()) {
            Application.getInstance().setAttribute("isCVUPrereqExecutionNotSupportedForOS", Boolean.TRUE);
        }
        if (!PlatformInfo.getInstance().isWindows() && !Boolean.getBoolean("oracle.install.skipInventoryGroupCheck") && InventoryInfo.getInstance().isInventoryExist() && (InventoryInfo.getInstance().getUnixGroupName() == null || InventoryInfo.getInstance().getUnixGroupName().isEmpty())) {
            throw new SetupDriverException((ErrorCode)OUIErrorCode.NO_INVENTORY_GROUP_PRESENT_ORAINST_LOC_FILE, new Object[0]);
        }
    }

    @Override
    protected HashMap constructAdditionalProperties(HashMap hashMap) throws SetupDriverException {
        super.constructAdditionalProperties(hashMap);
        String oracle_home = hashMap.get("ORACLE_HOME").toString();
        if (!isSetupWizard) {
            String oracle_home_name = InventoryInfo.getInstance().computeOracleHomeName(oracle_home);
            hashMap.put("ORACLE_HOME_NAME", oracle_home_name);
        }
        String bitvalue = "";
        bitvalue = !isSetupWizard && this.getProperty("ARCHITECTURE") != null ? this.getProperty("ARCHITECTURE") : "64";
        hashMap.put("oracle_install_architecture", bitvalue);
        hashMap.put("oracle_install_ProductName", Application.getInstance().getString("product.name", "", new Object[0]));
        String platformDir = OiixPlatform.getCurrentPlatformDirectoryName();
        hashMap.put("oracle_install_PlatformDirectoryName", platformDir);
        File ouiLibraryPath = new File(oracle_home, "oui/lib/" + platformDir);
        hashMap.put("oracle_install_OUILibraryLocation", ouiLibraryPath.getAbsolutePath());
        if (PlatformInfo.getInstance().isWindows()) {
            hashMap.put("oracle_install_classpath_separator", ";");
        } else {
            hashMap.put("oracle_install_classpath_separator", ":");
        }
        if (PlatformInfo.getInstance().isWindows()) {
            try {
                String windowSysDir = OiixWinOps.getWindowsSystemDirectory();
                if (!PlatformInfo.getInstance().getWinArchitecture().equalsIgnoreCase("x86")) {
                    String syswow64DirLoc;
                    File syswow64dir;
                    File propFile = null;
                    if (isSetupWizard) {
                        String oracleHome = System.getProperty("ORACLE_HOME");
                        propFile = new File(oracleHome, OUIMetadata.ORACLE_HOME_METADATA_FILE_LOC);
                    } else {
                        propFile = new File(OUIMetadata.METADATA_FILE_LOC);
                    }
                    if (propFile != null && propFile.exists() && OUIMetadata.is32BitShiphome(propFile.getAbsolutePath()) && (syswow64dir = new File(syswow64DirLoc = OiixWinOps.getWindowsDirectory() + File.separator + "SysWOW64")).exists() && syswow64dir.isDirectory()) {
                        windowSysDir = syswow64dir.getCanonicalPath();
                    }
                }
                hashMap.put("s_windowsSystemDirectory", windowSysDir);
                hashMap.put("oracle_install_windowsCommandLine", windowSysDir + "\\cmd /c call ");
            }
            catch (Exception e) {
                throw new SetupDriverException(e);
            }
        }
        if (!PlatformInfo.getInstance().isWindows()) {
            String unixMakePath;
            if (OiixPlatform.getCurrentPlatform() == 46 || OiixPlatform.getCurrentPlatform() == 110 || OiixPlatform.getCurrentPlatform() == 227 || OiixPlatform.getCurrentPlatform() == 211) {
                try {
                    unixMakePath = "/usr/bin/make";
                    hashMap.put("oracle_install_UnixMakePath", unixMakePath);
                }
                catch (Exception e) {
                    throw new SetupDriverException(e);
                }
            }
            try {
                unixMakePath = "/usr/ccs/bin/make";
                hashMap.put("oracle_install_UnixMakePath", unixMakePath);
            }
            catch (Exception e) {
                throw new SetupDriverException(e);
            }
        }
        return hashMap;
    }

    @Override
    protected void config(ConfigJob configJob, boolean retry) throws SetupDriverException, IOException {
        boolean runFailedAndPendingJobsOnly = this.isRunningFailedAndPendingJobsOnly();
        this.config(configJob, retry, runFailedAndPendingJobsOnly);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void config(ConfigJob configJob, boolean retry, boolean runFailedAndPendingJobsOnly) throws SetupDriverException, IOException {
        IMicroStepStateReference[] tools;
        ArrayList<IMicroStepStateReference> selectedTools;
        IAggregate aggregate2;
        String oracleHome;
        ConfigProgressMonitor configProgressMonitor;
        ConfigClient configClient;
        String runConfigCommand;
        boolean isConfigToolFailed;
        boolean silentMode;
        ActionType actionType;
        block32: {
            block33: {
                block31: {
                    logger.log(Level.INFO, "Performing Configuration");
                    actionType = ActionType.CONFIGURATION;
                    silentMode = this.getSetupMode() == SetupMode.SILENT;
                    isConfigToolFailed = false;
                    runConfigCommand = "";
                    configClient = ConfigClient.getConfigClient();
                    configProgressMonitor = null;
                    SetupJob setupJob = configJob.getSetupJob();
                    SessionDetails sessionDetails = setupJob.getSessionDetails();
                    oracleHome = sessionDetails.getOHLoc();
                    String topAggrId = null;
                    String[] topLevelComponent = (String[])sessionDetails.getVariableMap().get("TOPLEVEL_COMPONENT");
                    if (topLevelComponent != null) {
                        topAggrId = topLevelComponent[0];
                    }
                    configClient.init(oracleHome, false, topAggrId);
                    configProgressMonitor = new ConfigProgressMonitor(configJob, null);
                    if (configProgressMonitor != null) {
                        configJob.setConfigProgressMonitor(configProgressMonitor);
                        configProgressMonitor.setProgressUI(this.progressUI);
                    }
                    if ((aggregate2 = configClient.getTopLevelAggregate()) != null) break block31;
                    configJob.setStatus(Status.SUCCEEDED);
                    Summary.getInstance().setSuccessfulConfig(true);
                    try {
                        configClient.unregisterEventListener(configProgressMonitor);
                        return;
                    }
                    catch (CfwException cfwException) {
                        // empty catch block
                    }
                    return;
                }
                Map<String, String> defaultConfigParams = configJob.getDefaultConfigParameters();
                Map<String, Map<String, String>> params = configJob.getTransientParametersMap();
                configClient.updateTransientParameters(params, defaultConfigParams);
                selectedTools = null;
                tools = null;
                if (runFailedAndPendingJobsOnly) {
                    IMicroStepStateReference[] allTools = configClient.getToolsList(false, false, false, true, actionType);
                    List<String> allToolsNames = this.getToolsNames(configClient, allTools);
                    tools = configClient.getToolsList(false, false, true, true, actionType);
                    List<String> toolsNames = this.getToolsNames(configClient, tools);
                    ArrayList<String> succeededTools = new ArrayList<String>();
                    succeededTools.addAll(allToolsNames);
                    succeededTools.removeAll(toolsNames);
                    if (!succeededTools.isEmpty()) {
                        for (String succeededTool : succeededTools) {
                            logger.log(Level.INFO, "Skipping already succeeded config tool: '" + succeededTool + "'");
                        }
                    }
                } else {
                    tools = configClient.getToolsList(false, false, false, true, actionType);
                }
                tools = this.removeSkippedConfigTools(configClient, tools);
                if (retry) break block32;
                configJob.removeAll();
                if (tools != null && tools.length != 0) break block33;
                configJob.setStatus(Status.SUCCEEDED);
                Summary.getInstance().setSuccessfulConfig(true);
                try {
                    configClient.unregisterEventListener(configProgressMonitor);
                    return;
                }
                catch (CfwException allTools) {
                    // empty catch block
                }
                return;
            }
            try {
                for (IMicroStepStateReference entry : tools) {
                    String pluginId = configClient.getToolName(entry);
                    String displayName = configClient.getLocalizedDisplayName(entry);
                    if (displayName == null || displayName.trim().length() == 0) {
                        displayName = pluginId;
                    }
                    boolean required = configClient.isRequiredTool(entry);
                    ConfigAssistantJob task = new ConfigAssistantJob(pluginId, displayName, entry, required);
                    logger.log(Level.INFO, "Created config job for " + pluginId);
                    configJob.add(task);
                }
            }
            catch (CfwException e) {
                try {
                    throw new SetupDriverException(e);
                }
                catch (Throwable throwable) {
                    try {
                        configClient.unregisterEventListener(configProgressMonitor);
                        throw throwable;
                    }
                    catch (CfwException cfwException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            configJob.calibrate();
        }
        if (retry || runFailedAndPendingJobsOnly) {
            selectedTools = new ArrayList<IMicroStepStateReference>();
            List<Job> retriableJobs = configJob.getRetriableJobs();
            block18: for (Job job : retriableJobs) {
                for (IMicroStepStateReference tool : tools) {
                    String pluginId = configClient.getToolName(tool);
                    if (!job.getId().equals(pluginId)) continue;
                    selectedTools.add(tool);
                    continue block18;
                }
            }
        }
        try {
            configClient.registerEventListener(configProgressMonitor);
        }
        catch (CfwException e) {
            throw new SetupDriverException(e);
        }
        String logDir = oracleHome + File.separator + "cfgtoollogs";
        configClient.setLogDirectory(logDir);
        runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
        OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
        if (selectedTools != null) {
            configClient.executeSelectedToolsInAggregate(true, silentMode, false, true, actionType, aggregate2, selectedTools.toArray(new IMicroStepStateReference[0]));
        } else {
            configClient.executeSelectedToolsInAggregate(true, silentMode, false, true, actionType, aggregate2, tools);
        }
        if (isConfigToolFailed = configJob.getStatus() != Status.SUCCEEDED) {
            runConfigCommand = OiixCFOps.getCommandForRunConfig((String)oracleHome, (boolean)isConfigToolFailed);
            OiiolTextLogger.writePlugInCommands((String)oracleHome, (String)(runConfigCommand + "\n"), (boolean)isConfigToolFailed, (boolean)true);
        }
        Summary.getInstance().setSuccessfulConfig(!isConfigToolFailed);
        if (isConfigToolFailed) {
            Application.addExitStatus(OUIExitStatus.SUCCESS_MINUS_RECTOOL);
        }
        this.updateSetupSummary(configJob);
        configClient.saveSession();
        configClient.endSession();
        try {
            configClient.unregisterEventListener(configProgressMonitor);
        }
        catch (CfwException aggregate2) {}
        logger.log(Level.INFO, "Completed Configuration");
    }

    public boolean isConfigDisabled() {
        return Application.getInstance().getArguments().contains("-noconfig");
    }

    @Override
    public ScriptExecutor<?> getRootScriptExecutor() {
        return null;
    }
}

