/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.common.ProgressListener;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.driver.oui.resource.StringResourceBundle;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;

public class RemoteCopyHelper {
    private static RemoteCopyHelper instance;
    private static ClusterCmd clusterCmdInst;
    private RemoteOperationResult remoteOperationResult;
    private boolean isResultSetDirty = false;
    public static final Resource resource;
    private static Logger logger;

    public static synchronized RemoteCopyHelper getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (proxyFactory = ProxyFactory.getInstance()).createProxy(RemoteCopyHelper.class)) == null) {
            instance = new RemoteCopyHelper();
        }
        return instance;
    }

    private ClusterCmd getClusterCommand() {
        this.remoteOperationResult = new RemoteOperationResult();
        if (clusterCmdInst == null) {
            clusterCmdInst = new ClusterCmd();
        }
        return clusterCmdInst;
    }

    public boolean dirExists(String remoteNode, String dir) throws ClusterException, ClusterOperationException {
        return this.getClusterCommand().dirExists(remoteNode, dir);
    }

    public void createDirWithPermissionsOnNodes(String[] nodeNames, String dirName, String perm) throws ClusterException {
        try {
            logger.log(Level.INFO, "Creating directory " + dirName + " with permission  " + perm + " on nodes " + Arrays.toString(nodeNames));
            this.getClusterCommand().createDirWithPermissionsOnNodes(nodeNames, dirName, perm);
        }
        catch (ClusterException ce) {
            logger.log(Level.SEVERE, "ClusterException while creating directory " + dirName + " on nodes " + Arrays.toString(nodeNames), ce);
            throw ce;
        }
    }

    public void transferDirStructureToNodes(String oracleHome, String[] remoteNodeNames, String topLevelDir, String includeListFile, boolean includePathnamesCanBeRegex, String excludeListFile, boolean excludePathnamesCanBeRegex, String remoteNodeTempDir, String remoteNodeDestCommonDir, ProgressListener progressListener) throws RemoteFileOperationException, ClusterException {
        try {
            long startTime = 0L;
            if (Application.isCommandLineSwitchEnabled("-debug")) {
                startTime = System.currentTimeMillis();
            }
            this.getClusterCommand().transferDirStructureToNodes(oracleHome, remoteNodeNames, topLevelDir, includeListFile, includePathnamesCanBeRegex, excludeListFile, excludePathnamesCanBeRegex, remoteNodeTempDir, remoteNodeDestCommonDir, true, progressListener);
            if (Application.isCommandLineSwitchEnabled("-debug")) {
                long endTime = System.currentTimeMillis();
                long timeElapsed = endTime - startTime;
                logger.log(Level.FINE, "Time taken to complete remote copy: " + timeElapsed / 1000L + " seconds.");
            }
        }
        catch (RemoteFileOperationException rfopex) {
            logger.log(Level.SEVERE, "RemoteFileOpertionException occurred while copying " + oracleHome + " to remote nodes : " + Arrays.toString(remoteNodeNames), rfopex);
            ArrayList<String> failedNodes = new ArrayList<String>();
            ArrayList<String> nodesWithUnknownStatus = new ArrayList<String>();
            for (String remoteNode : remoteNodeNames) {
                try {
                    int status = rfopex.getStatus(remoteNode);
                    if (status == 0) continue;
                    failedNodes.add(remoteNode);
                }
                catch (NoSuchNodeException e) {
                    nodesWithUnknownStatus.add(remoteNode);
                    logger.log(Level.WARNING, "Remote Copy status is unknown for node : " + remoteNode, e);
                }
            }
            this.remoteOperationResult.setFailedNodes(failedNodes);
            this.remoteOperationResult.setException(rfopex);
            throw rfopex;
        }
        catch (ClusterException clex) {
            logger.log(Level.SEVERE, "ClusterException occurred while copying " + oracleHome + " to remote nodes : " + Arrays.toString(remoteNodeNames), clex);
            throw clex;
        }
    }

    public List<String> getFailedNodes() {
        if (this.remoteOperationResult != null) {
            return this.remoteOperationResult.getFailedNodes();
        }
        return Collections.emptyList();
    }

    public boolean isResultSetDirty() {
        return this.isResultSetDirty;
    }

    public void setResultSetDirty(boolean value) {
        this.isResultSetDirty = value;
    }

    public PlainContent getExtraDetails() {
        StringBuilder strBuilder = new StringBuilder();
        RemoteFileOperationException rfoex = this.remoteOperationResult.getException();
        List<String> failedNodeList = this.remoteOperationResult.getFailedNodes();
        ArrayList<String> nodesWithUnknownStatus = new ArrayList<String>();
        if (rfoex != null && failedNodeList != null && !failedNodeList.isEmpty()) {
            strBuilder.append("<b>" + resource.getString("ErrorMessage.details.titles.cause", "Cause", new Object[0]) + "</b><br>");
            strBuilder.append("&nbsp;-&nbsp;");
            strBuilder.append(StringUtils.textToHtml(rfoex.getLocalizedMessage()) + "<br><br>");
            strBuilder.append("<b>" + resource.getString("ErrorMessage.extraDetails.nodeSpecificErrors", "Summary of the failed nodes", new Object[0]) + "</b><br>");
            for (String failedNode : failedNodeList) {
                if (failedNode == null) continue;
                strBuilder.append("<b>" + failedNode + "</b><br>");
                try {
                    int statusCode = rfoex.getStatus(failedNode);
                    if (statusCode == 1) {
                        String errMsg = rfoex.getErrorMessage(failedNode);
                        if (errMsg != null) {
                            strBuilder.append("&nbsp;-&nbsp;");
                            strBuilder.append(StringUtils.textToHtml(errMsg) + "<br>");
                            continue;
                        }
                        String[] errMsgArray = rfoex.getErrorMessages(failedNode);
                        if (errMsgArray == null || errMsgArray.length <= 0) continue;
                        strBuilder.append(failedNode).append("\n");
                        for (String errMsg1 : errMsgArray) {
                            strBuilder.append("&nbsp;-&nbsp;");
                            strBuilder.append(StringUtils.textToHtml(errMsg1) + "<br>");
                        }
                        continue;
                    }
                    if (statusCode == 2) {
                        Exception ex = rfoex.getException(failedNode);
                        if (ex == null) continue;
                        ArrayList<String> causes = new ArrayList<String>();
                        ExceptionManager.enumCauses(ex, causes);
                        causes.add(0, ex.getLocalizedMessage());
                        if (causes.isEmpty()) continue;
                        String title = resource.getString("ErrorMessage.extraDetails.exceptionDetails", "Exception details", new Object[0]);
                        strBuilder.append("<b>");
                        strBuilder.append(title);
                        strBuilder.append("</b>");
                        for (String cause : causes) {
                            strBuilder.append("<br>");
                            strBuilder.append("&nbsp;-&nbsp;");
                            strBuilder.append(cause);
                        }
                        strBuilder.append("<br>");
                        strBuilder.append("<br>");
                        continue;
                    }
                    logger.log(Level.WARNING, "Remote operation status is unknown for the node : " + failedNode);
                    nodesWithUnknownStatus.add(failedNode);
                    strBuilder.append("&nbsp;-&nbsp;");
                    strBuilder.append(resource.getString("Status.Unknown", "Unknown", new Object[0]));
                    strBuilder.append("<br>");
                }
                catch (NoSuchNodeException nsnex) {
                    logger.log(Level.WARNING, "NoSuchNodeException occurred while fetching remote operation status for node : " + failedNode, nsnex);
                    nodesWithUnknownStatus.add(failedNode);
                }
            }
            PlainContent content = new PlainContent(strBuilder.toString());
            ContentType contentType = ContentType.HTML;
            content.setContentType(contentType);
            content.setTitle(resource.getString("ErrorMessage.extraDetails.message", "Additional Information:", new Object[0]));
            return content;
        }
        return null;
    }

    static {
        resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
        logger = Logger.getLogger(RemoteCopyHelper.class.getName());
    }

    class RemoteOperationResult {
        private RemoteFileOperationException exception;
        private List<String> failedNodes;

        RemoteOperationResult() {
        }

        RemoteOperationResult(List<String> failedNodes, RemoteFileOperationException rfOpEx) {
            this.failedNodes = failedNodes;
            this.exception = rfOpEx;
        }

        void setException(RemoteFileOperationException rfOpEx) {
            this.exception = rfOpEx;
        }

        RemoteFileOperationException getException() {
            return this.exception;
        }

        void setFailedNodes(List<String> failedNodes) {
            this.failedNodes = failedNodes;
        }

        List<String> getFailedNodes() {
            return this.failedNodes;
        }
    }
}

