/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

public class SetupSummary {
    public static final String PROPERTY_READY = "SetupSummary.ready";
    private List<String> messages = new ArrayList<String>();
    private static SetupSummary instance;
    private boolean ready;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private boolean updateSummaryInSetup;

    SetupSummary() {
    }

    public static SetupSummary getInstance() {
        if (instance == null) {
            instance = new SetupSummary();
        }
        return instance;
    }

    public void append(String messg) {
        if (messg != null && !messg.trim().equalsIgnoreCase("")) {
            this.messages.add(messg);
        }
    }

    public String getText() {
        StringBuilder msg = new StringBuilder();
        for (String s : this.messages) {
            msg.append(s.trim());
            msg.append("\n");
        }
        return msg.toString();
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        if (this.ready != ready) {
            boolean oldValue = this.ready;
            this.ready = ready;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_READY, oldValue, this.ready);
        }
    }

    public void beginUpdate() {
        this.setReady(false);
    }

    public void endUpdate() {
        this.setReady(true);
    }

    public boolean isUpdateSummaryInSetup() {
        return this.updateSummaryInSetup;
    }

    public void setUpdateSummaryInSetup(boolean updateSummaryInSetup) {
        this.updateSummaryInSetup = updateSummaryInSetup;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

