/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.action;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.annotation.UIRef;
import oracle.install.commons.flow.validation.annotation.ValidatorRef;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.bean.AutoUpdatesInstallSettings;
import oracle.install.ivw.common.resource.PatchDownloadType;
import oracle.install.ivw.common.util.OracleInstaller;
import oracle.install.ivw.common.util.autoupdates.UpdateManager;
import oracle.install.ivw.common.util.autoupdates.UpdatesCheckEvent;
import oracle.install.ivw.common.validator.AutoUpdatesOptionsValidator;
import oracle.sysman.oii.oiii.OiiiInstallUpdate;

@UIRef(value="AutoUpdatesOptionsUI")
@ValidatorRef(value=AutoUpdatesOptionsValidator.class)
public class AutoUpdatesOptionsAction
extends DefaultAction {
    private Logger logger = Logger.getLogger(AutoUpdatesOptionsAction.class.getName());
    UpdateManager updatesMngr = UpdateManager.getInstance();
    Application application = Application.getInstance();
    Resource resource = this.application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
    String sep = File.separator;

    public Route transition(FlowContext flowContext) {
        boolean standAloneDwld;
        boolean failureRetrievingUpdates;
        block20: {
            OracleInstaller installer;
            AutoUpdatesInstallSettings bean = (AutoUpdatesInstallSettings)((Object)flowContext.getBean(AutoUpdatesInstallSettings.class));
            this.logger.log(Level.FINEST, "In Transition of AutoUpdatesOptionsAction");
            Application application = Application.getInstance();
            Resource resource = application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
            failureRetrievingUpdates = false;
            standAloneDwld = false;
            if (application instanceof OracleInstaller && (installer = (OracleInstaller)Application.getInstance()).getInstallerMode() != null && installer.getInstallerMode() == OracleInstaller.InstallerMode.STANDALONE_DOWNLOAD_MODE) {
                standAloneDwld = true;
            }
            if (bean.getDownloadType() == PatchDownloadType.SKIP_UPDATES) {
                this.logger.log(Level.INFO, "No updates will be downloaded or applied");
                if (flowContext.getFlowControl() != null && !standAloneDwld) {
                    flowContext.getFlowControl().lookAhead(new Route("NO_AUTO_UPDATES"));
                }
                return new Route("NO_AUTO_UPDATES");
            }
            if (bean.getDownloadType() == PatchDownloadType.MYORACLESUPPORT_DOWNLOAD) {
                String downloadMsg = resource.getString("DOWNLOAD_METADATA_STATUS", "Retrieving list of updates", new Object[0]);
                Application.showStatus((String)downloadMsg);
                if (!this.updatesMngr.hasDownloadHappened()) {
                    String scratchPathLoc = System.getProperty("oracle.installer.scratchPath");
                    String destDir = scratchPathLoc + File.separator + "metadata";
                    try {
                        this.updatesMngr.downloadAndParseMetadata(bean.getMyoracleSupportDetails(), bean.getHttpProxySettings(), destDir);
                    }
                    catch (Exception e) {
                        failureRetrievingUpdates = true;
                        Application.hideStatus();
                        this.logger.log(Level.SEVERE, "Exception occurred while retrieving metadata", e);
                        ExceptionManager.handle((Throwable)e);
                        if (flowContext != null && flowContext.getFlowControl() != null) {
                            flowContext.getFlowControl().stop();
                        }
                        break block20;
                    }
                }
                String metadata = this.updatesMngr.getDownloadedMetadata();
                String homeType = application.getString("product.name", null, new Object[0]);
                int platform = PlatformInfo.getInstance().getARUId();
                try {
                    if (metadata != null && metadata.length() > 0) {
                        this.updatesMngr.parseMetadata(metadata, platform, homeType);
                    }
                    break block20;
                }
                catch (Exception e) {
                    failureRetrievingUpdates = true;
                    Application.hideStatus();
                    this.logger.log(Level.SEVERE, "Exception occurred while retrieving metadata", e);
                    ExceptionManager.handle((Throwable)e);
                    if (flowContext != null && flowContext.getFlowControl() != null) {
                        flowContext.getFlowControl().stop();
                    }
                    break block20;
                }
            }
            if (bean.getDownloadType() == PatchDownloadType.OFFLINE_UPDATES) {
                this.logger.log(Level.INFO, "Offline option selected");
                bean.setApplyUpdates(true);
                String downloadLoc = bean.getPatchDownloadLocation();
                String destDir = downloadLoc + File.separator + "metadata";
                File[] metadataDir = new File(destDir).listFiles();
                String homeType = application.getString("product.name", null, new Object[0]);
                int platform = PlatformInfo.getInstance().getARUId();
                try {
                    if (metadataDir != null && metadataDir[0] != null && metadataDir[0].getName() != null) {
                        String parseMessage = resource.getString("DOWNLOAD_METADATA_STATUS", "Retrieving list of updates", new Object[0]);
                        Application.showStatus((String)parseMessage);
                        OiiiInstallUpdate.setDownloadDir((String)new File(downloadLoc, "LatestUpdates").getPath());
                        OiiiInstallUpdate.setFlagUseLocalCopy((boolean)true);
                        this.updatesMngr.parseMetadata(new File(metadataDir[0], "patches.xml").getAbsolutePath(), platform, homeType);
                    }
                }
                catch (Exception e) {
                    Application.hideStatus();
                    failureRetrievingUpdates = true;
                    this.logger.log(Level.SEVERE, "Exception occurred while retrieving metadata", e);
                    ExceptionManager.handle((Throwable)e);
                    if (flowContext == null || flowContext.getFlowControl() == null) break block20;
                    flowContext.getFlowControl().stop();
                }
            }
        }
        if (!(failureRetrievingUpdates || this.updatesMngr.getListOfUpdatesSelected() != null && this.updatesMngr.getListOfUpdatesSelected().size() != 0)) {
            Application.hideStatus();
            this.updatesMngr.fireUpdatesCheckEvent(new UpdatesCheckEvent(null, UpdatesCheckEvent.Type.NOUPDATES_FOUND));
            this.logger.log(Level.INFO, "No updates were found.");
            if (standAloneDwld) {
                Application.getInstance().shutdown();
            } else if (flowContext != null && flowContext.getFlowControl() != null) {
                flowContext.getFlowControl().lookAhead(new Route("NO_AUTO_UPDATES"));
            }
            return new Route("NO_AUTO_UPDATES");
        }
        return Route.SUCCESS;
    }
}

