/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.util.List;
import java.util.Locale;
import oracle.install.commons.base.driver.common.Installer;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.ProductInfo;

public class OracleInstaller
extends Installer {
    public static InstallerMode autoUpdatesMode;
    public static final String CLI_CONFIG_XML = "/oracle/install/driver/oui/resource/install_cli_args.xml";

    public OracleInstaller() {
        this.init();
    }

    protected void init() {
        ProductInfo productInfo = ProductInfo.getInstance();
        Locale locale = productInfo.getSuitableLocale();
        Locale.setDefault(locale);
        super.setLocale(locale);
        CommandLineArgumentHandler.registerSupportedCommandtArgsXML((String)CLI_CONFIG_XML);
        System.setProperty("application.commandline.validateForMandatoryDependentArgs", "true");
        if (PlatformInfo.getInstance().isWindows()) {
            System.setProperty("application.commandline.toolName", "setup.exe");
        } else {
            System.setProperty("application.commandline.toolName", "runInstaller");
        }
        System.setProperty("application.commandline.currentContextId", "Install");
    }

    public InstallerMode getInstallerMode() {
        return autoUpdatesMode;
    }

    public void setInstallerMode(InstallerMode autoUpdatesMode) {
        OracleInstaller.autoUpdatesMode = autoUpdatesMode;
    }

    protected void processArguments(List<String> args) throws IllegalArgumentException {
        if (args != null) {
            for (String s : args) {
                if (!s.equalsIgnoreCase("-downloadUpdates")) continue;
                this.setInstallerMode(InstallerMode.STANDALONE_DOWNLOAD_MODE);
                Resource resource = Application.getInstance().getResource("oracle.install.commons.base.resource.StringResourceBundle");
                String downloadText = resource.getString("wizard.btnDownload.text", null, new Object[0]);
                if (downloadText == null) break;
                resource.setProperty("wizard.btnFinish.text", (Object)downloadText);
                break;
            }
        }
        super.processArguments(args);
    }

    protected void run() {
        if (this.getInstallerMode() != null && this.getInstallerMode() == InstallerMode.STANDALONE_DOWNLOAD_MODE) {
            Resource autoUpdatesResource = Application.getInstance().getResource(AutoUpdatesDialogLabelResID.class.getName());
            String autoUpdatesOptionsText = autoUpdatesResource.getString("standAloneAutoUpdatesProvideMOSDetails.name", "Provide My Oracle Support credentials", new Object[0]);
            String autoUpdatesDownloadText = autoUpdatesResource.getString("standAloneAutoUpdatesDownload.name", "Download software updates", new Object[0]);
            Resource resource = Application.getInstance().getDefaultResource();
            resource.setProperty("AutoUpdatesOptionsUI.name", (Object)autoUpdatesOptionsText);
            resource.setProperty("UpdatesListUI.name", (Object)autoUpdatesDownloadText);
        }
        super.run();
    }

    protected void loadCmdLineVarsToBean(InstallSettings installSettings) {
        CommandLineArgumentHandler cmdlineArgHandler = CommandLineArgumentHandler.getInstance();
        if (cmdlineArgHandler.isArgumentPassed("ORACLE_HOME")) {
            this.ORACLE_HOME = cmdlineArgHandler.getArgumentValue("ORACLE_HOME");
            if (this.ORACLE_HOME != null && this.ORACLE_HOME.length() > 0) {
                installSettings.setOracleHome(this.ORACLE_HOME);
            }
        }
        if (cmdlineArgHandler.isArgumentPassed("ORACLE_BASE")) {
            this.ORACLE_BASE = cmdlineArgHandler.getArgumentValue("ORACLE_BASE");
            if (this.ORACLE_BASE != null && this.ORACLE_BASE.length() > 0) {
                installSettings.setOracleBase(this.ORACLE_BASE);
            }
        }
    }

    public static enum InstallerMode {
        STANDALONE_DOWNLOAD_MODE;

    }
}

