/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.io.File;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.NodeScaler;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.InstallException;
import oracle.install.library.util.InventoryInfo;

public class OracleNodeScaler
extends NodeScaler {
    private static Logger logger = Logger.getLogger(OracleNodeScaler.class.getName());
    private static NodeScaler scaler;
    public static final String DB_FLOW_CONFIG = "/oracle/install/ivw/db/resource/db-nodescaler-flow-config.xml";
    public static final String CRS_APPLICATION_CONFIG = "/oracle/install/ivw/crs/resource/crs-nodescaler-application-config.xml";
    public static final String CRS_FLOW_CONFIG = "/oracle/install/ivw/crs/resource/crs-nodescaler-flow-config.xml";
    public static final String DB_APPLICATION_CONFIG = "/oracle/install/ivw/db/resource/db-nodescaler-application-config.xml";

    public static void main(String[] args) {
        block13: {
            String oracleHome = "";
            for (String arg : args) {
                if (!arg.contains("ORACLE_HOME")) continue;
                oracleHome = arg.split("=")[1];
                break;
            }
            if (oracleHome != null && oracleHome.length() > 0) {
                File ohFile = null;
                try {
                    ohFile = new File(oracleHome);
                }
                catch (NullPointerException e) {
                    logger.severe("Oracle Home is null.");
                }
                if (ohFile != null && ohFile.exists()) {
                    try {
                        InventoryInfo invInfo = InventoryInfo.getInstance();
                        if (invInfo.isInventoryExist()) {
                            String invLoc = invInfo.getDefaultInventoryLoc();
                            if (invInfo.isHomeWithLocationExist(oracleHome)) {
                                Class<?> clazz;
                                if (invInfo.getComp(oracleHome, "oracle.crs") != null && (scaler = (NodeScaler)Application.getInstance(clazz = Class.forName("oracle.install.ivw.crs.driver.CRSNodeScaler"))) != null) {
                                    scaler.startup(CRS_APPLICATION_CONFIG, CRS_FLOW_CONFIG, args);
                                }
                                if (invInfo.getComp(oracleHome, "oracle.server") != null && (scaler = (NodeScaler)Application.getInstance(clazz = Class.forName("oracle.install.ivw.db.driver.DBNodeScaler"))) != null) {
                                    scaler.startup(DB_APPLICATION_CONFIG, DB_FLOW_CONFIG, args);
                                }
                                break block13;
                            }
                            throw new InstallException((ErrorCode)CommonErrorCode.ADD_NODE_LOCAL_HOME_NOT_IN_INVENTORY, invLoc);
                        }
                        logger.severe("Inventory does not exist.");
                    }
                    catch (Exception e) {
                        ExceptionManager.handle((Throwable)e);
                    }
                } else {
                    logger.severe("Oracle home is null or does not exist.");
                }
            } else {
                logger.severe("Oracle home is null or empty.");
            }
        }
    }
}

