/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FilePermission;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.util.StringTokenizer;
import oracle.install.library.util.InstallResourceBundle;

public class FileParser {
    public String getValueFromFile(String fileName, String valToGet, String delimiter) throws Exception {
        String retval = "";
        String DEF_DELIMIT = "=";
        String source = fileName;
        String val = valToGet;
        String delimit = delimiter;
        try {
            String str;
            File inputFile = new File(source);
            if (!inputFile.exists()) {
                String ParentDir = inputFile.getParent();
                try {
                    AccessController.checkPermission(new FilePermission(ParentDir, "read,execute"));
                }
                catch (SecurityException e) {
                    String exString = InstallResourceBundle.getString("oracle.install.library.resource.CommonErrorResID", "PARENTDIR_PERMISSION_EXCEPTION");
                    throw new Exception(exString);
                }
                String exString = InstallResourceBundle.getString("oracle.install.library.resource.CommonErrorResID", "FILENOTFOUND_EXCEPTION");
                throw new Exception(exString);
            }
            if (!inputFile.isFile()) {
                String exString = InstallResourceBundle.getString("oracle.install.library.resource.CommonErrorResID", "NOT_REGULARFILE_EXCEPTION");
                throw new Exception(exString);
            }
            if (!inputFile.canRead()) {
                String exString = InstallResourceBundle.getString("oracle.install.library.resource.CommonErrorResID", "FILENOTREADABLE_EXCEPTION");
                throw new Exception(exString);
            }
            FileReader in = new FileReader(inputFile);
            BufferedReader inp = new BufferedReader(in);
            while ((str = inp.readLine()) != null) {
                StringTokenizer st;
                String val2;
                if (delimit == null || delimit == "") {
                    delimit = DEF_DELIMIT;
                }
                if (!(val2 = (st = new StringTokenizer(str, delimit)).nextToken()).equals(val)) continue;
                retval = val2 = st.nextToken();
                break;
            }
            if (retval == "") {
                String exString = InstallResourceBundle.getString("oracle.install.library.resource.CommonErrorResID", "STRINGNOTFOUND_EXCEPTION");
                throw new Exception(exString);
            }
            inp.close();
            in.close();
        }
        catch (IOException e) {
            String exString = InstallResourceBundle.getString("oracle.install.library.resource.CommonErrorResID", "IO_EXCEPTION");
            throw new Exception(exString);
        }
        catch (Exception e) {
            String exString = InstallResourceBundle.getString("oracle.install.library.resource.CommonErrorResID", "EXCEPTION");
            throw new Exception(exString);
        }
        return new String(retval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertyFromTextFile(File input, String key) {
        String val = null;
        InputStreamReader fr = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(input));
            String curLine = "";
            while ((curLine = br.readLine()) != null) {
                if ((curLine = curLine.replaceAll(" ", "")).startsWith("#") || curLine.indexOf(key) == -1) continue;
                val = curLine.substring(curLine.indexOf(key) + key.length() + 1);
                break;
            }
        }
        catch (Exception ex) {
            val = "";
        }
        finally {
            try {
                br.close();
                fr.close();
            }
            catch (Exception exception) {}
        }
        return val;
    }

    public static void main(String[] args) {
        FileParser gp = new FileParser();
        String retVal = "";
        try {
            retVal = gp.getValueFromFile("d:\\bkt.txt", "name", "=");
            System.out.println("Return value is " + retVal);
        }
        catch (Exception oqe) {
            oqe.printStackTrace();
        }
    }
}

