/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.Hashtable;
import oracle.opatch.opatchlogger.OLogger;

public abstract class MultiClassLoader
extends ClassLoader {
    private Hashtable classes = new Hashtable();
    private char classNameReplacementChar;
    protected boolean monitorOn = false;
    protected boolean sourceMonitorOn = true;

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    public synchronized Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        StringBuffer buff = new StringBuffer("MultiClassLoader.loadClass(");
        buff.append(className);
        buff.append(", ");
        buff.append(resolveIt);
        buff.append(")");
        OLogger.debug(buff);
        Class<?> result = (Class<?>)this.classes.get(className);
        if (result != null) {
            buff = new StringBuffer("Returning from the cache.");
            OLogger.debug(buff);
            return result;
        }
        try {
            result = super.findSystemClass(className);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
            byte[] classBytes = this.loadClassBytes(className);
            if (classBytes == null) {
                throw new ClassNotFoundException();
            }
            result = this.defineClass(className, classBytes, 0, classBytes.length);
            if (result == null) {
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.classes.put(className, result);
            return result;
        }
    }

    public void setClassNameReplacementChar(char replacement) {
        this.classNameReplacementChar = replacement;
    }

    protected abstract byte[] loadClassBytes(String var1);

    public String formatClassName(String className) {
        if (this.classNameReplacementChar == '\u0000') {
            return className.replace('.', '/') + ".class";
        }
        return className.replace('.', this.classNameReplacementChar) + ".class";
    }

    public String formatPropertiesName(String name) {
        if (this.classNameReplacementChar == '\u0000') {
            return name.replace('.', '/') + ".properties";
        }
        return name.replace('.', this.classNameReplacementChar) + ".properties";
    }
}

