/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.Stack;
import oracle.opatch.ApplySessionStateManager;
import oracle.opatch.ChangeState;
import oracle.opatch.NonChangeState;
import oracle.opatch.OPatchStateManager;
import oracle.opatch.RollbackSessionStateManager;
import oracle.opatch.VersionSessionStateManager;

public class OPatchStateManagerFactory {
    private static OPatchStateManager stateManager;
    private static Stack<OPatchStateManager> stateManagerStack;

    public static void initializeSpecifiedSessionStateMangaer(String sessionType, String patchLoc) {
        if (null != stateManager) {
            stateManagerStack.push(stateManager);
        }
        if (sessionType.equals("apply")) {
            stateManager = new ApplySessionStateManager(patchLoc);
        }
        if (sessionType.equals("rollback")) {
            stateManager = new RollbackSessionStateManager(patchLoc);
        }
        if (sessionType.equals("version")) {
            stateManager = new VersionSessionStateManager();
        }
    }

    public static OPatchStateManager getInstance() {
        if (null == stateManager) {
            stateManager = new OPatchStateManager("", "");
            stateManager.insertStateEntry(new NonChangeState());
        }
        return stateManager;
    }

    public static OPatchStateManager getChangeStateInstance() {
        stateManager = new OPatchStateManager("", "");
        stateManager.insertStateEntry(new ChangeState());
        return stateManager;
    }

    public static void fallBackToPreviousStateManager() {
        if (!stateManagerStack.empty()) {
            stateManager = stateManagerStack.pop();
        }
    }

    static {
        stateManagerStack = new Stack();
    }
}

