/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.CompositePatchCategorizer;
import oracle.opatch.conflicttextualinterpreter.ConflictMap;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelationDefinition;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.BuildRelationPatchMap;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexKeyPair;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.SelectBetterPatchOneOffEngine;
import oracle.opatch.opatchprereq.ICheckPatchPrereqEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConflictMapBuilderUtil {
    public void selectBetterPatchAgainstOH(Collection<IPatch> pis, Collection<IPatch> pohs, ConflictMap conflictMap) {
        BuildRelationPatchMap build = new BuildRelationPatchMap();
        SelectBetterPatchOneOffEngine engine = new SelectBetterPatchOneOffEngine();
        HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res = new HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>>();
        HashMap<String, IPatch> pisMap = new HashMap<String, IPatch>(pis.size());
        HashMap<String, IPatch> pohsMap = new HashMap<String, IPatch>(pohs.size());
        this.oneOffEntryAdapter(pis, pisMap);
        OneOffEntry[] pohOneOffs = this.oneOffEntryAdapter(pohs, pohsMap);
        HashMap hm = build.buildDuplicatePohMap(pohOneOffs);
        this.initResult(res);
        CompositePatchCategorizer.buildPSURelation(pis, pohs, conflictMap);
        for (IPatch pi : pis) {
            IPatch pohWithSameId;
            String[] bugsPi;
            IndexKeyPair piKeyPair;
            OneOffEntry poh;
            OneOffEntry piOneOff = pi.getOneOffEntry();
            this.buildOverlayAndPrereqRelation(pi, pisMap, pohsMap);
            if (pi.isComposite()) continue;
            String langPi = this.norm(piOneOff.getPatchLanguage());
            if (langPi.equals("")) {
                langPi = "en";
            }
            if ((poh = (OneOffEntry)hm.get(piKeyPair = new IndexKeyPair(langPi, bugsPi = piOneOff.getBugIDsFixed()))) == null && (pohWithSameId = pohsMap.get(piOneOff.getPatchID())) != null) {
                poh = pohWithSameId.getOneOffEntry();
                String langPoh = poh.getPatchLanguage();
                if (langPoh.equals("")) {
                    langPoh = "en";
                }
                if (!langPoh.equals(langPi)) {
                    poh = null;
                }
            }
            if (poh == null) continue;
            ICheckPatchPrereqEngine.Result result = engine.selectBetterPatchAgainstOh(poh, piOneOff, res);
            this.buildDuplicateRelation(piOneOff, poh, result, conflictMap, pisMap, pohsMap);
        }
        for (IPatch poh : pohs) {
            this.buildOverlayAndPrereqRelation(poh, pisMap, pohsMap);
        }
        res.clear();
        res = null;
    }

    private void buildOverlayAndPrereqRelation(IPatch pi, HashMap<String, IPatch> pisMap, HashMap<String, IPatch> pohsMap) {
        String[] overlays;
        IPatch poh;
        String[] prereqs;
        for (String prereq : prereqs = pi.getOneOffEntry().getPrereqPatchIDs()) {
            pi.addPrereq(prereq);
            poh = pohsMap.get(prereq);
            if (poh != null) {
                poh.addBeingPrereq(pi.getPatchId());
            }
            if ((poh = pisMap.get(prereq)) == null) continue;
            poh.addBeingPrereq(pi.getPatchId());
        }
        for (String overlay : overlays = pi.getOneOffEntry().getOverLayPatchIDs()) {
            pi.addOverlay(overlay);
            poh = pohsMap.get(overlay);
            if (poh != null) {
                poh.addBeingOverlay(pi.getPatchId());
            }
            if ((poh = pisMap.get(overlay)) == null) continue;
            poh.addBeingOverlay(pi.getPatchId());
        }
    }

    private void buildPSURelation(IPatch pi, ConflictMap conflictMap, HashMap<String, IPatch> pisMap, HashMap<String, IPatch> pohsMap) {
        boolean higherPSU = false;
        if (pi.isTopLevelPSU()) {
            Collection<IPatch> subPatches = pi.getSubPatches();
            for (IPatch subPatch : subPatches) {
                IPatch poh;
                OneOffEntry pohOneOff;
                String pohTopPSU;
                String patchId = subPatch.getPatchId();
                if (!pohsMap.containsKey(patchId) || !pohsMap.containsKey(pohTopPSU = (pohOneOff = (poh = pohsMap.get(patchId)).getOneOffEntry()).getConstituentActiveField())) continue;
                poh = pohsMap.get(pohTopPSU);
                if (poh.getSubPatches().size() < pi.getSubPatches().size()) {
                    conflictMap.addGenericRelation(pi, poh, NPatchRelationDefinition.RelationDefinition.HIGHERPSU);
                    conflictMap.addGenericRelation(poh, pi, NPatchRelationDefinition.RelationDefinition.LOWERPSU);
                    higherPSU = true;
                    break;
                }
                conflictMap.addGenericRelation(pi, poh, NPatchRelationDefinition.RelationDefinition.LOWERPSU);
                conflictMap.addGenericRelation(poh, pi, NPatchRelationDefinition.RelationDefinition.HIGHERPSU);
                break;
            }
        }
    }

    private void buildDuplicateRelation(OneOffEntry piOneOff, OneOffEntry pohOneOff, ICheckPatchPrereqEngine.Result result, ConflictMap conflictMap, HashMap<String, IPatch> pisMap, HashMap<String, IPatch> pohsMap) {
        IPatch pi = null;
        IPatch poh = null;
        pi = pisMap.get(piOneOff.getID());
        poh = pohsMap.get(pohOneOff.getID());
        if (poh == null) {
            poh = pisMap.get(pohOneOff.getID());
        }
        if (result == ICheckPatchPrereqEngine.Result.BETTER) {
            conflictMap.addGenericRelation(pi, poh, NPatchRelationDefinition.RelationDefinition.BETTER);
            conflictMap.addGenericRelation(poh, pi, NPatchRelationDefinition.RelationDefinition.WORSE);
        } else if (result == ICheckPatchPrereqEngine.Result.WORSE) {
            conflictMap.addGenericRelation(pi, poh, NPatchRelationDefinition.RelationDefinition.WORSE);
            conflictMap.addGenericRelation(poh, pi, NPatchRelationDefinition.RelationDefinition.BETTER);
        } else if (result == ICheckPatchPrereqEngine.Result.SAME) {
            conflictMap.addGenericRelation(pi, poh, NPatchRelationDefinition.RelationDefinition.DUPLICATE);
            conflictMap.addGenericRelation(poh, pi, NPatchRelationDefinition.RelationDefinition.DUPLICATE);
        }
    }

    private OneOffEntry[] oneOffEntryAdapter(Collection<IPatch> patches, HashMap<String, IPatch> ipatchesMap) {
        OneOffEntry[] oneOffs = new OneOffEntry[patches.size()];
        int i2 = 0;
        for (IPatch patch : patches) {
            if (!patch.getBugs().isEmpty()) {
                oneOffs[i2++] = patch.getOneOffEntry();
            }
            ipatchesMap.put(patch.getPatchId(), patch);
        }
        this.addSubPatchToPSU(patches, ipatchesMap);
        return oneOffs;
    }

    protected void addSubPatchToPSU(Collection<IPatch> patches, HashMap<String, IPatch> ipatchesMap) {
        if (ipatchesMap == null) {
            ipatchesMap = new HashMap(patches.size());
        }
        if (ipatchesMap.isEmpty()) {
            for (IPatch patch : patches) {
                ipatchesMap.put(patch.getPatchId(), patch);
            }
        }
        for (IPatch ipatch : patches) {
            String[] subPatchIds;
            OneOffEntry oneOff = ipatch.getOneOffEntry();
            if (!ipatch.isTopLevelPSU()) continue;
            ipatch.getSubPatches().clear();
            for (String subPatchId : subPatchIds = CompositePatchObject.getConstituentList(oneOff.getCompositeFileLocation())) {
                if (subPatchId.equals(oneOff.getID()) || !ipatchesMap.containsKey(subPatchId)) continue;
                ipatch.addSubPatch(ipatchesMap.get(subPatchId));
            }
        }
    }

    private void initResult(HashMap<ICheckPatchPrereqEngine.Result, ArrayList<OneOffEntry>> res) {
        res.put(ICheckPatchPrereqEngine.Result.SAME, new ArrayList());
        res.put(ICheckPatchPrereqEngine.Result.WORSE, new ArrayList());
        res.put(ICheckPatchPrereqEngine.Result.BETTER, new ArrayList());
        res.put(ICheckPatchPrereqEngine.Result.DIFF, new ArrayList());
    }

    private String norm(String s) {
        return s == null ? "" : s.trim();
    }

    protected void buildOverlayAndPrereqRelation(Collection<IPatch> pohs, HashMap<String, IPatch> pohsMap) {
        HashMap<IPatch, IPatch> addOverlayMap = new HashMap<IPatch, IPatch>();
        HashMap<String, IPatch> upiPohMap = new HashMap<String, IPatch>(pohs.size());
        for (IPatch poh : pohs) {
            String[] overlays;
            String[] prereqs = poh.getOneOffEntry().getPrereqPatchIDs();
            for (String prereq : prereqs) {
                poh.addPrereq(prereq);
            }
            for (String overlay : overlays = poh.getOneOffEntry().getOverLayPatchIDs()) {
                poh.addOverlay(overlay);
                if (!pohsMap.containsKey(overlay)) continue;
                IPatch overlayPatch = pohsMap.get(overlay);
                if (poh.isComposite() || !overlayPatch.isComposite()) continue;
                addOverlayMap.put(poh, overlayPatch);
            }
            upiPohMap.put(poh.getOneOffEntry().getPSENumber(), poh);
        }
        for (IPatch overlay : addOverlayMap.keySet()) {
            IPatch compositePatch = (IPatch)addOverlayMap.get(overlay);
            for (String overlayId : compositePatch.getOverlaysID()) {
                overlay.addOverlay(overlayId);
            }
            for (String overridUPI : compositePatch.getOverridingUPIs()) {
                if (!upiPohMap.containsKey(overridUPI)) continue;
                for (String overlayId : ((IPatch)upiPohMap.get(overridUPI)).getOverlaysID()) {
                    overlay.addOverlay(overlayId);
                }
            }
        }
    }
}

