/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.GraphHelper;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.opatchlogger.OLogger;

public class FinalConflictResolution
implements IStep {
    public void process(IConflictMap map, INPatchPlan plan) {
        this.generateCanGoList(map, plan);
        this.sortCanGoListByTopo(plan);
        Collections.sort((List)plan.getAutoRollbackPatches(), new Comparator<IPatch>(){

            @Override
            public int compare(IPatch p1, IPatch p2) {
                OneOffEntry o1 = p1.getOneOffEntry();
                OneOffEntry o2 = p2.getOneOffEntry();
                return o2.getAppliedDate().compareTo(o1.getAppliedDate());
            }
        });
    }

    private void generateCanGoList(IConflictMap map, INPatchPlan plan) {
        Collection<IPatch> pis = map.getPi();
        for (IPatch pi : pis) {
            if (!map.getRelations(pi).isEmpty()) {
                plan.addConflictedPatches(pi);
                continue;
            }
            plan.addCanAppliedPatches(pi);
        }
        Collection<IPatch> noNeedPatches = plan.getNotNeededPatches();
        plan.getCanAppliedPatches().removeAll(noNeedPatches);
    }

    private void sortCanGoListByTopo(INPatchPlan plan) {
        GraphHelper graphHelper = new GraphHelper();
        ArrayList<IPatch> sortedCanGoList = new ArrayList<IPatch>();
        Collection sortedCollection = graphHelper.topologicalSort(plan.getCanAppliedPatches());
        for (IPatch patch : sortedCollection) {
            sortedCanGoList.add(patch);
        }
        Collections.reverse(sortedCanGoList);
        plan.setCanAppliedPatches(sortedCanGoList);
    }

    private void validateConflictMap(IConflictMap map) {
        for (IPatch pi : map.getPi()) {
            if (map.getRelations(pi).isEmpty()) continue;
            NPatchRelations relations = map.getRelations(pi);
            ArrayList<NPatchRelation> relationList = new ArrayList<NPatchRelation>();
            relationList.addAll(relations.getConflicts());
            relationList.addAll(relations.getDuplicates());
            relationList.addAll(relations.getSubsets());
            relationList.addAll(relations.getSupersets());
            relationList.addAll(relations.getBetters());
            relationList.addAll(relations.getWorses());
            relationList.addAll(relations.getHigherPSUs());
            relationList.addAll(relations.getLowerPSUs());
            for (NPatchRelation reLation : relationList) {
                OLogger.debug("reLation :  " + reLation);
            }
            throw new RuntimeException(pi.getPatchId() + "has relation not resolved.");
        }
    }
}

