/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import oracle.opatch.OPatchEnv;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexPair;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NApplyDataSerializer {
    public void serializeFileVersion(String serialFilePath, Map<String, String> FV) throws IOException {
        StringBuffer buffer = new StringBuffer();
        this.appendFileName(serialFilePath, buffer);
        for (String filename : FV.keySet()) {
            String escapedFilename = new String(filename.replace(" ", "\\ "));
            buffer.append(escapedFilename);
            buffer.append("=");
            buffer.append(FV.get(filename));
            buffer.append("\n");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    private void appendFileName(String serialFilePath, StringBuffer buffer) {
        String fileName = serialFilePath.substring(serialFilePath.lastIndexOf(File.separator) + 1);
        buffer.append("fv_file_name");
        buffer.append("=");
        buffer.append(fileName);
        buffer.append("\n");
    }

    public void serializeFileVersionList(String serialFilePath, Map<String, List<String>> FV) throws IOException {
        StringBuffer buffer = new StringBuffer();
        this.appendFileName(serialFilePath, buffer);
        for (String filename : FV.keySet()) {
            String escapedFilename = new String(filename.replace(" ", "\\ "));
            List<String> verionList = FV.get(filename);
            if (verionList.isEmpty()) continue;
            StringBuilder verBuff = new StringBuilder();
            for (int i2 = 0; i2 < verionList.size(); ++i2) {
                verBuff.append(verionList.get(i2));
                if (i2 == verionList.size() - 1) continue;
                verBuff.append(",");
            }
            buffer.append(escapedFilename);
            buffer.append("=");
            buffer.append(verBuff.toString());
            buffer.append("\n");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    public void serializeUnzipActionLoc(String serialFilePath, Map<String, String> fileMap) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (String hash : fileMap.keySet()) {
            String escapedFilename = new String(hash.replace(" ", "\\ "));
            String fileName = fileMap.get(hash);
            if (OPatchEnv.isWindows()) {
                fileName = fileName.replace(File.separator, "\\\\");
            }
            buffer.append(escapedFilename);
            buffer.append("=");
            buffer.append(fileName);
            buffer.append("\n");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath, true));
        writer.write(buffer.toString());
        writer.close();
    }

    public void serializeUnchangedFile(String serialFilePath, Map<String, Boolean> fileMap) throws IOException {
        StringBuffer buffer = new StringBuffer();
        Set<Map.Entry<String, Boolean>> entrySet = fileMap.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            String fileName = entry.getKey();
            if (OPatchEnv.isWindows()) {
                fileName = fileName.replace(File.separator, "\\\\");
            }
            buffer.append(fileName);
            buffer.append("=");
            buffer.append(fileMap.get(entry.getKey()));
            buffer.append("\n");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> deserializeFileVersion(String serialFilePath) throws IOException {
        HashMap<String, String> FV = new HashMap<String, String>();
        FileInputStream fis = null;
        Properties prop = new Properties();
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        for (Object filename : prop.keySet()) {
            if ("fv_file_name".equals(filename)) continue;
            String version = prop.getProperty((String)filename);
            FV.put((String)filename, version);
        }
        Object var9_10 = null;
        if (fis == null) return FV;
        try {
            fis.close();
            return FV;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return FV;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var9_11 = null;
                if (fis == null) return FV;
                try {
                    fis.close();
                    return FV;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return FV;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var9_12 = null;
                if (fis == null) return FV;
                try {
                    fis.close();
                    return FV;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return FV;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, List<String>> deserializeFileVersionList(String serialFilePath) throws IOException {
        HashMap<String, List<String>> FV = new HashMap<String, List<String>>();
        FileInputStream fis = null;
        Properties prop = new Properties();
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        for (Object filename : prop.keySet()) {
            if ("fv_file_name".equals(filename)) continue;
            String versionStr = prop.getProperty((String)filename);
            String[] versions = versionStr.split(",");
            List<String> versionList = Arrays.asList(versions);
            FV.put((String)filename, versionList);
        }
        Object var11_12 = null;
        if (fis == null) return FV;
        try {
            fis.close();
            return FV;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return FV;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var11_13 = null;
                if (fis == null) return FV;
                try {
                    fis.close();
                    return FV;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return FV;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var11_14 = null;
                if (fis == null) return FV;
                try {
                    fis.close();
                    return FV;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return FV;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> deserializeUnzipActionLoc(String serialFilePath) throws IOException {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        FileInputStream fis = null;
        Properties prop = new Properties();
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        for (Object filename : prop.keySet()) {
            String version = prop.getProperty((String)filename);
            fileMap.put((String)filename, version);
        }
        Object var9_10 = null;
        if (fis == null) return fileMap;
        try {
            fis.close();
            return fileMap;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return fileMap;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var9_11 = null;
                if (fis == null) return fileMap;
                try {
                    fis.close();
                    return fileMap;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return fileMap;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var9_12 = null;
                if (fis == null) return fileMap;
                try {
                    fis.close();
                    return fileMap;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return fileMap;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Boolean> deserializeUnchangedFile(String serialFilePath) throws IOException {
        HashMap<String, Boolean> fileMap = new HashMap<String, Boolean>();
        FileInputStream fis = null;
        Properties prop = new Properties();
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        for (Object filename : prop.keySet()) {
            Boolean flag = Boolean.parseBoolean(prop.getProperty((String)filename));
            fileMap.put((String)filename, flag);
        }
        Object var9_10 = null;
        if (fis == null) return fileMap;
        try {
            fis.close();
            return fileMap;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return fileMap;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var9_11 = null;
                if (fis == null) return fileMap;
                try {
                    fis.close();
                    return fileMap;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return fileMap;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var9_12 = null;
                if (fis == null) return fileMap;
                try {
                    fis.close();
                    return fileMap;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return fileMap;
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void serializePrereqResult(String serialFilePath, HashMap PR) throws IOException {
        StringBuilder buffer = new StringBuilder(512);
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        for (Object prereqname : PR.keySet()) {
            String sep;
            OPatchPatchPrereq pr = (OPatchPatchPrereq)prereqname;
            String pValue = String.valueOf(pr.getValue());
            OPatchTarget.StatusCheck sc = (OPatchTarget.StatusCheck)PR.get(pr);
            String rStatus = String.valueOf(sc.getStatusCode());
            String rResult = sc.getResult();
            if (rResult.contains(sep = System.getProperty("line.separator"))) {
                StringBuilder rResultBuilder = new StringBuilder();
                String[] rResultLines = rResult.split("\\r?\\n");
                for (int i2 = 0; i2 < rResultLines.length - 1; ++i2) {
                    rResultBuilder.append(rResultLines[i2]);
                    rResultBuilder.append("\\n");
                }
                rResultBuilder.append(rResultLines[rResultLines.length - 1]);
                rResult = rResultBuilder.toString();
                if (buffer.length() > 0) {
                    writer.write(buffer.toString());
                    buffer.setLength(0);
                }
                writer.write(pValue + "=" + rStatus + ";" + rResult + "\n");
                continue;
            }
            buffer.append(pValue);
            buffer.append("=");
            buffer.append(rStatus);
            buffer.append(";");
            buffer.append(rResult);
            buffer.append("\n");
        }
        if (buffer.length() > 0) {
            writer.write(buffer.toString());
            writer.flush();
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap deserializePrereqResult(String serialFilePath) throws IOException {
        PR = new HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck>();
        prop = new Properties();
        fis = null;
        try {
            fis = new FileInputStream(serialFilePath);
            prop.load(fis);
            for (Object prereqname : prop.keySet()) {
                pValue = Integer.parseInt((String)prereqname);
                if (pValue >= 0 && pValue <= 42) {
                    prereq = OPatchPatchPrereq.getInstance((int)pValue);
                    results = prop.getProperty((String)prereqname).split(";");
                    rStatus = Integer.parseInt(results[0]);
                    rResult = results[1];
                    sc = new OPatchTarget.StatusCheck(rStatus, rResult);
                    PR.put(prereq, sc);
                    continue;
                }
                var8_10 = null;
                var14_15 = null;
                if (fis == null) return var8_10;
                ** GOTO lbl58
            }
            ** GOTO lbl64
        }
        catch (FileNotFoundException e) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", new Object[]{serialFilePath}));
            var14_17 = null;
            if (fis == null) return PR;
            try {
                fis.close();
                return PR;
            }
            catch (Exception e) {
                e.printStackTrace();
                return PR;
            }
        }
        catch (IOException e) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", new Object[]{serialFilePath}));
            OLogger.printStackTrace(e);
            var14_18 = null;
            if (fis == null) return PR;
            try {}
            catch (Exception e) {
                e.printStackTrace();
                return PR;
            }
            fis.close();
            return PR;
        }
        {
            catch (Throwable var13_25) {
                var14_19 = null;
                if (fis == null) throw var13_25;
                ** try [egrp 2[TRYBLOCK] [9 : 236->244)] { 
lbl53:
                // 1 sources

                fis.close();
                throw var13_25;
lbl55:
                // 1 sources

                catch (Exception e) {
                    e.printStackTrace();
                }
                throw var13_25;
            }
lbl58:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [9 : 236->244)] { 
lbl59:
            // 1 sources

            fis.close();
            return var8_10;
lbl61:
            // 1 sources

            catch (Exception e) {
                e.printStackTrace();
            }
            return var8_10;
lbl64:
            // 1 sources

            var14_16 = null;
            if (fis == null) return PR;
            try {}
            catch (Exception e) {}
            e.printStackTrace();
            return PR;
            fis.close();
            return PR;
        }
    }

    public void serializeHashValue(String serialFilePath, IndexPair hash) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Poh_hash=");
        buffer.append(hash.getFirstKey());
        buffer.append("\n");
        buffer.append("Pi_hash=");
        buffer.append(hash.getSecondKey());
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IndexPair deserializeHashValue(String serialFilePath) throws IOException {
        File f2 = new File(serialFilePath);
        if (!f2.exists()) {
            return null;
        }
        IndexPair hash = null;
        Properties prop = new Properties();
        FileInputStream fis = null;
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        hash = new IndexPair(prop.getProperty("Poh_hash"), prop.getProperty("Pi_hash"));
        Object var8_6 = null;
        if (fis == null) return hash;
        try {
            fis.close();
            return hash;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return hash;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var8_7 = null;
                if (fis == null) return hash;
                try {
                    fis.close();
                    return hash;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return hash;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var8_8 = null;
                if (fis == null) return hash;
                try {
                    fis.close();
                    return hash;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return hash;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void serializeOhHashValue(String serialFilePath, String hash) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Poh_hash=");
        buffer.append(hash);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String deserializeOhHashValue(String serialFilePath) throws IOException {
        File f2 = new File(serialFilePath);
        if (!f2.exists()) {
            return null;
        }
        String hash = null;
        Properties prop = new Properties();
        FileInputStream fis = null;
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        hash = prop.getProperty("Poh_hash");
        Object var8_6 = null;
        if (fis == null) return hash;
        try {
            fis.close();
            return hash;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return hash;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var8_7 = null;
                if (fis == null) return hash;
                try {
                    fis.close();
                    return hash;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return hash;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var8_8 = null;
                if (fis == null) return hash;
                try {
                    fis.close();
                    return hash;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return hash;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void serializeNoOpCheckResult(String serialFilePath, Vector noOps) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("noOp_oneoffs=");
        for (int i2 = 0; i2 < noOps.size(); ++i2) {
            String noopPatchID = (String)noOps.get(i2);
            buffer.append(noopPatchID);
            buffer.append(";");
        }
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String[] deserializeNoOpCheckResult(String serialFilePath) throws IOException {
        Properties prop = new Properties();
        FileInputStream fis = null;
        String[] noopPatchIDs = new String[]{};
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        noopPatchIDs = prop.getProperty("noOp_oneoffs").split(";");
        Object var7_5 = null;
        if (fis == null) return noopPatchIDs;
        try {
            fis.close();
            return noopPatchIDs;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return noopPatchIDs;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var7_6 = null;
                if (fis == null) return noopPatchIDs;
                try {
                    fis.close();
                    return noopPatchIDs;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return noopPatchIDs;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var7_7 = null;
                if (fis == null) return noopPatchIDs;
                try {
                    fis.close();
                    return noopPatchIDs;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return noopPatchIDs;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void serializePiComponents(String serialFilePath, HashSet<IndexPair> comps) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (IndexPair comp : comps) {
            buffer.append(comp.getFirstKey());
            buffer.append("=");
            buffer.append(comp.getSecondKey());
            buffer.append("\n");
        }
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HashSet<IndexPair> deserializePiComponents(String serialFilePath) throws IOException {
        Properties prop = new Properties();
        FileInputStream fis = null;
        HashSet<IndexPair> comps = new HashSet<IndexPair>();
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        for (Object compName : prop.keySet()) {
            String compVer = prop.getProperty((String)compName);
            IndexPair nameVer = new IndexPair((String)compName, compVer);
            comps.add(nameVer);
        }
        Object var10_11 = null;
        if (fis == null) return comps;
        try {
            fis.close();
            return comps;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return comps;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var10_12 = null;
                if (fis == null) return comps;
                try {
                    fis.close();
                    return comps;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return comps;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var10_13 = null;
                if (fis == null) return comps;
                try {
                    fis.close();
                    return comps;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return comps;
            }
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void serializeTime(String serialFilePath) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("start_time=");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
        String formattedDate = dateFormatter.format(new Date());
        buffer.append(formattedDate);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date deserializeTime(String serialFilePath) throws IOException {
        prop = new Properties();
        fis = null;
        date = null;
        try {
            fis = new FileInputStream(serialFilePath);
            prop.load(fis);
            s = prop.getProperty("start_time");
            dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
            try {
                date = dateFormatter.parse(s);
            }
            catch (ParseException e) {
                e.printStackTrace();
                var8_10 = null;
                var10_11 = null;
                if (fis == null) return var8_10;
                try {
                    fis.close();
                    return var8_10;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return var8_10;
            }
            var10_12 = null;
            if (fis == null) return date;
            ** GOTO lbl-1000
        }
        catch (FileNotFoundException e) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", new Object[]{serialFilePath}));
            var10_13 = null;
            if (fis == null) return date;
            try {}
            catch (Exception e) {
                e.printStackTrace();
                return date;
            }
            fis.close();
            return date;
        }
        catch (IOException e) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", new Object[]{serialFilePath}));
            OLogger.printStackTrace(e);
            var10_14 = null;
            if (fis == null) return date;
            try {}
            catch (Exception e) {
                e.printStackTrace();
                return date;
            }
            fis.close();
            return date;
        }
        {
            catch (Throwable var9_21) {
                var10_15 = null;
                if (fis == null) throw var9_21;
                ** try [egrp 3[TRYBLOCK] [8 : 147->154)] { 
lbl56:
                // 1 sources

                fis.close();
                throw var9_21;
lbl58:
                // 1 sources

                catch (Exception e) {
                    e.printStackTrace();
                }
                throw var9_21;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Exception e) {}
            e.printStackTrace();
            return date;
            fis.close();
            return date;
        }
    }

    public void serializeBackUpStatus(String serialFilePath, String s) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("do_backup=");
        buffer.append(s);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deserializeBackUpStatus(String serialFilePath) throws IOException {
        f = new File(serialFilePath);
        if (!f.exists()) {
            return false;
        }
        prop = new Properties();
        fis = null;
        try {
            fis = new FileInputStream(serialFilePath);
            prop.load(fis);
            s = prop.getProperty("do_backup");
            if (!s.equals("true")) ** GOTO lbl56
            var6_8 = true;
            var8_9 = null;
            if (fis == null) return var6_8;
            ** GOTO lbl-1000
        }
        catch (FileNotFoundException e) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", new Object[]{serialFilePath}));
            var8_11 = null;
            if (fis == null) return false;
            try {
                fis.close();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (IOException e) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", new Object[]{serialFilePath}));
            OLogger.printStackTrace(e);
            var8_12 = null;
            if (fis == null) return false;
            try {}
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            fis.close();
            return false;
        }
        {
            catch (Throwable var7_19) {
                var8_13 = null;
                if (fis == null) throw var7_19;
                ** try [egrp 2[TRYBLOCK] [7 : 146->154)] { 
lbl45:
                // 1 sources

                fis.close();
                throw var7_19;
lbl47:
                // 1 sources

                catch (Exception e) {
                    e.printStackTrace();
                }
                throw var7_19;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Exception e) {
                e.printStackTrace();
                return var6_8;
            }
            fis.close();
            return var6_8;
lbl56:
            // 1 sources

            var8_10 = null;
            if (fis == null) return false;
            try {}
            catch (Exception e) {}
            e.printStackTrace();
            return false;
            fis.close();
            return false;
        }
    }

    public void renameCachedFiles(String oldFilePath, String newFilePath) {
        File nf = new File(newFilePath);
        File of = new File(oldFilePath);
        of.renameTo(nf);
    }

    public void removeCachedFiles(String FilePath) {
        File f2 = new File(FilePath);
        if (f2.exists()) {
            f2.delete();
        }
    }

    public void serializeStringValue(String serialFilePath, String s) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("value=");
        buffer.append(s);
        buffer.append("\n");
        BufferedWriter writer = new BufferedWriter(new FileWriter(serialFilePath));
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String deserializeStringValue(String serialFilePath) throws IOException {
        File f2 = new File(serialFilePath);
        if (!f2.exists()) {
            return null;
        }
        String s = null;
        Properties prop = new Properties();
        FileInputStream fis = null;
        fis = new FileInputStream(serialFilePath);
        prop.load(fis);
        s = prop.getProperty("value");
        Object var8_6 = null;
        if (fis == null) return s;
        try {
            fis.close();
            return s;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return s;
        {
            catch (FileNotFoundException e3) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
                Object var8_7 = null;
                if (fis == null) return s;
                try {
                    fis.close();
                    return s;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return s;
            }
            catch (IOException e4) {
                OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
                OLogger.printStackTrace(e4);
                Object var8_8 = null;
                if (fis == null) return s;
                try {
                    fis.close();
                    return s;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                return s;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }
}

