/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.Rules;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;

public class ProcessLists {
    private NApplyData data;

    public ProcessLists(NApplyData data) {
        this.data = data;
    }

    public void processMerged(NApplyData data) {
        ArrayList<String> conflictPatchesInNApplyList = new ArrayList<String>();
        StringBuffer mergeRequestList = null;
        PrereqSet patchesToBeMerged = data.getMergedPatches();
        if (data.getMergedFlag()) {
            StringBuffer dBuff = new StringBuffer("N-Apply: there is merge request ");
            OLogger.debug(dBuff);
            mergeRequestList = new StringBuffer("");
            OLogger.println("");
            for (int i2 = 0; i2 < patchesToBeMerged.size(); ++i2) {
                mergeRequestList.append("   ");
                String id = patchesToBeMerged.getElement(i2).getID();
                if (data.getModelCode() == 2) {
                    if (patchesToBeMerged.getElement(i2).getPatchType().equals("snowball")) {
                        OLogger.println("Patch \"" + id + "\" is a \"" + "Fusion Applications" + "\" patch.");
                    } else if (patchesToBeMerged.getElement(i2).getPatchType().equals("singleton")) {
                        OLogger.println("Patch \"" + id + "\" is a \"" + "singleton" + "\" patch.");
                    }
                }
                mergeRequestList.append(id);
                conflictPatchesInNApplyList.add(id);
                data.setConflictPatchesInNApplyList(conflictPatchesInNApplyList);
                data.setMergeRequestList(mergeRequestList.toString());
            }
            OLogger.warn("OUI-67301", new Object[]{mergeRequestList.toString()});
            if (OPatchSessionHelper.hasHotPatch(new PrereqSet(data.getInterOutput().getListOfPatchesToBeMerged()))) {
                OLogger.warn("OUI-67281", new Object[]{OPatchSessionHelper.getHotPatchIDs(new PrereqSet(data.getInterOutput().getListOfPatchesToBeMerged()))});
                OPatchStateManagerFactory.getInstance().setErrorCode(66);
                PrereqFailedException re = new PrereqFailedException("Some Online Patch(es) has conflicts.");
                throw re;
            }
        } else {
            StringBuffer dBuff = new StringBuffer("N-Apply: no merge request ");
            OLogger.debug(dBuff);
        }
    }

    public void processNotNeed(NApplyData data) {
        PrereqSet patchesNotNeed = data.getNotNeedPatches();
        if (patchesNotNeed.size() != 0) {
            StringBuffer dBuff = new StringBuffer("N-Apply: there are patches not needed from the list");
            OLogger.debug(dBuff);
            StringBuffer skipList = new StringBuffer("");
            for (int i2 = 0; i2 < patchesNotNeed.size(); ++i2) {
                skipList.append("   ");
                skipList.append(patchesNotNeed.getElement(i2).getID());
            }
            OLogger.warn("OUI-67302", new Object[]{skipList.toString()});
        } else {
            StringBuffer dBuff = new StringBuffer("N-Apply: There are no unwanted patches by skip_subset, skip_duplicate, subset of the same list");
            OLogger.debug(dBuff);
            OUSession.setPrereqResult(OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, PrereqResult.ExecuteStatus.PASSED);
        }
    }

    public void processRollback(String oracleHomePath, NApplyData data) {
        String hasAutoRollbackMsg = "";
        StringBuffer autoRollbackList = null;
        PrereqSet patchesToBeRolledBack = data.getRollbackPatches();
        if (data.getRollbackFlag()) {
            String id;
            int i2;
            StringBuffer dBuff = new StringBuffer("N-Apply: there is auto-rollback. ");
            OLogger.debug(dBuff);
            autoRollbackList = new StringBuffer("");
            for (i2 = 0; i2 < patchesToBeRolledBack.size(); ++i2) {
                autoRollbackList.append("   ");
                id = patchesToBeRolledBack.getElement(i2).getID();
                autoRollbackList.append(id);
            }
            hasAutoRollbackMsg = autoRollbackList.toString();
            data.setHasAutoRollbackMsg(hasAutoRollbackMsg);
            if (!Rules.shouldSwitchONAutoRollback(oracleHomePath)) {
                OneOffEntry[] toApplyOneOffs = data.getCanGoPatches().getAllElements();
                PrereqSet toApply = new PrereqSet(toApplyOneOffs);
                toApply.retain(patchesToBeRolledBack);
                PrereqSet tmpSet = patchesToBeRolledBack.delete(toApply);
                autoRollbackList = new StringBuffer("");
                if (tmpSet.size() != 0) {
                    for (int i3 = 0; i3 < tmpSet.size(); ++i3) {
                        autoRollbackList.append("   ");
                        String id2 = tmpSet.getElement(i3).getID();
                        autoRollbackList.append(id2);
                    }
                    hasAutoRollbackMsg = autoRollbackList.toString();
                    data.setHasAutoRollbackMsg(hasAutoRollbackMsg);
                    dBuff = new StringBuffer(" has auto-rollback due to superset-subset but we are not doing it.");
                    dBuff.append("\nfor non-identical patches.");
                    OLogger.debug(dBuff);
                    OLogger.warn("OUI-67328", new Object[]{hasAutoRollbackMsg});
                }
            }
            OPatchUtilHelper.setAutoRollbackOneOffs(patchesToBeRolledBack.getAllElements());
            if (!Rules.shouldSwitchONAutoRollback(oracleHomePath)) {
                autoRollbackList = new StringBuffer("");
                for (i2 = 0; i2 < patchesToBeRolledBack.size(); ++i2) {
                    autoRollbackList.append("   ");
                    id = patchesToBeRolledBack.getElement(i2).getID();
                    autoRollbackList.append(id);
                }
                hasAutoRollbackMsg = autoRollbackList.toString();
                data.setHasAutoRollbackMsg(hasAutoRollbackMsg);
            }
        } else {
            StringBuffer dBuff = new StringBuffer("N-Apply: there is no auto-rollback. ");
            OLogger.debug(dBuff);
        }
    }

    public void processCanGo(NApplyData data) {
        StringBuffer proceedList = null;
        PrereqSet patchesThatCanGoNow = data.getCanGoPatches();
        OneOffEntry[] patchesToApply = data.getPatchesToApply();
        if (data.getCanGoFlag()) {
            proceedList = new StringBuffer("");
            StringBuffer dBuff = new StringBuffer("N-Apply: there are patches to be applied. ");
            OLogger.debug(dBuff);
            int len = patchesThatCanGoNow.size();
            patchesToApply = new OneOffEntry[len];
            for (int i2 = 0; i2 < len; ++i2) {
                OneOffEntry e2;
                proceedList.append("   ");
                patchesToApply[i2] = e2 = patchesThatCanGoNow.getElement(i2);
                String id = e2.getID();
                proceedList.append(id);
            }
        } else {
            StringBuffer dBuff = new StringBuffer("N-Apply: there are no patches to be applied. ");
            dBuff.append("Throw exception.");
            OLogger.debug(dBuff);
            String msg = OLogger.getString("OUI-67305");
            RuntimeException re = new RuntimeException(msg);
            OPatchStateManagerFactory.getInstance().setErrorCode(218);
            throw re;
        }
        data.setProceedList(proceedList.toString());
        data.setPatchesToApply(patchesToApply);
    }
}

