/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class CheckBaseSOACompositeDeploy
implements Operation {
    CheckBaseSOACompositeDeploy() {
    }

    public void run(FMWContext c2) {
        SOACompositeManager scm = null;
        OPatchStepAdapter prereqStep = null;
        scm = c2.getDomain().getSOACompositeManager();
        SOAComposite composite = c2.getSOAComposite();
        String name = composite.getName();
        String revision = composite.getRevision();
        String errorMsg = "";
        String compositeDN = "default/" + name + "!" + revision;
        try {
            boolean deployed = scm.isDeployed(compositeDN);
            if (deployed) {
                throw new RuntimeException("The composite \"" + name + "\" with revision \"" + revision + "\" is already deployed. Current Operation cannot be performed.");
            }
            Logger.logi("Input revision of the composite is not deployed");
        }
        catch (Throwable t) {
            OPatchStepAdapter isDeployedStep = new OPatchStepAdapter(OPatchFAStep.CHECK_COMPOSITE_DEPLOYED);
            isDeployedStep.setStepDescription("Find if the composite revision is not deployed");
            isDeployedStep.setSuccess(false);
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            if (errorMsg != null) {
                isDeployedStep.setErrorMessage(errorMsg);
            }
            RuntimeException re = new RuntimeException(t);
            isDeployedStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(isDeployedStep);
            throw re;
        }
        try {
            if (scm.isBaseCompositeDeployed(name)) {
                throw new RuntimeException("Version of the composite \"" + name + "\"" + " is already deployed." + " Current Operation cannot be executed.");
            }
            Logger.logi("No Version of the composite \"" + name + "\"" + "is deployed");
        }
        catch (Throwable t) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SOA_BASE_COMPOSITE_NOT_CONFIGURED);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check if base composite is not configured");
            errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
            if (errorMsg != null) {
                prereqStep.setErrorMessage(t.getMessage());
            }
            RuntimeException re = new RuntimeException(t);
            prereqStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            throw re;
        }
    }
}

