/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.integration.platform.blocks.deploy.patch.PatchStatus;
import oracle.opatch.opatchfafmw.BIP;
import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWLogger;
import oracle.opatch.opatchfafmw.FMWProductDriver;
import oracle.opatch.opatchfafmw.LDAP;
import oracle.opatch.opatchfafmw.LDIF;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.TargetList;
import oracle.opatch.opatchfafmw.Util;
import oracle.opatch.opatchfafmw.rb.RB;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FMWContext {
    private final LDAP ldap;
    private final Domain domain;
    private final TargetList targetList;
    private final ArrayList<SOAComposite> soaComposite;
    private final LDIF ldif;
    private final ArrayList<BIP> bip;
    private final boolean soaInfraTest;
    private final ServerAttribute sAttribute;
    private final Properties interviewProp;
    private final boolean stopAnyServer;
    private final int timeout;
    private final String homeGUID;
    private final String tempLocation;
    private final String oracleHome;
    private final String patchLocation;
    private final String patchID;
    private final String logFileLocation;
    private final EnumSet<OperationCode> set = EnumSet.noneOf(OperationCode.class);
    private ContextBuilder cb;
    private String[] compRevisionToUndoDeploy;
    private final boolean timeoutFlag;
    private boolean noneconfig = true;
    private boolean isCompDeployWithMultipleSteps = false;

    private FMWContext(ContextBuilder cb) {
        this.cb = cb;
        this.domain = cb.domain;
        this.targetList = cb.targetList;
        this.soaComposite = cb.soaComposite;
        this.soaInfraTest = cb.soaInfraTest;
        this.timeout = cb.timeout;
        this.ldif = cb.ldif;
        this.ldap = cb.ldap;
        this.bip = cb.bip;
        this.sAttribute = cb.sAttribute;
        this.interviewProp = cb.interviewProperties;
        this.compRevisionToUndoDeploy = cb.compRevisionToUndoDeploy;
        this.stopAnyServer = cb.stopAnyServer;
        this.timeoutFlag = cb.timeoutFlag;
        this.homeGUID = Util.norm(cb.homeGUID);
        this.tempLocation = Util.norm(cb.tempLocation);
        this.patchLocation = Util.norm(cb.patchLocation);
        this.oracleHome = Util.norm(cb.oracleHome);
        this.patchID = Util.norm(cb.patchID);
        this.logFileLocation = Util.norm(cb.logFileLocation);
        this.noneconfig = cb.noneConfigPlanFlag;
        if (this.domain != null) {
            this.set.add(OperationCode.PREREQ_ADMIN_SERVER_AVAILABLE);
            if (this.soaInfraTest) {
                this.set.add(OperationCode.PREREQ_SOA_SERVER_AVAILABLE);
            }
            if (this.sAttribute != null) {
                this.set.add(OperationCode.SERVER_CONFIG_ATTRIBUTE);
            }
            if (this.targetList != null) {
                this.set.add(OperationCode.PREREQ_CONFIGURATION);
                this.set.add(OperationCode.PREREQ_LIFE_CYCLE);
                this.set.add(OperationCode.START);
                this.set.add(OperationCode.STOP);
                this.set.add(OperationCode.STOP_NSERVER);
                this.set.add(OperationCode.START_NSERVER);
            }
            if (this.soaComposite != null && this.soaComposite.size() != 0) {
                this.set.add(OperationCode.PREREQ_SOA_SERVER_AVAILABLE);
                boolean anyResourceBundle = false;
                boolean anyComposites = false;
                SOAComposite sc = this.soaComposite.get(0);
                if (sc.resourceBundle()) {
                    anyResourceBundle = true;
                } else {
                    anyComposites = true;
                }
                if (anyComposites) {
                    this.set.add(OperationCode.PREREQ_SOA_COMPOSITE_DEPLOY);
                    this.set.add(OperationCode.PREREQ_SOA_COMPOSITE_UNDEPLOY);
                    this.set.add(OperationCode.DEPLOY_SOA_COMPOSITE);
                    this.set.add(OperationCode.UNDEPLOY_SOA_COMPOSITE);
                    this.set.add(OperationCode.PREREQ_COMPOSITE_LIFECYCLE);
                    this.set.add(OperationCode.STOP_COMPOSITE);
                    this.set.add(OperationCode.START_COMPOSITE);
                    this.set.add(OperationCode.COMPOSITE_STATUS);
                    this.set.add(OperationCode.LIST_DEPLOYED_COMPOSITES);
                    this.set.add(OperationCode.PREREQ_BASE_SOA_COMPOSITE_DEPLOY);
                    this.set.add(OperationCode.DEPLOY_BASE_SOA_COMPOSITE);
                }
                if (anyResourceBundle) {
                    this.set.add(OperationCode.DEPLOY_SOA_RESOURCE_BUNDLE);
                }
            }
        }
        if (this.ldif != null) {
            this.set.add(OperationCode.DEPLOY_LDIF);
        }
        if (this.bip != null) {
            this.set.add(OperationCode.PREREQ_BIP_DEPLOY);
            this.set.add(OperationCode.PREREQ_BIP_UNDEPLOY);
            this.set.add(OperationCode.DEPLOY_BIP);
            this.set.add(OperationCode.UNDEPLOY_BIP);
        }
        if (this.set.size() == 0) {
            Logger.error(RB.Entry.INVALID_CONTEXT, new Object[0]);
        }
    }

    ContextBuilder getContextBuilder() {
        return this.cb;
    }

    boolean isNoneConfigPlan() {
        return this.noneconfig;
    }

    boolean isTimeout() {
        return this.timeoutFlag;
    }

    TargetList getTargets() {
        return this.targetList;
    }

    Domain getDomain() {
        return this.domain;
    }

    ServerAttribute getServerAttribute() {
        return this.sAttribute;
    }

    LDIF getLDiff() {
        return this.ldif;
    }

    ArrayList<BIP> getBIP() {
        return this.bip;
    }

    LDAP getLDAPInformation() {
        return this.ldap;
    }

    Properties getInterviewProperties() {
        return this.interviewProp;
    }

    SOAComposite getSOAComposite() {
        if (this.soaComposite == null || this.soaComposite.size() == 0) {
            return null;
        }
        return this.soaComposite.get(0);
    }

    public void clearSOAComposite() {
        this.soaComposite.remove(0);
    }

    public String[] getCompRevisionToUndeploy() {
        return this.compRevisionToUndoDeploy;
    }

    int getTimeout() {
        return this.timeout;
    }

    boolean stopAnyServer() {
        return this.stopAnyServer;
    }

    String getHomeGUID() {
        return this.homeGUID;
    }

    String getTempLocation() {
        return this.tempLocation;
    }

    String getOracleHome() {
        return this.oracleHome;
    }

    String getPatchLocation() {
        return this.patchLocation;
    }

    String getPatchID() {
        return this.patchID;
    }

    EnumSet<OperationCode> getAllowedOperations() {
        return this.set;
    }

    String getLogFileLocation() {
        return this.logFileLocation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextBuilder {
        private Domain domain;
        private LDAP ldap;
        private Properties interviewProperties;
        private boolean soaInfraTest = false;
        private boolean isCompositeUp = false;
        private boolean noneConfigPlanFlag = true;
        private boolean isCompDeployWithMultipleSteps = false;
        private ServerAttribute sAttribute;
        private Map<String, ServerLifeCycleRuntimeMBean> lcrMap;
        private Map<String, ServerLifeCycleTaskRuntimeMBean> ltaskMap;
        private OPatchStepAdapter executionStep;
        private boolean timeoutFlag = true;
        private PatchStatus statusObj = null;
        private static final Pattern URL_PATTERN = Pattern.compile("(.*)://(.*):(.*?)(/.*)?");
        private List<OPatchStepAdapter> deploySteps = new ArrayList<OPatchStepAdapter>();
        private List<OPatchStepAdapter> recoverySteps = new ArrayList<OPatchStepAdapter>();
        private OPatchStepAdapter failedPrereqStep = null;
        private TargetList targetList;
        private static final int DEFAULT_TIMEOUT = 5400;
        private boolean stopAnyServer;
        private int timeout = 5400;
        private String homeGUID;
        private String tempLocation;
        private String patchLocation;
        private String oracleHome;
        private String patchID;
        private String logFileLocation;
        private ArrayList soaComposite;
        private LDIF ldif = null;
        private ArrayList<BIP> bip = new ArrayList();
        private String[] compRevisionToUndoDeploy;

        public ContextBuilder(FMWLogger logger) {
            Logger.setLogger(logger);
            if (Logger.debug) {
                Logger.debug("DEBUG [" + logger.debug() + "]");
            }
        }

        void addExecutionStep(OPatchStepAdapter step) {
            this.deploySteps.add(step);
        }

        public void setCompositeDeployWithMultipleSteps(boolean isMultiStep) {
            this.isCompDeployWithMultipleSteps = isMultiStep;
        }

        public boolean isCompositeDeployWithMultipleSteps() {
            return this.isCompDeployWithMultipleSteps;
        }

        public void setNoneConfigPlan(boolean flag) {
            this.noneConfigPlanFlag = flag;
        }

        public void setTimeoutFlag(boolean t) {
            this.timeoutFlag = t;
        }

        public boolean isTimeout() {
            return this.timeoutFlag;
        }

        public void setServerLifecycleInfo(Map<String, ServerLifeCycleRuntimeMBean> lcr1, Map<String, ServerLifeCycleTaskRuntimeMBean> lctask, OPatchStepAdapter executionStep1) {
            this.lcrMap = new HashMap<String, ServerLifeCycleRuntimeMBean>(lcr1.size());
            this.lcrMap.putAll(lcr1);
            this.ltaskMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>(lctask.size());
            this.ltaskMap.putAll(lctask);
            this.executionStep = executionStep1;
        }

        public void setSOAOpResult(PatchStatus obj) {
            this.statusObj = obj;
        }

        public PatchStatus getSOAOpResult() {
            return this.statusObj;
        }

        public void setServerAttrInfo(String serverName, String attrName) {
            this.sAttribute = new ServerAttribute(serverName, attrName);
        }

        public void setServerAttrInfo(String serverName, String attrName, String attrValue, String objType, boolean errorOnPrevEdit) {
            this.sAttribute = new ServerAttribute(serverName, attrName, attrValue, objType, errorOnPrevEdit);
        }

        public void setAttributeValue(Object o2) {
            this.sAttribute.setOutputAttributeValue(o2);
        }

        public ServerAttribute getServerAttribute() {
            return this.sAttribute;
        }

        public void setSOAInfraTest(boolean in) {
            this.soaInfraTest = in;
        }

        public boolean isSOACompositeUp() {
            return this.isCompositeUp;
        }

        public void setSOACompositeUp(boolean in) {
            this.isCompositeUp = in;
        }

        public boolean isSOAInfraTest() {
            return this.soaInfraTest;
        }

        void addRecoveryStep(OPatchStepAdapter recStep) {
            this.recoverySteps.add(recStep);
        }

        void setFailedPrereqStep(OPatchStepAdapter failedPrereqStep) {
            if (failedPrereqStep != null) {
                this.failedPrereqStep = failedPrereqStep;
            }
        }

        public Domain getDomain() {
            return this.domain;
        }

        public Map<String, ServerLifeCycleRuntimeMBean> getServerLifeCycleRuntimeMBeanMap() {
            return this.lcrMap;
        }

        public Map<String, ServerLifeCycleTaskRuntimeMBean> getServerLifeCycleTaskRuntimeMBeanMap() {
            return this.ltaskMap;
        }

        public OPatchStepAdapter getExecutionStep() {
            return this.executionStep;
        }

        public OPatchStepAdapter getFailedPrereqStep() {
            return this.failedPrereqStep;
        }

        public List<OPatchStepAdapter> getExecutionSteps() {
            return this.deploySteps;
        }

        public List<OPatchStepAdapter> getRecoverySteps() {
            return this.recoverySteps;
        }

        public ContextBuilder setInterviewProperties(Properties prop) {
            this.interviewProperties = prop;
            return this;
        }

        public ContextBuilder setDomain(String url, String username, String password) {
            return this.setDomain(url, username, password, null, null);
        }

        public ContextBuilder setLDAPCredentials(String host, String port, String bindDN, String password, String sslMode) {
            try {
                host = Util.norm(host);
                if ("".equals(host)) {
                    Logger.error(RB.Entry.EMPTY_LDAP_HOST, new Object[0]);
                }
                int portNumber = -1;
                try {
                    portNumber = Integer.parseInt(Util.norm(port));
                }
                catch (NumberFormatException e2) {
                    Logger.loge(e2);
                    Logger.error(RB.Entry.NON_NUMERIC_LDAP_PORT_NUMBER, port);
                }
                bindDN = Util.norm(bindDN);
                if ("".equals(bindDN)) {
                    Logger.error(RB.Entry.EMPTY_LDAP_BIND_DN, new Object[0]);
                }
                boolean ssl = new Boolean(sslMode);
                LDAP ldap = new LDAP(host, portNumber, bindDN, password, new Boolean(sslMode));
                if (Logger.debug) {
                    StringBuilder sb = new StringBuilder("LDAP details\n");
                    sb.append("Host        [").append(host).append("]\n");
                    sb.append("Port   [").append(port).append("]\n");
                    sb.append("BindDN [").append(bindDN).append("]\n");
                    sb.append("SSL Mode [").append(sslMode).append("]\n");
                    Logger.debug(sb.toString());
                }
                this.ldap = ldap;
                return this;
            }
            catch (Exception e3) {
                Logger.loge(e3);
                return null;
            }
        }

        public ContextBuilder setDomain(String url, String username, String password, String nmUsername, String nmPassword) {
            this.domain = null;
            if (Logger.debug) {
                StringBuilder sb = new StringBuilder("Domain Details\n");
                sb.append("URL        [").append(url).append("]\n");
                sb.append("Username   [").append(username).append("]\n");
                sb.append("NMUsername [").append(nmUsername).append("]\n");
                Logger.debug(sb.toString());
            }
            url = Util.norm(url);
            String protocol = null;
            String host = null;
            int port = -1;
            Matcher m2 = URL_PATTERN.matcher(url);
            if (m2.matches()) {
                String portString;
                protocol = Util.norm(m2.group(1));
                if ("".equals(protocol)) {
                    Logger.error(RB.Entry.PROTOCOL_NOT_SPECIFIED, url);
                }
                if ("".equals(host = Util.norm(m2.group(2)))) {
                    Logger.error(RB.Entry.HOST_NOT_SPECIFIED, url);
                }
                if ("".equals(portString = Util.norm(m2.group(3)))) {
                    Logger.error(RB.Entry.PORT_NOT_SPECIFIED, url);
                } else {
                    try {
                        port = Integer.parseInt(portString);
                    }
                    catch (Exception e2) {
                        Logger.error(RB.Entry.NON_NUMERIC_PORT_NUMBER, url);
                    }
                    if (port <= 0) {
                        Logger.error(RB.Entry.INVALID_PORT_NUMBER, port);
                    }
                }
            } else {
                Logger.error(RB.Entry.MALFORMED_URL, url);
            }
            username = Util.norm(username);
            if ("".equals(username)) {
                Logger.error(RB.Entry.USERNAME_NOT_SPECIFIED, new Object[0]);
            }
            if ("".equals(password = Util.norm(password))) {
                Logger.error(RB.Entry.PASSWORD_NOT_SPECIFIED, new Object[0]);
            }
            this.domain = new Domain(protocol, host, port, username, password);
            this.domain.setNMCredential(Util.norm(nmUsername), Util.norm(nmPassword));
            return this;
        }

        public TargetList getTarget() {
            return this.targetList;
        }

        public ContextBuilder setTargets(Type type, String ... targets) {
            this.targetList = null;
            if (type == null) {
                Logger.error(RB.Entry.INCORRECT_TRAGET_TYPE, Arrays.toString((Object[])Type.values()).toLowerCase());
            }
            HashSet<String> set = null;
            if (targets != null && targets.length >= 0) {
                for (String target : targets) {
                    if ("".equals(target = Util.norm(target))) continue;
                    if (set == null) {
                        set = new HashSet<String>(5);
                    }
                    set.add(target);
                }
            }
            if (set == null) {
                Logger.error(RB.Entry.EMPTY_TARGET_LIST, new Object[0]);
            }
            this.targetList = new TargetList(type, set);
            if (Logger.debug) {
                Logger.debug(this.targetList.toString());
            }
            return this;
        }

        public ContextBuilder setTargets(TargetList tl) {
            this.targetList = new TargetList(tl);
            return this;
        }

        public ContextBuilder setConfigProperties(EnumMap<ConfigProperties, String> cp) {
            String value;
            if (cp == null) {
                return this;
            }
            if (Logger.debug) {
                Logger.debug("ConfigProperties " + cp.toString());
            }
            if (!"".equals(value = Util.norm(cp.get((Object)ConfigProperties.TIMEOUT_SECONDS)))) {
                try {
                    this.timeout = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.timeout < 5400) {
                    this.timeout = 5400;
                }
            }
            if (!"".equals(value = Util.norm(cp.get((Object)ConfigProperties.STOP_ANY_SERVER)))) {
                this.stopAnyServer = Boolean.parseBoolean(value);
            }
            if (!"".equals(value = Util.norm(cp.get((Object)ConfigProperties.COMMON_HOME_GUID)))) {
                this.homeGUID = value;
            }
            if (!"".equals(value = Util.norm(cp.get((Object)ConfigProperties.TEMP_LOCATION)))) {
                this.tempLocation = value;
            }
            if (!"".equals(value = Util.norm(cp.get((Object)ConfigProperties.ORACLE_HOME)))) {
                this.oracleHome = value;
            }
            if (!"".equals(value = Util.norm(cp.get((Object)ConfigProperties.PATCH_LOCATION)))) {
                this.patchLocation = value;
            }
            if (!"".equals(value = Util.norm(cp.get((Object)ConfigProperties.PATCH_ID)))) {
                this.patchID = value;
            }
            if (!"".equals(value = Util.norm(cp.get((Object)ConfigProperties.LOG_FILE_LOCATION)))) {
                this.logFileLocation = value;
            }
            return this;
        }

        public ContextBuilder addLDIFF(String name, String path) {
            name = Util.norm(name);
            path = Util.norm(path);
            LDIF lf = new LDIF(name, path);
            if (Logger.debug) {
                Logger.debug(lf.toString());
            }
            this.ldif = lf;
            return this;
        }

        public ContextBuilder addBIP(String name, String path, String relativePath, String biHome) {
            name = Util.norm(name);
            path = Util.norm(path);
            BIP bp = new BIP(name, path, relativePath, biHome);
            if (Logger.debug) {
                Logger.debug(bp.toString());
            }
            this.bip.add(bp);
            return this;
        }

        public ContextBuilder addSOAComposite(String name, String path, String revision, boolean designChanges, boolean resourceBundle) {
            if ("".equals(name = Util.norm(name)) && !resourceBundle) {
                Logger.error(RB.Entry.INVALID_SOA_COMPOSITE_NAME, new Object[0]);
            }
            if ("".equals(path = Util.norm(path))) {
                Logger.error(RB.Entry.INVALID_SOA_COMPOSITE_PATH, name);
            }
            if ("".equals(revision = Util.norm(revision)) && !resourceBundle) {
                Logger.error(RB.Entry.INVALID_SOA_COMPOSITE_REVISION, new Object[0]);
            }
            SOAComposite sc = new SOAComposite(name, path, revision, designChanges, resourceBundle);
            if (Logger.debug) {
                Logger.debug(sc.toString());
            }
            if (this.soaComposite == null) {
                this.soaComposite = new ArrayList(1);
            }
            this.soaComposite.add(sc);
            return this;
        }

        public ContextBuilder addSOAComposite(String name, String path, String revision, boolean designChanges, boolean resourceBundle, boolean baseCompositeDeployment) {
            if ("".equals(name = Util.norm(name)) && !resourceBundle) {
                Logger.error(RB.Entry.INVALID_SOA_COMPOSITE_NAME, new Object[0]);
            }
            if ("".equals(path = Util.norm(path))) {
                Logger.error(RB.Entry.INVALID_SOA_COMPOSITE_PATH, name);
            }
            if ("".equals(revision = Util.norm(revision)) && !resourceBundle) {
                Logger.error(RB.Entry.INVALID_SOA_COMPOSITE_REVISION, new Object[0]);
            }
            SOAComposite sc = new SOAComposite(name, path, revision, designChanges, resourceBundle, baseCompositeDeployment);
            if (Logger.debug) {
                Logger.debug(sc.toString());
            }
            if (this.soaComposite == null) {
                this.soaComposite = new ArrayList(1);
            }
            this.soaComposite.add(sc);
            return this;
        }

        public ContextBuilder addSOAComposite(String name, String revision) {
            name = Util.norm(name);
            revision = Util.norm(revision);
            SOAComposite sc = new SOAComposite(name, "", revision, false, false);
            if (Logger.debug) {
                Logger.debug(sc.toString());
            }
            if (this.soaComposite == null) {
                this.soaComposite = new ArrayList(1);
            }
            this.soaComposite.add(sc);
            return this;
        }

        public ContextBuilder setRevisionToUndoDeploy(String[] compRevisions) {
            this.compRevisionToUndoDeploy = compRevisions;
            return this;
        }

        public SOAComposite getSOAComposite() {
            if (this.soaComposite == null || this.soaComposite.size() == 0) {
                return null;
            }
            return (SOAComposite)this.soaComposite.get(0);
        }

        public FMWProductDriver build() {
            return new FMWProductDriver(new FMWContext(this));
        }

        public boolean equals(Object o2) {
            if (o2 instanceof ContextBuilder) {
                ContextBuilder cb = (ContextBuilder)o2;
                return cb.getTarget().equals(this.targetList);
            }
            return false;
        }

        public boolean operationOnAdminServer() {
            String adminServer = this.domain.getAdminServerName();
            Set<String> servers = this.targetList.getTargets();
            return servers.contains(adminServer);
        }
    }

    public static class ServerAttribute {
        private String serverName;
        private String attribute;
        private boolean getAttribute = false;
        private boolean errorOnPrevEdit = false;
        private String attrValue;
        private Object outputAttrValue;
        private String objType;

        public ServerAttribute(String serverName, String attribute) {
            this.serverName = serverName;
            this.attribute = attribute;
            this.getAttribute = true;
        }

        public ServerAttribute(String serverName, String attribute, String attrValueToSet, String objType, boolean errorOnPrevEdit) {
            this(serverName, attribute);
            this.getAttribute = false;
            this.attrValue = attrValueToSet;
            this.objType = objType;
            this.errorOnPrevEdit = errorOnPrevEdit;
        }

        public void setOutputAttributeValue(Object o2) {
            this.outputAttrValue = o2;
        }

        public Object getOutputAttrValue() {
            return this.outputAttrValue;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public boolean isGetAttribute() {
            return this.getAttribute;
        }

        public String getAttrValue() {
            return this.attrValue;
        }

        public String getObjectType() {
            return this.objType;
        }

        public boolean isErrorOnPrevEdit() {
            return this.errorOnPrevEdit;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationCode {
        PREREQ_ADMIN_SERVER_AVAILABLE(null),
        PREREQ_BIP_DEPLOY(null),
        PREREQ_BIP_UNDEPLOY(null),
        PREREQ_CONFIGURATION(PREREQ_ADMIN_SERVER_AVAILABLE),
        PREREQ_LIFE_CYCLE(PREREQ_CONFIGURATION),
        STOP_NSERVER(null),
        START_NSERVER(null),
        SERVER_CONFIG_ATTRIBUTE(null),
        START(PREREQ_LIFE_CYCLE),
        STOP(PREREQ_LIFE_CYCLE),
        PREREQ_SOA_SERVER_AVAILABLE(PREREQ_ADMIN_SERVER_AVAILABLE),
        PREREQ_SOA_COMPOSITE_DEPLOY(PREREQ_SOA_SERVER_AVAILABLE),
        PREREQ_SOA_COMPOSITE_UNDEPLOY(PREREQ_SOA_SERVER_AVAILABLE),
        DEPLOY_BIP(PREREQ_BIP_DEPLOY),
        UNDEPLOY_BIP(PREREQ_BIP_UNDEPLOY),
        DEPLOY_SOA_COMPOSITE(PREREQ_SOA_SERVER_AVAILABLE),
        UNDEPLOY_SOA_COMPOSITE(PREREQ_SOA_COMPOSITE_UNDEPLOY),
        DEPLOY_SOA_RESOURCE_BUNDLE(PREREQ_SOA_SERVER_AVAILABLE),
        DEPLOY_LDIF(null),
        PREREQ_COMPOSITE_LIFECYCLE(PREREQ_SOA_SERVER_AVAILABLE),
        COMPOSITE_STATUS(PREREQ_COMPOSITE_LIFECYCLE),
        STOP_COMPOSITE(PREREQ_COMPOSITE_LIFECYCLE),
        START_COMPOSITE(PREREQ_COMPOSITE_LIFECYCLE),
        LIST_DEPLOYED_COMPOSITES(PREREQ_SOA_SERVER_AVAILABLE),
        PREREQ_BASE_SOA_COMPOSITE_DEPLOY(PREREQ_SOA_SERVER_AVAILABLE),
        DEPLOY_BASE_SOA_COMPOSITE(PREREQ_BASE_SOA_COMPOSITE_DEPLOY);

        private OperationCode prereq;

        private OperationCode(OperationCode prereq) {
            this.prereq = prereq;
        }

        OperationCode prereq() {
            return this.prereq;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigProperties {
        STOP_ANY_SERVER,
        TIMEOUT_SECONDS,
        COMMON_HOME_GUID,
        TEMP_LOCATION,
        ORACLE_HOME,
        PATCH_LOCATION,
        PATCH_ID,
        LOG_FILE_LOCATION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SERVER,
        CLUSTER,
        APPLICATION,
        CONTAINER;

    }
}

