/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class ListDeployedComposites
implements Operation {
    String details = "";

    ListDeployedComposites() {
    }

    public void run(FMWContext c2) {
        OPatchStepAdapter executionStep = null;
        try {
            Domain d2 = c2.getDomain();
            if (!d2.connected()) {
                try {
                    executionStep = new OPatchStepAdapter(OPatchFAStep.SETUP_JMX_CONNECTION);
                    executionStep.setStepDescription("Setup JMX Connectivity");
                    c2.getContextBuilder().addExecutionStep(executionStep);
                    d2.setupJMXConnection();
                }
                catch (Throwable t) {
                    executionStep.setSuccess(false);
                    executionStep.setExceptionObject(new RuntimeException(t));
                    String errorMsg = "";
                    errorMsg = t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError ? "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set." : t.getMessage();
                    if (errorMsg != null) {
                        executionStep.setErrorMessage(errorMsg);
                    }
                    Logger.loge(new RuntimeException(t));
                    throw t;
                }
            }
            SOACompositeManager scm = d2.getSOACompositeManager();
            String name = c2.getSOAComposite().getName();
            executionStep = new OPatchStepAdapter(OPatchFAStep.SOA_LIST_DEPLOYED_COMPOSITES);
            if ("".equals(name)) {
                executionStep.setStepDescription("Listing all the deployed composites.");
                c2.getContextBuilder().addExecutionStep(executionStep);
                this.details = scm.listDeployedComposites();
                if (this.details == null || "".equals(this.details)) {
                    Logger.logAndPrint("\n No Composites have been deployed to this server.");
                } else {
                    Logger.logAndPrint("\n" + this.details);
                }
            } else {
                executionStep.setStepDescription("Listing all the revisions of the composite: " + name);
                c2.getContextBuilder().addExecutionStep(executionStep);
                this.details = scm.listDeployedComposites(name);
                if (this.details == null || "".equals(this.details)) {
                    Logger.logAndPrint("\nNo revision of the composite with \"" + name + "\" has been found deployed on the soa-infra. Please verify the name of the composite.");
                } else {
                    Logger.logAndPrint("\nFollowing revisions of the composite \"" + name + "\" have been found deployed on the soa-infra:");
                    Logger.logAndPrint("\n" + this.details);
                }
            }
        }
        catch (Throwable t) {
            executionStep.setSuccess(false);
            executionStep.setExceptionObject(new RuntimeException(t));
            executionStep.setErrorMessage("Unable to List the deployed composites.");
            Logger.log(t.getMessage());
            Logger.error(RB.Entry.ERROR_LISTING_DEPLOYED_COMPOSITES, new Object[0]);
        }
    }
}

