/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.FMWException;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.NodeManagerClient;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchFAStep;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServerLifeCycle
implements Operation {
    private final boolean start;
    private static final int TASK_COMPLETION_AFTER_TIME_OUT = 20;
    private FMWContext c;

    ServerLifeCycle(boolean start) {
        this.start = start;
    }

    @Override
    public void run(FMWContext c2) {
        this.c = c2;
        OPatchStepAdapter executionStep = null;
        boolean report = OPatchEnv.isReport();
        Set<String> servers = c2.getTargets().getTargets();
        if (servers.isEmpty()) {
            return;
        }
        Domain d2 = c2.getDomain();
        int timeout = c2.getTimeout();
        String adminServer = d2.getAdminServerName();
        boolean operationOnAdminServer = servers.contains(adminServer);
        if (this.start && operationOnAdminServer && !report) {
            NodeManagerClient nmc = d2.getNMClient();
            executionStep = new OPatchStepAdapter(OPatchFAStep.CHECK_NODE_MANAGER_CONFIGURATION);
            executionStep.setStepDescription("Check the configuration of Node Manager");
            c2.getContextBuilder().addExecutionStep(executionStep);
            if (nmc == null) {
                if (nmc.excep != null) {
                    executionStep.setExceptionObject(new RuntimeException(nmc.excep));
                    nmc.excep = null;
                }
                executionStep.setSuccess(false);
                executionStep.setErrorMessage(Logger.getString(RB.Entry.NODE_MANAGER_NOT_CONFIGURED_AS, new Object[0]));
                Logger.error(RB.Entry.NODE_MANAGER_NOT_CONFIGURED_AS, new Object[0]);
            }
            if (Logger.debug) {
                Logger.debug("Starting Admin Server ...");
            }
            executionStep = new OPatchStepAdapter(OPatchFAStep.START_ADMIN_SERVER);
            executionStep.setStepDescription("Start Admin Server");
            if (!report && !nmc.start(timeout)) {
                if (nmc.excep != null) {
                    executionStep.setExceptionObject(new RuntimeException(nmc.excep));
                    nmc.excep = null;
                }
                executionStep.setSuccess(false);
                executionStep.setErrorMessage(Logger.getString(RB.Entry.ERROR_IN_NM_START, new Object[0]));
                c2.getContextBuilder().addExecutionStep(executionStep);
                Logger.error(RB.Entry.ERROR_IN_NM_START, new Object[0]);
            } else if (report) {
                executionStep.setStepDescription("[Skip] Start Admin Server");
            }
            c2.getContextBuilder().addExecutionStep(executionStep);
            try {
                executionStep = new OPatchStepAdapter(OPatchFAStep.GET_JMX_CONNECTION_AFTER_ADMIN_SERVER_START);
                if (!report) {
                    executionStep.setStepDescription("Check JMX Connection after re-start");
                    d2.setupJMXConnection();
                } else {
                    executionStep.setStepDescription("[Skip] Check JMX Connection after re-start");
                }
                c2.getContextBuilder().addExecutionStep(executionStep);
            }
            catch (FMWException e2) {
                executionStep.setSuccess(false);
                executionStep.setErrorMessage(Logger.getString(RB.Entry.ERROR_IN_GETTING_CONNECTION_AFTER_RESTART, new Object[0]));
                Logger.error(RB.Entry.ERROR_IN_GETTING_CONNECTION_AFTER_RESTART, new Object[0]);
            }
        }
        executionStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SERVER_UP);
        executionStep.setStepDescription("Check Admin Server up");
        c2.getContextBuilder().addExecutionStep(executionStep);
        if (!d2.connected()) {
            if (this.start && operationOnAdminServer && report) {
                servers.remove(adminServer);
                executionStep.setStepDescription("[Skip] Check Admin Server up and Report following server(s)" + servers.toString() + " operation");
                return;
            }
            executionStep.setSuccess(false);
            executionStep.setErrorMessage(Logger.getString(RB.Entry.NOT_CONNECTED_TO_AS, new Object[0]));
            Logger.error(RB.Entry.NOT_CONNECTED_TO_AS, new Object[0]);
        }
        HashMap<String, ServerLifeCycleRuntimeMBean> lMap = null;
        ArrayList<String> aList = null;
        ArrayList<String> eList = null;
        ArrayList<String> hList = null;
        for (String server : servers) {
            if (this.start && adminServer.equals(server)) continue;
            ServerLifeCycleRuntimeMBean lcr = d2.getServerLifeCycleRuntimeMBean(server);
            if (this.start) {
                executionStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SERVER_DOWN);
                executionStep.setStepDescription("Check if the server \"" + server + "\" is down.");
            } else {
                executionStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SERVER_UP);
                executionStep.setStepDescription("Check if the server \"" + server + "\" is up.");
            }
            c2.getContextBuilder().addExecutionStep(executionStep);
            if (this.checkStateAfterOperation(lcr.getState())) {
                if (eList == null) {
                    eList = new ArrayList<String>(3);
                }
                if (this.start) {
                    executionStep.setSuccess(false);
                    executionStep.setErrorMessage("The server \"" + server + "\" is already up & running.");
                } else {
                    executionStep.setSuccess(false);
                    executionStep.setErrorMessage("The server \"" + server + "\" is already down. Nothing to perform.");
                }
                eList.add(server);
                continue;
            }
            executionStep = new OPatchStepAdapter(OPatchFAStep.CHECK_IF_PROPER_STATE_FOR_SERVER);
            executionStep.setStepDescription("Check if the server \"" + server + "\" is in proper state for further operation.");
            c2.getContextBuilder().addExecutionStep(executionStep);
            if (!this.checkStateBeforeOperation(lcr.getState())) {
                if (aList == null) {
                    aList = new ArrayList<String>(3);
                }
                executionStep.setSuccess(false);
                executionStep.setErrorMessage("The server \"" + server + "\" is in not-desired state \"" + lcr.getState() + "\"");
                aList.add(server + " (" + lcr.getState() + ")");
                continue;
            }
            if (!(this.start || c2.stopAnyServer() || d2.isAssociatedWithCurrentOH(c2.getHomeGUID(), server))) {
                if (hList == null) {
                    hList = new ArrayList<String>(3);
                }
                hList.add(server);
                continue;
            }
            if (adminServer.equals(server)) continue;
            if (lMap == null) {
                lMap = new HashMap<String, ServerLifeCycleRuntimeMBean>(5);
            }
            lMap.put(server, lcr);
        }
        if (aList != null) {
            if (servers == null || servers.size() == 1) {
                Logger.error(RB.Entry.LIFE_CYCLE_OPERATION_NOT_SUPPORTED, ((Object)aList).toString());
            } else {
                Logger.warn(RB.Entry.LIFE_CYCLE_OPERATION_NOT_SUPPORTED, ((Object)aList).toString());
            }
            if (!this.start) {
                servers.removeAll(aList);
            }
            if (aList.contains(adminServer)) {
                operationOnAdminServer = false;
            }
        }
        if (eList != null) {
            if (servers == null || servers.size() == 1) {
                if (OLogger.isOPatchCmdLineMode()) {
                    Logger.warn(RB.Entry.LIFE_CYCLE_OPERATION_NOT_REQUIRED, ((Object)eList).toString());
                } else {
                    Logger.error(RB.Entry.LIFE_CYCLE_OPERATION_NOT_REQUIRED, ((Object)eList).toString());
                }
            } else {
                Logger.warn(RB.Entry.LIFE_CYCLE_OPERATION_NOT_REQUIRED, ((Object)eList).toString());
            }
            if (!this.start) {
                servers.removeAll(eList);
            }
            if (eList.contains(adminServer)) {
                operationOnAdminServer = false;
            }
        }
        if (hList != null) {
            if (servers == null || servers.size() == 1) {
                Logger.error(RB.Entry.SERVERS_NOT_ASSOCIATED_WITH_CURRENT_OH, ((Object)hList).toString());
            } else {
                Logger.warn(RB.Entry.SERVERS_NOT_ASSOCIATED_WITH_CURRENT_OH, ((Object)hList).toString());
            }
            if (!this.start) {
                servers.removeAll(hList);
            }
            if (hList.contains(adminServer)) {
                operationOnAdminServer = false;
            }
        }
        if (lMap != null) {
            if (this.start) {
                executionStep = new OPatchStepAdapter(OPatchFAStep.START_MANAGED_SERVER);
                if (!report) {
                    executionStep.setStepDescription("Start the server \"" + lMap.keySet().toString() + "\"");
                } else {
                    executionStep.setStepDescription("[Skip] Start the server \"" + lMap.keySet().toString() + "\"");
                }
            } else {
                executionStep = new OPatchStepAdapter(OPatchFAStep.STOP_MANAGED_SERVER);
                if (!report) {
                    executionStep.setStepDescription("Stop the server \"" + lMap.keySet().toString() + "\"");
                } else {
                    executionStep.setStepDescription("[Skip] Stop the server \"" + lMap.keySet().toString() + "\"");
                }
            }
            c2.getContextBuilder().addExecutionStep(executionStep);
            if (!report) {
                this.run((Map<String, ServerLifeCycleRuntimeMBean>)lMap, timeout, executionStep);
            }
            lMap.clear();
        }
        if (!this.start && operationOnAdminServer) {
            ServerLifeCycleRuntimeMBean lcr = d2.getServerLifeCycleRuntimeMBean(adminServer);
            executionStep = new OPatchStepAdapter(OPatchFAStep.CHECK_IF_PROPER_STATE_FOR_SERVER);
            executionStep.setStepDescription("Check if the admin server \"" + adminServer + "\" is in proper state for further operation.");
            c2.getContextBuilder().addExecutionStep(executionStep);
            if (!this.checkStateBeforeOperation(lcr.getState())) {
                executionStep.setSuccess(false);
                executionStep.setErrorMessage("The admin server \"" + adminServer + "\" is in not-desired state \"" + lcr.getState() + "\"");
                Logger.warn(RB.Entry.LIFE_CYCLE_OPERATION_NOT_SUPPORTED, "[" + adminServer + "]");
                return;
            }
            if (Logger.debug) {
                Logger.debug("Stopping Admin Server ...");
            }
            try {
                executionStep = new OPatchStepAdapter(OPatchFAStep.STOP_ADMIN_SERVER);
                executionStep.setStepDescription("Stop Admin Server");
                c2.getContextBuilder().addExecutionStep(executionStep);
                d2.connectedToNM(adminServer);
                NodeManagerClient nmc = d2.getNMClient();
                if (!report) {
                    if (nmc.getState().equals("RUNNING")) {
                        if (!nmc.stop(timeout)) {
                            if (nmc.excep != null) {
                                throw nmc.excep;
                            }
                            throw new RuntimeException("Failed to stop Admin Server");
                        }
                    } else {
                        d2.connected(false);
                        lcr.forceShutdown();
                    }
                } else {
                    executionStep.setStepDescription("[Skip] Stop Admin Server");
                }
                if (!report && !nmc.wait(timeout, "SHUTDOWN")) {
                    Logger.error(RB.Entry.ERROR_IN_LIFE_CYCLE_OPERATION, "[" + adminServer + "]");
                }
            }
            catch (Exception e3) {
                executionStep.setSuccess(false);
                executionStep.setExceptionObject(new RuntimeException(e3));
                if (e3 != null) {
                    executionStep.setErrorMessage(e3.getMessage());
                }
                Logger.loge(e3);
            }
        }
    }

    private void run(Map<String, ServerLifeCycleRuntimeMBean> lMap, int timeout, OPatchStepAdapter executionStep) {
        HashMap<String, ServerLifeCycleTaskRuntimeMBean> tMap = new HashMap<String, ServerLifeCycleTaskRuntimeMBean>(lMap.size() + 1, 1.0f);
        ArrayList<String> eList = null;
        for (String server : lMap.keySet()) {
            ServerLifeCycleRuntimeMBean lcr = lMap.get(server);
            try {
                if (this.start) {
                    if ("ADMIN".equals(lcr.getState())) {
                        tMap.put(server, lcr.resume());
                        continue;
                    }
                    tMap.put(server, lcr.start());
                    continue;
                }
                tMap.put(server, lcr.forceShutdown());
            }
            catch (Exception e2) {
                executionStep.setSuccess(false);
                if (e2 != null) {
                    executionStep.setErrorMessage(e2.getMessage());
                    executionStep.setExceptionObject(new RuntimeException(e2));
                }
                Logger.loge(e2);
                if (eList == null) {
                    eList = new ArrayList<String>(3);
                }
                eList.add(server);
            }
        }
        if (eList != null) {
            Logger.loge("Error occurred while starting Life Cycle Operation on following servers " + ((Object)eList).toString());
            eList.clear();
        }
        if (this.c.getContextBuilder().isTimeout()) {
            block7: for (int i2 = 0; i2 < timeout; i2 += 5) {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (Exception e3) {
                    Logger.loge(e3);
                }
                for (String server : tMap.keySet()) {
                    if (!((ServerLifeCycleTaskRuntimeMBean)tMap.get(server)).isRunning()) continue;
                    continue block7;
                }
            }
            for (String server : tMap.keySet()) {
                if (((ServerLifeCycleTaskRuntimeMBean)tMap.get(server)).isRunning()) {
                    Logger.loge("Life Cycle Operation on Server [" + server + "] is still going on. Timed out.");
                    continue;
                }
                if ("TASK COMPLETED".equals(((ServerLifeCycleTaskRuntimeMBean)tMap.get(server)).getStatus())) {
                    Logger.logi("Life Cycle Operation on Server [" + server + "] completed succesfully.");
                    continue;
                }
                Exception e4 = ((ServerLifeCycleTaskRuntimeMBean)tMap.get(server)).getError();
                if (e4 == null) continue;
                executionStep.setSuccess(false);
                executionStep.setErrorMessage(e4.getMessage());
                executionStep.setExceptionObject(new RuntimeException(e4));
                Logger.loge("Exception while doing Life Cycle Operation on Server [" + server + "].");
                Logger.loge(e4);
            }
            try {
                TimeUnit.SECONDS.sleep(20L);
            }
            catch (Exception e5) {
                Logger.logi("Exception during synchronization timeout [after task completion, before checking for server state]");
                Logger.loge(e5);
            }
            for (String server : lMap.keySet()) {
                String state = lMap.get(server).getState();
                if (this.checkStateAfterOperation(state)) continue;
                Logger.logi("Server \"" + server + "\" is in not desirable state \"" + state + "\" after operation.");
                if (eList == null) {
                    eList = new ArrayList(3);
                }
                eList.add(server + "[ " + state + " ]");
            }
            if (eList != null && !eList.isEmpty()) {
                if (executionStep.isSuccess()) {
                    executionStep.setSuccess(false);
                    executionStep.setErrorMessage(Logger.getString(RB.Entry.ERROR_IN_LIFE_CYCLE_OPERATION, ((Object)eList).toString()));
                }
                Logger.error(RB.Entry.ERROR_IN_LIFE_CYCLE_OPERATION, ((Object)eList).toString());
            }
        } else {
            this.c.getContextBuilder().setServerLifecycleInfo(lMap, tMap, executionStep);
        }
    }

    private boolean checkStateBeforeOperation(String state) {
        if (this.start) {
            return true;
        }
        return !this.start && ("RUNNING".equals(state) || "ADMIN".equals(state));
    }

    private boolean checkStateAfterOperation(String state) {
        if (this.start && "RUNNING".equals(state)) {
            return true;
        }
        return !this.start && "SHUTDOWN".equals(state);
    }
}

