/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.NApplyOperator;
import oracle.opatch.twophase.NRollbackOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseOneExecutor {
    public void execute(String soh, PatchObject[] nApplyPatch, PatchObject[] nRollbackPatch) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseOneExecutor::execute(String soh, PatchObject[] nApplyPatch, PatchObject[] nRollbackPatch)");
        NRollbackOperator nRollback = new NRollbackOperator();
        OLogger.justlog(OLogger.INFO, "Start to run phase one for rollback patches.");
        nRollback.run(soh, nRollbackPatch);
        ArrayList<File> files = new ArrayList<File>();
        String comps = soh + File.separator + "inventory" + File.separator + "ContentsXML" + File.separator + "comps.xml";
        files.add(new File(comps));
        this.breakHardLink(files);
        OLogger.justlog(OLogger.INFO, "Start to run phase one for apply patches.");
        NApplyOperator nApply = new NApplyOperator();
        nApply.run(soh, nApplyPatch);
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseOneExecutor::execute(String soh, PatchObject[] nApplyPatch, PatchObject[] nRollbackPatch)");
    }

    private void breakHardLink(List<File> files) {
        for (File f2 : files) {
            OLogger.justlog(OLogger.INFO, "Start to break hardlink for file \" {0} \"" + f2.getAbsolutePath());
            SystemCall.breakHardLink(f2);
            OLogger.justlog(OLogger.INFO, "Complete breaking hardlink for file \" {0} \"" + f2.getAbsolutePath());
        }
    }
}

