/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcl;

import java.io.IOException;
import java.util.Date;
import oracle.sysman.oii.oiic.OiicInstVersion;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcc.OipccEndPrereqSessionException;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqChecker;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqListener;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqEvent;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;

public class OipclPrereqLogger
implements OipcpIPrereqListener {
    private String m_sLogLoc = "";
    private static final String LINE = "--------------------------------------------------------------------------------";
    private static OipclPrereqLogger s_prereqLogger;

    public static void initialize(String sLogLoc) throws IOException, OipccEndPrereqSessionException {
        s_prereqLogger = new OipclPrereqLogger(sLogLoc);
        s_prereqLogger.initialize();
    }

    public static void init() {
        s_prereqLogger = new OipclPrereqLogger();
    }

    public static OipclPrereqLogger getLogger() {
        return s_prereqLogger;
    }

    private OipclPrereqLogger(String sLogLoc) throws OipccEndPrereqSessionException {
        try {
            String sLogPrefix = "prereq";
            OiiolTextLogger.setLogLoc((String)sLogLoc, (String)sLogPrefix);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            Object[] args = new String[]{sLogLoc};
            String sMessage = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13001", (Object[])args);
            throw new OipccEndPrereqSessionException(sMessage, ioe);
        }
    }

    private OipclPrereqLogger() {
    }

    @Override
    public void onPrereqEvent(OipcpPrereqEvent oEvent) {
        OipcpPrerequisiteCheck oCheck = null;
        switch (oEvent.getID()) {
            case 0: {
                Object[] args = new String[]{new Date().toString()};
                String sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13002", (Object[])args);
                OipclPrereqLogger.logText(sMsg);
                break;
            }
            case 1: {
                Object[] args = new String[]{new Date().toString()};
                String sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13003", (Object[])args);
                OipclPrereqLogger.logText(sMsg);
                break;
            }
            case 2: {
                oCheck = (OipcpPrerequisiteCheck)oEvent.getEventInfo();
                Object[] args = new String[]{oCheck.getName(), oCheck.getDescription()};
                String sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13004", (Object[])args);
                OipclPrereqLogger.logText(sMsg);
                break;
            }
            case 3: {
                oCheck = (OipcpPrerequisiteCheck)oEvent.getEventInfo();
                OipcpPrerequisiteResult oResult = oCheck.getResult();
                OipclPrereqLogger.logText(oResult.getFormattedResultText());
                OipclPrereqLogger.logText(LINE);
            }
        }
    }

    public void initialize() throws IOException {
        Object[] args = new String[]{OiicInstVersion.getVersionString()};
        String sHeader = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13006", (Object[])args);
        OipclPrereqLogger.logText(sHeader);
    }

    public static void logText(String sMessage) {
        OiiolTextLogger.appendText((String)sMessage);
    }

    @Override
    public void registerChecker(OipcpIPrereqChecker oChecker) {
    }
}

