/* Copyright (c) 1986, 2010, Oracle and/or its affiliates. 
All rights reserved. */

/*
   NAME
     enumservices.h - header file for enumservices.c

   DESCRIPTION
     Definitions for Enumerating NT Services.

   RELATED DOCUMENTS
     enumservices.c

   EXPORT FUNCTION(S)
     ssgetRunningProcessW32 - JNI Interface to native code to enumerate 
							  (running) NT services associated input list
							  of modules (DLL or EXE)

   INTERNAL FUNCTION(S)
     None

   EXAMPLES
     None

   NOTES
     See comments
     

   MODIFIED    (MM/DD/YYYY)
      dschrein   07/12/10 - update for 11.2
     avale      10/06/1999 - created
     mmckerle   01/13/2000 - Added jstring parameter to formal declaration to allow
                             for runtime linking with psapi DLL
*/

#include <jni.h>

/* Header for class ssgetArchitecture */

#ifndef _Included_ssgetRunningProcessClassW32
#define _Included_ssgetRunningProcessClassW32

#ifdef __plusplus
extern "c" {
#endif

/*-----------------------------------------------------------------
                        EXPORT FUNCTIONS
 -----------------------------------------------------------------*/

/*---------------------- ssGetRunningProcessW32 ------------------*/
/*
   NAME
      ssGetRunningProcessW32- Java Interface to EnumServices

   DESCRIPTION
      This is the Java Interface to the other native internal functions

   REQUIRES


   PARAMETERS
      Formals:
         env - pointer to a JNI struct which contains Java functions 
         obj - number of modules in above array
         filenames - array of input modules (DLL or EXE) to process
         scratchPath - string which stores dir for extracted DLL

   RETURNS
      This return values for ssgetRunningProcessW32() are:
			NULL if failure (a fatal exception was thrown)
			NULL if No Services were found (no exception was thrown)
			An array of running services associated with the input modules (DLL or EXE)
         
   EXCEPTIONS
      This function throws Native Java Exceptions with the following values:
		 - RuntimeException if one of the following occurs:
				More than 200 input modules were specified
				EnumerateProcesses() failed
				OpenProcess() failed
				EnumProcessModules() failed
				GetModuleFilenameEx() failed
				Reservation of memory failed for an unknown reason
				Commital of memory failed for an unknown reason
				More than PLIMIT pages of memory was required to read in the services
				EnumerateServices() failed
				QueryServiceConfig() failed
				An unknown error occured
		 - NoServicesForProcessException if some of the input modules were running,
		      but no services were associated with them (most likely a running app)

   EXAMPLES

   NOTES
      See comments
*/
JNIEXPORT jobjectArray JNICALL Java_oracle_install_library_processes_ssgetRunningProcessClassW32_ssgetRunningProcessW32
     (JNIEnv *,jobject,jobjectArray,jstring);

       
#ifdef __cplusplus
}
#endif
#endif
