BEGIN{
my @modules=('Sys::Hostname',' File::Basename','Cwd','File::Find','File::Copy','File::Path','Getopt::Long','File::stat','Pod::Usage');
  foreach my $moduleName (@modules) {
    my $moduleDefined=eval "use $moduleName; 1" ?1:0;
    if($moduleDefined==0){
       print("\n$moduleName  module not present/module is not accessible\n");
       exit(2);
    }
  }
}

#Stick to perl version v5.x.x
use v5.8.8;
use File::Basename qw(dirname basename);
use Cwd  qw(abs_path);
use lib dirname(abs_path($0));

use module::CommandOptions qw(removeOpt getArguments getOptValue optExists  isDescSession  isApplySession isRollbackSession processArgs);
use module::DBUtilServices qw(getJavaHomePath getJreMemoryOptions);
use module::OPatchAutoBinaryCommandOptions qw();
use module::ClassPathLib qw(setBaseDir setCP getOPatchAutoBinaryCP);

#Dumping additional args which does not have mapping.
foreach my $key (@ARGV) {
  processArgs($key);
}

my $scriptDir=dirname(abs_path($0));
my $opatchAutoDBDir=dirname($scriptDir);
my  $opatchAutoDir=dirname($opatchAutoDBDir);
my $BASE=dirname($opatchAutoDir);
my $DETECT_OH=dirname($BASE);
setBaseDir($BASE);

my $OH="";
if(optExists('oh') == 1){
 $OH=getOptValue('oh');
}elsif(defined $ENV{'ORACLE_HOME'}){
 $OH=$ENV{'ORACLE_HOME'};
}

if(optExists('version') == 0 && optExists('help') == 0 && (isApplySession()==0 && isRollbackSession()==0)){
 print("\nERROR : Select either apply or rollback session.\n");
 exit(2);
}

if(optExists('version') == 0 && optExists('help') == 0 && length $OH == 0 ){
 print("\n ERROR : Provide a valid value for Oracle Home using '-oh' option\n");
 exit(3);
}

my $CP=$DETECT_OH."/oui/jlib";
setCP($CP);

my $jreOpt="";
if(optExists('jre')==1){
 $jreOpt=getOptValue('jre');
}


my $JAVA_HOME=getJavaHomePath($DETECT_OH,$jreOpt);
my $JAVA=$JAVA_HOME."/bin/java";
removeOpt('jre');

my $ouiLoc=getOptValue('oui');
if(optExists('oui')==0 || ! -d getOptValue('oui')){
  $ouiLoc=$DETECT_OH."/oui";
  if(! -d $ouiLoc){
   $ouiLoc="";
  }
}

my $JRE_MEMORY_OPTIONS="";
if(defined $ENV{'JRE_MEMORY_OPTIONS'}){
 $JRE_MEMORY_OPTIONS=$ENV{'JRE_MEMORY_OPTIONS'};
}
$JRE_MEMORY_OPTIONS=getJreMemoryOptions($ouiLoc."/oraparam.ini",$JRE_MEMORY_OPTIONS,$JAVA);

my $JAVA_VM_OPTION="";
if(defined $ENV{'JAVA_VM_OPTION'}){
  $JAVA_VM_OPTION=$ENV{'JAVA_VM_OPTION'};
}

my $args=getArguments();
my $systemProps="-DOPatchauto.ORACLE_HOME=".$OH." -DOPatch.ORACLE_HOME=".$OH;
my $opatchAutoBinaryCP=getOPatchAutoBinaryCP();
my $opatchAutoBinaryJava=$JAVA." ".$JAVA_VM_OPTION." ".$JRE_MEMORY_OPTIONS." -cp ".$opatchAutoBinaryCP." ".$systemProps." oracle/opatchauto/core/OPatchAutoCore ".$args;

my $result=system($opatchAutoBinaryJava);
$result = $result >> 8;
exit($result);