#Stick to perl version v5.x.x
use v5.8.8;
use strict;
use warnings;

use Sys::Hostname;
use File::Basename qw(dirname basename);
use File::Find;
use File::Copy;
use Cwd  qw(abs_path getcwd);
use lib dirname(abs_path($0));
use module::CommandOptions qw(addOpt removeOpt removeAllOpt getArgumentCnt getArguments getOptValue optExists  isDescSession isActionSession isApplySession isRollbackSession isResumeSession processArgs);
use module::BootStrapCommandOptions qw();
use module::ClassPathLib qw(setBaseDir setDetectOH setCP setSrvmLibPath getLibPathForBootStrapping);
use module::DBUtilServices qw(getActiveUser getFileOwner getFileOwnerGroup changeFileOwner changeFilePermission copyRecursively createDirectory  removeDirectory openFile closeFile writeFile readFile copyRecursively readPropertiesFile touchFile);
use File::Path qw(mkpath);

#Dumping additional args which does not have mapping.
foreach my $key (@ARGV) {
  processArgs($key);
}

# Finding out host name
my $host = hostname();
$host = (split('\.', $host))[0];

my $BASEDIR=getOptValue('base');
my $OPATCHAUTODB_DIR=$BASEDIR."/auto/database";
my $OPATCHAUTO_DIR=$BASEDIR."/auto";
my $OPATCHAUTO_CORE_DIR=$OPATCHAUTO_DIR."/core";
setBaseDir($BASEDIR);

my $OPATCHAUTO_OWNER=getFileOwner($OPATCHAUTO_DIR);
my $OPATCHAUTO_GROUP=getFileOwnerGroup($OPATCHAUTO_DIR);

my $DETECT_OH=getOptValue('detect_oh');
setDetectOH($DETECT_OH);
my $OPATCHAUTODB_LOG_DIR=$DETECT_OH."/cfgtoollogs/opatchautodb";
my $OPATCHAUTODB_DRIVER_LOG_DIR=$DETECT_OH."/cfgtoollogs/opatchautodb/driver";
my $OPATCHAUTO_LOG_DIR=$DETECT_OH."/cfgtoollogs/opatchauto";
my $OPLAN_LOG_DIR=$DETECT_OH."/cfgtoollogs/oplan";
my $DBTMP=$OPATCHAUTO_DIR."/dbtmp";
my %libraryPath=('SRVM_SO',"",'SRVM_HAS_SO',"",'SRVM_JARS',"",'SRVM_HAS_JAR',"",'SRVM_ASM_JAR',"",'ROOTCRS_PL',"",'ROOTHAS_PL',"");
my $CRSCONFIG_PARAM="";


my $DEBUG=getOptValue('DEBUGVAL');;

createChangeFolderPermission( $DBTMP );
createChangeFolderPermission( $OPATCHAUTODB_LOG_DIR );
createChangeFolderPermission( $OPATCHAUTODB_DRIVER_LOG_DIR );
createChangeFolderPermission( $OPATCHAUTO_LOG_DIR );
createChangeFolderPermission( $OPLAN_LOG_DIR );

my $SESSION_ID="";
my $LAST_SESSION_ID="";

 my $DBSESSIONINFO=$OPATCHAUTO_DIR."/dbsessioninfo";
if(getOptValue('isActionSession')==1){
 my $fh="";
 if(-e $DBSESSIONINFO."/lastsessioninfo_".$host.".txt"){
   $fh=openFile($DBSESSIONINFO."/lastsessioninfo_".$host.".txt",0);
   $LAST_SESSION_ID=readFile($fh);
   closeFile($fh);
 }else{
  $fh=openFile($DBSESSIONINFO."/lastsessioninfo_".$host.".txt",1);
  closeFile($fh);
 }

 
 $fh=openFile($DBSESSIONINFO."/sessioninfo.txt",0);
 $SESSION_ID=readFile($fh);
 closeFile($fh);
 if($DEBUG eq "true"){
   print("\nSESSION_ID: $SESSION_ID\n");
   print("\nLAST_SESSION_ID: $LAST_SESSION_ID\n");
 }
}
my $OPATCHAUTO_TEMP=$DBTMP."/bootstrap_".$host;
my $PATCHWORK=$OPATCHAUTO_TEMP."/patchwork";
my $PATCH_TRACKING_DATA=$DBSESSIONINFO;
my $SRVM_JLIB=$DETECT_OH."/jlib";
setSrvmLibPath($SRVM_JLIB);
setCP(getOptValue('cp'));

my $CLASSPATH = getLibPathForBootStrapping();

my $JAVA = getOptValue('java');
my $JRE_MEMORY_OPTIONS = getOptValue('jre_memory_options');
$JRE_MEMORY_OPTIONS=~s/#/\ /g;

my $JAVA_VM_OPTION = getOptValue('java_vm_option');
my $args=getArguments();
$args = (split ("-ARGS", $args))[1];

if(optExists('sdb')==1 || optExists('topology')==1 || optExists('dg')==1 || optExists('sidbonly')==1 || optExists('sidb')==1){
   exit(0);
 }
  
if(getOptValue('isoper') == 1  || getOptValue('isActionSession') == 1 && $SESSION_ID ne $LAST_SESSION_ID ){
  my $fh=openFile($DBSESSIONINFO."/lastsessioninfo_".$host.".txt",1);
  writeFile($fh,$SESSION_ID);
  closeFile($fh);
  
  #removeDirectory($OPATCHAUTO_TEMP); => This will be taken care as part of PatchPatchReader invocation
  createDirectory($PATCH_TRACKING_DATA);
  createDirectory($PATCHWORK."/crs/install");
  createDirectory($PATCHWORK."/lib");
  createDirectory($PATCHWORK."/jlib");
  
  my $gridHome="";
  my $gridVersion="";
  
  if(optExists('GRID_HOME')==1){
   $gridHome=getOptValue('GRID_HOME');
  }
  if(optExists('GRID_VERSION')==1){
   $gridVersion=getOptValue('GRID_VERSION');
  }
  my $OUI_LOCATION="";
  if(defined $ENV{'OUI_LOCATION'}){
   $OUI_LOCATION=$ENV{'OUI_LOCATION'};
  }
   my $oracleOcmService="";
   if(optExists('oracleocmservice')==1){
     $oracleOcmService=getOptValue('oracleocmservice');
  }
  my $bootClassPath="";
  $fh=openFile($PATCHWORK."/patchloc.txt",0);
  my $PATCH_PATH=readFile($fh);
  closeFile($fh);
  if($DEBUG eq "true"){
    print("\nPatchPath: $PATCH_PATH\n");
    print("\nParam: $PATCH_PATH\n");
  }
  
  if(getOptValue('isoper') eq "1"){
    if(optExists('bootclasspath')==1){
      $bootClassPath=getOptValue('bootClassPath');
    }
    my $systemProperties="-DOPatch.ORACLE_HOME=".$DETECT_OH." -DOPatchauto.GRID_VERSION=".$gridVersion." -DOPatchauto.GRID_HOME=".$gridHome." -DOPatch.OUI_LOCATION=".$OUI_LOCATION." -DOPatchauto.PATCHWORK_PATH=".$PATCHWORK." ".$oracleOcmService." ".$bootClassPath;
    my $patchVersionReaderJavaInvocation=$JAVA." ".$JAVA_VM_OPTION." ".$JRE_MEMORY_OPTIONS." -cp ".$CLASSPATH." ".$systemProperties." com.oracle.glcm.patch.auto.db.utils.PatchVersionReader ".$PATCH_PATH;
   if($DEBUG eq "true"){
     print("\n$patchVersionReaderJavaInvocation\n");
   } 
   my $status = system($patchVersionReaderJavaInvocation);
   $status = $status >> 8;
   if($DEBUG eq "true"){
    print("\nResult: $status\n");
   }
   
   if($status!=0){
    print("\nPatch version not found\n");
    exit($status);
   }
  }
  
  my $GRID_HOME_PATH="";
  my $PATCH_WITH="";
  my $operationType=getOptValue('operationtype');
  my %hash=readPropertiesFile($PATCHWORK."/bootstrap.properties");
  my $size=keys %hash;
  if($size>0){
	  if($hash{'BOOTSTRAP_PATH'}) {
	     $PATCH_WITH=$hash{'BOOTSTRAP_PATH'};
		 if($DEBUG eq "true"){
		    print("\nPatch With::$PATCH_WITH\n");
		 }
	  }
	  if($hash{'GRID_HOME_PATH'}) {
	     $GRID_HOME_PATH=$hash{'GRID_HOME_PATH'};
		 if($DEBUG eq "true"){
		    print("\nHome path::$GRID_HOME_PATH\n");
		 }
	  }
	  if(getOptValue('isActionSession')==1 && $hash{'COMMAND'}) {
	    $operationType=$hash{'COMMAND'};
        if($DEBUG eq "true"){
           print("\noperationType: $operationType\n");
        }
	  }
  }

 my $ROOT_CRS_TMP="";
 $SRVM_JLIB=$GRID_HOME_PATH."/jlib";
 my $LD_LIB_TMP=$GRID_HOME_PATH."/lib";

 if($PATCH_WITH eq "patch"){
      if($DEBUG eq "true"){
        print("\nwork with Patch\n");
      }
      
      if($operationType eq "apply"){
		  my $pwd = getcwd();
		  if (-d $PATCH_PATH){
            chdir($PATCH_PATH);
		  }
          find ( \&findInPatchPath, $PATCH_PATH );
          if($DEBUG eq "true"){
           print("\nSRVM JARS: $libraryPath{'SRVM_JARS'} $libraryPath{'SRVM_HAS_JAR'} $libraryPath{'SRVM_ASM_JAR'}\n");
           print("\nRootCrs: $libraryPath{'ROOTCRS_PL'}\n");
           print("\nRootHas: $libraryPath{'ROOTHAS_PL'}\n");
           print("\nSO files: $libraryPath{'SRVM_SO'} $libraryPath{'SRVM_HAS_SO'}\n");
         }
         
         if(length $libraryPath{'ROOTCRS_PL'} > 0){
          my $ROOTCRS_DIR=dirname($libraryPath{'ROOTCRS_PL'});
          copyRecursively($ROOTCRS_DIR,$PATCHWORK."/crs/install");
         }elsif(length $libraryPath{'ROOTHAS_PL'} > 0){
          my $ROOTHAS_DIR=dirname($libraryPath{'ROOTHAS_PL'});
          copyRecursively($ROOTHAS_DIR,$PATCHWORK."/crs/install");
         }else{
          copyRecursively($GRID_HOME_PATH."/crs/install",$PATCHWORK."/crs/install");
         }
		 chdir($GRID_HOME_PATH."/crs/install/");
         find ( \&findConfigParamInGrid, $GRID_HOME_PATH."/crs/install/" );
         if(length $CRSCONFIG_PARAM > 0){
            print("\n boot strap copying crsconfig_params\n");
            copy($GRID_HOME_PATH."/crs/install/crsconfig_params",$PATCHWORK."/crs/install");
         }
         chdir($pwd);
         
         if(length  $libraryPath{'SRVM_SO'} > 0){
          copy($libraryPath{'SRVM_SO'},$PATCHWORK."/lib");
         }else{
          copy($GRID_HOME_PATH."/lib/libsrvm12.so",$PATCHWORK."/lib");
         }
         
         if(length  $libraryPath{'SRVM_HAS_SO'} > 0){
          copy($libraryPath{'SRVM_HAS_SO'},$PATCHWORK."/lib");
         }else{
          copy($GRID_HOME_PATH."/lib/libsrvmhas12.so",$PATCHWORK."/lib");
         }
         
         if(length  $libraryPath{'SRVM_JARS'} > 0){
          copy($libraryPath{'SRVM_JARS'},$PATCHWORK."/jlib");
         }else{
          copy($GRID_HOME_PATH."/jlib/srvm.jar",$PATCHWORK."/jlib");
         }
         
         if(length  $libraryPath{'SRVM_HAS_JAR'} > 0){
          copy($libraryPath{'SRVM_HAS_JAR'},$PATCHWORK."/jlib");
         }else{
          copy($GRID_HOME_PATH."/jlib/srvmhas.jar",$PATCHWORK."/jlib");
         }
         
         if(length  $libraryPath{'SRVM_ASM_JAR'} > 0){
          copy($libraryPath{'SRVM_ASM_JAR'},$PATCHWORK."/jlib");
         }else{
          copy($GRID_HOME_PATH."/jlib/srvmasm.jar",$PATCHWORK."/jlib");
         }
     }elsif($operationType eq "rollback"){
	       copyLibFromGridHome($GRID_HOME_PATH);
     }
  }elsif($PATCH_WITH eq "gihome"){
    if($DEBUG eq "true"){
        print("\n work with grid home files\n");
        print("\nGRID_HOME_PATH: $GRID_HOME_PATH \n");
    }
	copyLibFromGridHome($GRID_HOME_PATH);
  }
  changeFileOwner($OPATCHAUTO_OWNER,$OPATCHAUTO_GROUP,$OPATCHAUTO_TEMP);
  changeFilePermission($OPATCHAUTO_TEMP,"0775");
       changeFileOwner($OPATCHAUTO_OWNER,$OPATCHAUTO_GROUP,$DETECT_OH."/OPatch/auto/dbsessioninfo/lastsessioninfo_".$host.".txt");
}

sub copyLibFromGridHome{
   my $GRID_HOME_PATH = $_[0]; 
   print("\nGRID_HOME_PATH: $GRID_HOME_PATH \n");
   copyRecursively($GRID_HOME_PATH."/crs/install",$PATCHWORK."/crs/install");
   copy($GRID_HOME_PATH."/lib/libsrvm12.so",$PATCHWORK."/lib");
   copy($GRID_HOME_PATH."/lib/libsrvmhas12.so",$PATCHWORK."/lib");
   copy($GRID_HOME_PATH."/lib/libhasgen12.so",$PATCHWORK."/lib");
   copy($GRID_HOME_PATH."/jlib/srvm.jar",$PATCHWORK."/jlib");
   copy($GRID_HOME_PATH."/jlib/srvmhas.jar",$PATCHWORK."/jlib");
   copy($GRID_HOME_PATH."/jlib/srvmasm.jar",$PATCHWORK."/jlib");
}

sub findConfigParamInGrid{
   my $file_name =  $File::Find::name;
   if( -f $file_name && $file_name =~ /crsconfig_params/ ){
     $CRSCONFIG_PARAM=$File::Find::name;
     return;
   }
}

sub findInPatchPath {
    my $file_name =  $File::Find::name;
    my $libsrvm12SOFile="files/oui/lib/libsrvm12.so";
    my $libsrvmHas12SOFile="files/oui/lib/libsrvmhas12.so";
    my $srvm="files/jlib/srvm.jar";
    my $srvmHas="files/jlib/srvmhas.jar";
    my $srvmasm="files/jlib/srvmasm";
    
    if ( -f $file_name && $file_name =~ /$libsrvm12SOFile/ ) {
     $libraryPath{'SRVM_SO'}= $File::Find::name;
    }elsif( -f $file_name && $file_name =~ /$libsrvmHas12SOFile/ ){
      $libraryPath{'SRVM_HAS_SO'}= $File::Find::name;
    }elsif( -f $file_name && $file_name =~ /$srvm/ ){
      $libraryPath{'SRVM_JARS'}= $File::Find::name;
    }elsif( -f $file_name && $file_name =~ /$srvmHas/ ){
      $libraryPath{'SRVM_HAS_JAR'}= $File::Find::name;
    }elsif( -f $file_name && $file_name =~ /$srvmasm/ ){
      $libraryPath{'SRVM_ASM_JAR'}= $File::Find::name;
    }elsif( -f $file_name && $file_name =~ /rootcrs.pl/ ){
      $libraryPath{'ROOTCRS_PL'}= $File::Find::name;
    }elsif( -f $file_name && $file_name =~ /roothas.pl/ ){
      $libraryPath{'ROOTHAS_PL'}= $File::Find::name;
    }
}

sub createChangeFolderPermission {
	my $folder = shift;
	createDirectory($folder);
	touchFile ($folder."/tempFile.txt", $folder);
	unlink $folder."/tempFile.txt";
	changeFileOwner($OPATCHAUTO_OWNER,$OPATCHAUTO_GROUP,$folder);
	changeFilePermission($folder,"0775");
}
