@echo off

REM #
REM # Copyright (c) 2001, 2003 Oracle Corporation.  All rights reserved.
REM #
REM # PRODUCT
REM #   OID LDIF Migration to OID
REM #
REM # FILENAME
REM #   LDIFMigrator.bat
REM #
REM # DESCRIPTION
REM #   This script is used to launch the LIDF Migration.
REM #
REM # NOTE:
REM #
REM #   ldifmigrator -help prints usage
REM #
REM #   Note that parameters containing an '=' sign must be 
REM #   double-quoted when invoking this script, else they will 
REM #   be broken up into separate parameters at the = sign
REM #   and errors will result.
REM #

SETLOCAL

REM # Check ORACLE_HOME is defined
IF "%ORACLE_HOME%x" == "x" GOTO NO_ORACLE_HOME
SET JAVAEXE=%ORACLE_HOME%\jdk\bin\java

REM Set class path
SET LDAPJCLNT18=%ORACLE_HOME%\jlib\ldapjclnt18.jar
SET NETCFG=%ORACLE_HOME%\jlib\netcfg.jar

REM make sure ldapjclnt18.jar is present
IF NOT EXIST %LDAPJCLNT18% GOTO NO_LDAPJCLNT18JAR_FILE

SET CLASSPATH=%LDAPJCLNT18%;%NETCFG%;%ORACLE_HOME%\j2ee\home\jps-api.jar;%ORACLE_HOME%\j2ee\home\jps-internal.jar;

%JAVAEXE% -classpath %CLASSPATH% -DORACLE_HOME=%ORACLE_HOME% oracle.ldap.util.LDIFMigration %*

GOTO THE_END

:NO_LDAPJCLNT18JAR_FILE
   ECHO Missing jar file
   ECHO %LDAPJCLNT18% not found
   GOTO THE_END

:NO_ORACLE_HOME
  ECHO ORACLE_HOME is not defined

:THE_END
   ENDLOCAL
