#!/bin/sh

CMD=setProperty.sh
USAGE="Usage: $CMD [ -javaLoc <Path to JDK/JRE directory> ] -name <variable name>  -value <variable value> [ -logDir <path to log directory ]"
NOTES="Note:- 1. Additional JVM optional should be set by using 'JVM_ARGS' environment variable 
	      2. -javaLoc is used to specify the Java to be used to run this utility & should be the first argument."

JRE_LOC="-javaLoc"

if [[ "$#" -eq 0 ]] || [[ "$1" = "-help" ]]
then
	echo $USAGE
	echo $NOTES
	exit 1;
fi
	
if [ "$1" = "$JRE_LOC" ]
then
	JAVA_HOME_LOCATION="$2"
fi

d="`dirname $0`"
if [ "$d" = "." ]; then
	d=`pwd`
fi


# Determine the default Java Home location
# 1) Use the location specified by -javaLoc 
# 1) else if "getProperty JAVA_HOME" provides a value, use it
# 3) else use env variable JAVA_HOME

JRELOC=""
if [ ! -z "$JAVA_HOME_LOCATION" ]; then
	 JRELOC="$JAVA_HOME_LOCATION"
fi

if [ -z "$JRELOC" -o ! -d "$JRELOC" ]; then
	if [ -x "$d/getProperty.sh" ] ; then
		JRELOC="`$d/getProperty.sh JAVA_HOME 2>/dev/null`"
	fi
fi

if [ -z "$JRELOC" -o ! -d "$JRELOC" ] ; then
	JRELOC="$JAVA_HOME"
fi

# fail if executed as ". setProperty.sh"
b="`basename $0 2>/dev/null`"
if [ "$b" != "$CMD" ] ; then
	echo "$USAGE"
	return
fi

if [ -z "$JRELOC" ] ; then
	echo "ERROR: Cannot determine the Java Home"
	echo "ERROR: Specify proper value for the -javaLoc option or export JAVA_HOME environment variable"
	echo $NOTES
	exit 1
fi

if [ ! -d "$JRELOC" ] ; then
	echo "ERROR: Java Home directory \"$JRELOC\" does not exist"
	exit 1
fi

case `uname -s` in
Windows*|CYGWIN*)
	AOUT="java.exe"
	;;
*)
	AOUT="java"
	;;
esac

if [ ! -f "$JRELOC/bin/$AOUT" ] ; then
	echo "ERROR: Java Home directory \"$JRELOC\" does not contain bin/$AOUT"
	exit 1
fi

# change to directory containing this script
cd "$d"
if [ -f "../jlib/OraInstaller.jar" ] ; then
	JAR="../jlib/OraInstaller.jar"
    OHOME="$d/../../"
else
	echo "ERROR: Cannot locate the OUI runtime.  Exiting"
	exit 1
fi

MAIN_CLASS=oracle.sysman.oui.property.SetProperty
if [ ! -d "$OHOME/oui/lib" ]; then
	 echo "Please run the script with absolute path."
	 exit 1
fi

LIB_DIR=`ls $OHOME/oui/lib`  # This is required because SetProperty uses OUI's logger
JAVA_OPTIONS=" "$JVM_ARGS" -Djava.library.path=$OHOME/oui/lib/$LIB_DIR"
# last -oracleHome option overrides any previous settings
"$JRELOC/bin/$AOUT" $JAVA_OPTIONS -classpath "$JAR" $MAIN_CLASS "$@" -oracleHome "$OHOME"

exit $?
