@echo off
rem 
rem Copyright (c) 2016, 2017, Oracle and/or its affiliates. 
rem All rights reserved.
rem 
rem    NAME
rem      dmucls.bat
rem
rem    DESCRIPTION
rem      The launcher file for DMU Command-line Scanner
rem

setlocal EnableDelayedExpansion

rem -----------------------------------------------
rem product-specific information
rem -----------------------------------------------
set PRODUCT_VERSION=2.2
set PRODUCT_SHORT_NAME=dmu
set JVM_MIN_MEMORY=-Xms128M
set JVM_MAX_MEMORY=-Xmx2048m

call:checkProcessBitness

set STARTING_CWD=%CD%
cd %0\..\dmu\bin
set WORKING_DIR=%CD%
set USER_DIR=%APPDATA%\%PRODUCT_SHORT_NAME%%BIT%\%PRODUCT_VERSION%
set USER_CONF=%USER_DIR%\product.conf
set NEED_UPDATE_CONFIG=false

if exist "%USER_CONF%" (
	:: Read settings from product.conf
	for /F "eol=# tokens=*" %%a in (%USER_CONF%) do (
		set LINE=%%a
		set PARAMETER=!LINE:~0,11!
		set VALUE=!LINE:~12!

		::trim left whitespace of the parameter value
		for /f "tokens=* delims= " %%a in ("!VALUE!") do set VALUE=%%a

		if "!PARAMETER!"=="SetJavaHome" (
			set JAVA_HOME=!VALUE!
			set JAVA_PATH=!JAVA_HOME!\bin\java.exe
		)
		if "!PARAMETER!"=="AddVMOption" (
			if "!VALUE:~0,4!"=="-Xms" set JVM_MIN_MEMORY=!VALUE!
			if "!VALUE:~0,4!"=="-Xmx" set JVM_MAX_MEMORY=!VALUE!
		)
	)
) else (
	:: Create product.conf
	if not exist "%USER_DIR%" mkdir "%USER_DIR%"
	(
		echo ##############################################################################
		echo #
		echo # The format of this file is:
		echo #
		echo # Directive  Value
		echo #
		echo # with one or more spaces between the directive and the value. This file
		echo # can be in either UNIX or DOS format for end of line terminators. Use UNIX
		echo # style '/' path separators, although on Windows some directives, such as
		echo # SetJavaHome, can take '\' path separators.
		echo #
		echo ##############################################################################
		echo.
		echo #
		echo # By default, the product launcher will search for a JDK to use, and if none
		echo # can be found, it will ask for the location of a JDK and store its location
		echo # in this file. If a particular JDK should be used instead, uncomment the
		echo # line below and set the path to your preferred JDK.
		echo #
		echo # SetJavaHome /path/jdk
		echo.
		echo #
		echo # Specify the initial size, in bytes, of the memory allocation pool. This
		echo # value must be a multiple of 1024 greater than 1MB. Append the letter k
		echo # or K to indicate kilobytes, or m or M to indicate megabytes, or g or G
		echo # to indicate gigabytes. The default value is chosen at runtime based on
		echo # the system configuration.
		echo # Examples:  -Xms6291456
		echo #            -Xms6144k
		echo #            -Xms6m
		echo #
		echo # You can specify one value for any JDK using AddVMOption, OR you can specify
		echo # separate values for 32-bit and 64-bit JDK's.
		echo #
		echo # AddVMOption -Xms128m
		echo # Add32VMOption -Xms128m
		echo # Add64VMOption -Xms128m
		echo.
		echo #
		echo # Specify the maximum size, in bytes, of the memory allocation pool. This
		echo # value must be a multiple of 1024 greater than 2MB. Append the letter k
		echo # or K to indicate kilobytes, or m or M to indicate megabytes, or g or G
		echo # to indicate gigabytes. The default value is chosen at runtime based on
		echo # the system configuration.
		echo # Examples:  -Xmx83886080
		echo #            -Xmx81920k
		echo #            -Xmx80m
		echo # On Solaris 7 and Solaris 8 SPARC platforms, the upper limit for this value
		echo # is approximately 4000m minus overhead amounts. On Solaris 2.6 and x86
		echo # platforms, the upper limit is approximately 2000m minus overhead amounts.
		echo # On Linux platforms, the upper limit is approximately 2000m minus overhead
		echo # amounts.
		echo #
		echo # If you are getting the 'Low Memory Warning' Message Dialog while running
		echo # the product, please increase the -Xmx value below from the default 800M to
		echo # something greater, like 1024M or 1250M.  If after increasing the value,
		echo # the product is no longer starting up because it fails to create a virtual
		echo # machine, then please reduce the modified -Xmx value, or use a 64bit JDK
		echo # which allows for very very large value for -Xmx.
		echo #
		echo # You can specify one value for any JDK using AddVMOption, OR you can specify
		echo # separate values for 32-bit and 64-bit JDK's.
		echo #
		echo # AddVMOption -Xmx800m
		echo # Add32VMOption -Xmx800m
		echo # Add64VMOption -Xmx800m
	)>"%USER_CONF%"
)

if "%JAVA_PATH%"=="" (
	:: If no custom JDK path, first check JAVA_HOME then any Java.exe on PATH
	if defined JAVA_HOME (
		set JAVA_PATH=%JAVA_HOME%\bin\java.exe
	) else (
		call:progInPath java.exe
	)
)

:checkJAVAPATH
if not exist "%JAVA_PATH%" (
	set NEED_UPDATE_CONFIG=true
	if not "%JAVA_PATH%"=="" (
		echo Error: %JAVA_PATH% not found or not a valid JDK
	)
	echo Type the full pathname of a JDK installation ^(or Ctrl-C to quit^)^, the path will be stored in %USER_CONF%
	set /p JAVA_HOME=
	set JAVA_PATH=!JAVA_HOME!\bin\java.exe
	goto:checkJAVAPATH
)
if "%NEED_UPDATE_CONFIG%"=="true" (
	if exist "%USER_CONF%" (
		:: write custom JAVA_HOME to product.conf
		set DONE_REPLACE=false
		ren "%USER_CONF%" product.tmp
        for /f "tokens=*" %%a in (%USER_DIR%\product.tmp) do (
            set foo=%%a
            :: replace the line with beginning of "SetJavaHome" and "# SetJavaHome "
            if "!foo:~0,11!"=="SetJavaHome" (
            	set "foo=SetJavaHome %JAVA_HOME%"
            	set DONE_REPLACE=true
            )
            if "!foo:~0,14!"=="# SetJavaHome " (
            	set "foo=SetJavaHome %JAVA_HOME%"
            	set DONE_REPLACE=true
            )
            echo !foo!>>"%USER_CONF%"
        )
        :: if no line is replaced, append a new line with the JDK setting
        if "!DONE_REPLACE!"=="false" (
        	echo SetJavaHome %JAVA_HOME%>>"%USER_CONF%"
        )
    	del "%USER_DIR%\product.tmp"
	)
)

:: Build class path
set "CLASS_PATH=..\..\ide\lib\ide-boot.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\jlib\orai18n-collation.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\jlib\orai18n-mapping.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\jlib\orai18n.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\jlib\orai18n-utility.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\jlib\ojdbc8.jar;"
set "CLASS_PATH=%CLASS_PATH%..\lib\poi-3.15.jar;"
set "CLASS_PATH=%CLASS_PATH%..\lib\poi-ooxml-3.15.jar;"
set "CLASS_PATH=%CLASS_PATH%..\lib\poi-ooxml-schemas-3.15.jar;"
set "CLASS_PATH=%CLASS_PATH%..\lib\xmlbeans-2.6.0.jar;"
set "CLASS_PATH=%CLASS_PATH%..\extensions\oracle.duma.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\bootstrap.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\sleepycat\je-3.3.98\lib\je-3.3.98.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.xmlef\xmlef.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.help\ohj.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.help\oracle_ice.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.help\help-share.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.javatools\javamodel-rt.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.javatools\javatools-nodeps.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.xdk\oraclexsql.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.xdk\xsqlserializers.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.xdk\xmlparserv2.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.xdk\xml.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.xdk\xsu12.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.ldap\ojmisc.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.ldap\ldapjclnt11.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.bali.share\share.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\modules\oracle.xdb_11.1.0.jar;"
set "CLASS_PATH=%CLASS_PATH%..\..\jlib\*;"
set "CLASS_PATH=%CLASS_PATH%..\doc\dumac_help.jar;"
set "CLASS_PATH=%CLASS_PATH%..\lib\*;"
set "CLASS_PATH=%CLASS_PATH%..\..\ide\extensions\oracle.ide.jar"

:: Run application
"%JAVA_PATH%" -Duser.conf="%USER_CONF%" -Dide.conf="%WORKING_DIR%\dmu.conf" -Dide.startingcwd="%STARTING_CWD%" -Doracle.home=..\..\ -Dsun.java2d.ddoffscreen=false -Doracle.ide.util.AddinPolicyUtils.OVERRIDE_FLAG=true -Duser.language=en -Duser.country=US -Dduma.log.level=INFO %JVM_MIN_MEMORY% %JVM_MAX_MEMORY% -Xverify:none -classpath %CLASS_PATH% oracle.duma.cli.util.Launcher %*

set EXIT_CODE=%ERRORLEVEL%
cd %STARTING_CWD%
EXIT /B %EXIT_CODE%

:progInPath
set JAVA_PATH=%~$PATH:1
goto:eof

:checkProcessBitness
set BIT=64
if "%PROCESSOR_ARCHITECTURE%"=="x86" if not defined PROCESSOR_ARCHITEW6432 set BIT=32
goto:eof
