/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.floatformat;

import ghidra.pcode.floatformat.Floatclass;
import ghidra.pcode.floatformat.UnsupportedFloatFormatException;
import ghidra.pcode.utils.Utils;
import ghidra.util.SystemUtilities;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class FloatFormat {
    private static final int INFINITE_SCALE = -65536;
    public static final BigDecimal BIG_NaN = null;
    public static final BigDecimal BIG_POSITIVE_INFINITY = new BigDecimal(BigInteger.ONE, -65536);
    public static final BigDecimal BIG_NEGATIVE_INFINITY = new BigDecimal(BigInteger.ONE, -65536).negate();
    private static final BigInteger BIG_INT_TWO = BigInteger.valueOf(2L);
    private static final BigDecimal BIG_DEC_TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal BIG_DEC_THREE = BigDecimal.valueOf(3L);
    private int size;
    private int signbit_pos;
    private int frac_pos;
    private int frac_size;
    private int exp_pos;
    private int exp_size;
    private int bias;
    private int maxexponent;
    private boolean jbitimplied;
    public final BigDecimal maxValue;
    public final BigDecimal minValue;
    private final MathContext resultContext;

    public int getSize() {
        return this.size;
    }

    FloatFormat(int sz) throws UnsupportedFloatFormatException {
        this.size = sz;
        if (this.size == 2) {
            this.signbit_pos = 15;
            this.exp_pos = 10;
            this.exp_size = 5;
            this.frac_pos = 0;
            this.frac_size = 10;
            this.bias = 15;
            this.jbitimplied = true;
            this.resultContext = new MathContext(7, RoundingMode.UP);
        } else if (this.size == 4) {
            this.signbit_pos = 31;
            this.exp_pos = 23;
            this.exp_size = 8;
            this.frac_pos = 0;
            this.frac_size = 23;
            this.bias = 127;
            this.jbitimplied = true;
            this.resultContext = new MathContext(7, RoundingMode.UP);
        } else if (this.size == 8) {
            this.signbit_pos = 63;
            this.exp_pos = 52;
            this.exp_size = 11;
            this.frac_pos = 0;
            this.frac_size = 52;
            this.bias = 1023;
            this.jbitimplied = true;
            this.resultContext = new MathContext(16, RoundingMode.UP);
        } else if (this.size == 16) {
            this.signbit_pos = 127;
            this.exp_pos = 112;
            this.exp_size = 15;
            this.frac_pos = 0;
            this.frac_size = 112;
            this.bias = 16383;
            this.jbitimplied = true;
            this.resultContext = new MathContext(33, RoundingMode.UP);
        } else if (this.size == 10) {
            this.signbit_pos = 79;
            this.exp_pos = 64;
            this.exp_size = 15;
            this.frac_pos = 0;
            this.frac_size = 64;
            this.bias = 16383;
            this.jbitimplied = true;
            this.resultContext = new MathContext(18, RoundingMode.UP);
        } else if (this.size == 12) {
            this.signbit_pos = 95;
            this.exp_pos = 80;
            this.exp_size = 15;
            this.frac_pos = 16;
            this.frac_size = 64;
            this.bias = 16383;
            this.jbitimplied = true;
            this.resultContext = new MathContext(18, RoundingMode.UP);
        } else {
            throw new UnsupportedFloatFormatException(sz);
        }
        this.maxexponent = (1 << this.exp_size) - 1;
        this.maxValue = BIG_DEC_TWO.subtract(BIG_DEC_TWO.pow(-this.frac_size, this.resultContext)).multiply(BIG_DEC_TWO.pow(this.bias, this.resultContext));
        this.minValue = BIG_DEC_TWO.pow(-this.bias, this.resultContext);
    }

    static double createFloat(boolean sign, long mantissa, int exp) {
        long bits = mantissa >>> 11;
        bits = (exp += 1023) == 0 ? (bits >>= 1) : (bits &= 0xFFFFFFFFFFFFFL);
        bits |= (long)exp << 52;
        if (sign) {
            bits |= Long.MIN_VALUE;
        }
        return Double.longBitsToDouble(bits);
    }

    static BigDecimal createFloat(boolean sign, BigInteger mantissa, int exp) {
        StringBuilder buf = new StringBuilder();
        buf.append(sign ? "-" : "+");
        buf.append(mantissa.toString());
        buf.append('e');
        buf.append(exp);
        return new BigDecimal(buf.toString());
    }

    static FloatData extractExpSig(double x) {
        boolean sign;
        long bits = Double.doubleToRawLongBits(x);
        boolean bl = sign = bits >> 63 != 0L;
        if (x == 0.0) {
            return new FloatData(Floatclass.zero, sign, 0, 0L);
        }
        if (Double.isInfinite(x)) {
            return new FloatData(Floatclass.infinity, sign, 0, 0L);
        }
        if (Double.isNaN(x)) {
            return new FloatData(Floatclass.nan, sign, 0, 0L);
        }
        int exp = (int)(bits >> 52 & 0x7FFL);
        long mantissa = exp == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        return new FloatData(Floatclass.normalized, sign, exp -= 1023, mantissa <<= 11);
    }

    private long extractFractionalCode(long x) {
        x >>>= this.frac_pos;
        return x <<= 64 - this.frac_size;
    }

    private BigInteger extractFractionalCode(BigInteger x) {
        BigInteger mask = BigInteger.ONE.shiftLeft(this.frac_size).subtract(BigInteger.ONE);
        return x.shiftRight(this.frac_pos).and(mask);
    }

    private boolean extractSign(long x) {
        return ((x >>>= this.signbit_pos) & 1L) != 0L;
    }

    private boolean extractSign(BigInteger x) {
        return x.testBit(this.signbit_pos);
    }

    private int extractExponentCode(long x) {
        long mask = 1L;
        mask = (mask << this.exp_size) - 1L;
        return (int)((x >>>= this.exp_pos) & mask);
    }

    private int extractExponentCode(BigInteger x) {
        return x.shiftRight(this.exp_pos).intValue() & this.maxexponent;
    }

    private long setSign(long x, boolean sign) {
        if (!sign) {
            return x;
        }
        long mask = 1L;
        return x |= (mask <<= this.signbit_pos);
    }

    private BigInteger setSign(BigInteger x, boolean sign) {
        if (sign) {
            return x.setBit(this.signbit_pos);
        }
        return x;
    }

    private long getZeroEncoding(boolean sgn) {
        return this.setSign(0L, sgn);
    }

    private long getInfinityEncoding(boolean sgn) {
        long res = (long)this.maxexponent << this.exp_pos;
        return this.setSign(res, sgn);
    }

    private BigInteger getBigInfinityEncoding(boolean sgn) {
        BigInteger res = BigInteger.valueOf(this.maxexponent).shiftLeft(this.exp_pos);
        return this.setSign(res, sgn);
    }

    private long getNaNEncoding(boolean sgn) {
        long res = 1L << this.frac_pos + this.frac_size - 1;
        return this.setSign(res |= (long)this.maxexponent << this.exp_pos, sgn);
    }

    private BigInteger getBigNaNEncoding(boolean sgn) {
        BigInteger res = BigInteger.ONE.shiftLeft(this.frac_pos + this.frac_size - 1);
        res = res.or(BigInteger.valueOf(this.maxexponent).shiftLeft(this.exp_pos));
        return this.setSign(res, sgn);
    }

    public double getHostFloat(long encoding) {
        boolean sgn = this.extractSign(encoding);
        long frac = this.extractFractionalCode(encoding);
        int exp = this.extractExponentCode(encoding);
        boolean normal = true;
        if (exp == 0) {
            if (frac == 0L) {
                return sgn ? -0.0 : 0.0;
            }
            normal = false;
        } else if (exp == this.maxexponent) {
            if (frac == 0L) {
                return sgn ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }
        exp -= this.bias;
        if (normal && this.jbitimplied) {
            frac >>>= 1;
            frac |= Long.MIN_VALUE;
        }
        return FloatFormat.createFloat(sgn, frac, exp);
    }

    public BigDecimal getHostFloat(BigInteger encoding) {
        boolean sgn = this.extractSign(encoding);
        BigInteger frac = this.extractFractionalCode(encoding);
        int exp = this.extractExponentCode(encoding);
        if (exp == 0) {
            if (frac.signum() == 0) {
                return BigDecimal.ZERO;
            }
        } else if (exp == this.maxexponent) {
            if (frac.signum() == 0) {
                return sgn ? BIG_NEGATIVE_INFINITY : BIG_POSITIVE_INFINITY;
            }
            return BIG_NaN;
        }
        exp -= this.bias;
        if (this.jbitimplied) {
            frac = frac.shiftRight(1);
            frac = frac.setBit(this.frac_size - 1);
        }
        MathContext expandedContext = new MathContext(this.resultContext.getPrecision() * 3, this.resultContext.getRoundingMode());
        BigDecimal result = new BigDecimal(frac, expandedContext);
        result = result.multiply(BIG_DEC_TWO.pow(exp - this.frac_size + 1, expandedContext), this.resultContext);
        result = result.stripTrailingZeros();
        if (sgn) {
            result = result.negate();
        }
        return result;
    }

    public long getEncoding(double host) {
        FloatData data = FloatFormat.extractExpSig(host);
        if (data.type == Floatclass.zero) {
            return this.getZeroEncoding(data.sign);
        }
        if (data.type == Floatclass.infinity) {
            return this.getInfinityEncoding(data.sign);
        }
        if (data.type == Floatclass.nan) {
            return this.getNaNEncoding(data.sign);
        }
        int exp = data.exp;
        long signif = data.mantisa;
        if ((exp += this.bias) < 0) {
            return this.getZeroEncoding(data.sign);
        }
        if (exp > this.maxexponent) {
            return this.getInfinityEncoding(data.sign);
        }
        if (exp != 0 && this.jbitimplied) {
            signif <<= 1;
        }
        long res = signif >>> 64 - this.frac_size << this.frac_pos;
        return this.setSign(res |= (long)exp << this.exp_pos, data.sign);
    }

    public BigInteger getEncoding(BigDecimal value) {
        BigDecimal valueFloor;
        BigInteger floor;
        if (value == BIG_NaN) {
            return this.getBigNaNEncoding(false);
        }
        boolean neg = false;
        if (value.signum() < 0) {
            neg = true;
            value = value.negate();
        }
        if (value.compareTo(this.maxValue) >= 0) {
            return this.getBigInfinityEncoding(neg);
        }
        if (value.compareTo(this.minValue) <= 0) {
            return BigInteger.ZERO;
        }
        BigInteger integer = value.toBigInteger();
        BigInteger fraction = BigInteger.ZERO;
        int exp = this.bias;
        if ((value = value.subtract(new BigDecimal(integer))).signum() != 0) {
            for (int i = this.frac_size - 1; i >= 0; --i) {
                value = value.add(value);
                floor = value.toBigInteger();
                valueFloor = new BigDecimal(floor);
                fraction = fraction.add(floor.multiply(BIG_INT_TWO.pow(i)));
                value = value.subtract(valueFloor);
            }
        }
        BigInteger fracMask1 = BigInteger.ONE.shiftLeft(this.frac_size - 1).subtract(BigInteger.ONE);
        while (!integer.equals(BigInteger.ONE) && exp > 0 && exp < this.maxexponent) {
            if (!integer.equals(BigInteger.ZERO)) {
                fraction = fraction.shiftRight(1);
                if (integer.testBit(0)) {
                    fraction = fraction.add(BigInteger.ZERO.setBit(this.frac_size - 1));
                }
                integer = integer.shiftRight(1);
                ++exp;
                continue;
            }
            integer = fraction.testBit(this.frac_size - 1) ? BigInteger.ONE : BigInteger.ZERO;
            fraction = fraction.and(fracMask1).shiftLeft(1);
            value = value.add(value);
            floor = value.toBigInteger();
            valueFloor = new BigDecimal(floor);
            fraction = fraction.add(floor);
            value = value.subtract(valueFloor);
            --exp;
        }
        if (this.frac_pos != 0) {
            fraction = fraction.shiftLeft(this.frac_pos);
        }
        BigInteger result = BigInteger.valueOf(exp).shiftLeft(this.exp_pos).or(fraction);
        if (neg) {
            result = result.setBit(this.signbit_pos);
        }
        return result;
    }

    public long opEqual(long a, long b) {
        double val2;
        double val1 = this.getHostFloat(a);
        long res = val1 == (val2 = this.getHostFloat(b)) ? 1L : 0L;
        return res;
    }

    public BigInteger opEqual(BigInteger a, BigInteger b) {
        BigDecimal val1 = this.getHostFloat(a);
        BigDecimal val2 = this.getHostFloat(b);
        if (val1 == BIG_NaN || val2 == BIG_NaN) {
            return BigInteger.ZERO;
        }
        BigInteger res = SystemUtilities.isEqual((Object)val1, (Object)val2) ? BigInteger.ONE : BigInteger.ZERO;
        return res;
    }

    public long opNotEqual(long a, long b) {
        double val2;
        double val1 = this.getHostFloat(a);
        long res = val1 != (val2 = this.getHostFloat(b)) ? 1L : 0L;
        return res;
    }

    public BigInteger opNotEqual(BigInteger a, BigInteger b) {
        BigDecimal val1 = this.getHostFloat(a);
        BigDecimal val2 = this.getHostFloat(b);
        if (val1 == BIG_NaN || val2 == BIG_NaN) {
            return BigInteger.ONE;
        }
        BigInteger res = SystemUtilities.isEqual((Object)val1, (Object)val2) ? BigInteger.ZERO : BigInteger.ONE;
        return res;
    }

    public long opLess(long a, long b) {
        double val2;
        double val1 = this.getHostFloat(a);
        long res = val1 < (val2 = this.getHostFloat(b)) ? 1L : 0L;
        return res;
    }

    public BigInteger opLess(BigInteger a, BigInteger b) {
        BigDecimal val1 = this.getHostFloat(a);
        BigDecimal val2 = this.getHostFloat(b);
        if (val1 == BIG_NaN || val2 == BIG_NaN) {
            return BigInteger.ZERO;
        }
        BigInteger res = val1.compareTo(val2) < 0 ? BigInteger.ONE : BigInteger.ZERO;
        return res;
    }

    public long opLessEqual(long a, long b) {
        double val2;
        double val1 = this.getHostFloat(a);
        long res = val1 <= (val2 = this.getHostFloat(b)) ? 1L : 0L;
        return res;
    }

    public BigInteger opLessEqual(BigInteger a, BigInteger b) {
        BigDecimal val1 = this.getHostFloat(a);
        BigDecimal val2 = this.getHostFloat(b);
        if (val1 == BIG_NaN || val2 == BIG_NaN) {
            return BigInteger.ZERO;
        }
        BigInteger res = val1.compareTo(val2) <= 0 ? BigInteger.ONE : BigInteger.ZERO;
        return res;
    }

    public long opNan(long a) {
        double val = this.getHostFloat(a);
        long res = Double.isNaN(val) ? 1L : 0L;
        return res;
    }

    public BigInteger opNan(BigInteger a) {
        BigDecimal val = this.getHostFloat(a);
        BigInteger res = val == BIG_NaN ? BigInteger.ONE : BigInteger.ZERO;
        return res;
    }

    public long opAdd(long a, long b) {
        double val1 = this.getHostFloat(a);
        double val2 = this.getHostFloat(b);
        return this.getEncoding(val1 + val2);
    }

    public BigInteger opAdd(BigInteger a, BigInteger b) {
        BigDecimal val1 = this.getHostFloat(a);
        BigDecimal val2 = this.getHostFloat(b);
        if (val1 == BIG_NaN || val2 == BIG_NaN) {
            return this.getBigNaNEncoding(false);
        }
        if (val1 == BIG_POSITIVE_INFINITY) {
            if (val2 == BIG_NEGATIVE_INFINITY) {
                return this.getBigNaNEncoding(false);
            }
            return a;
        }
        if (val1 == BIG_NEGATIVE_INFINITY) {
            if (val2 == BIG_POSITIVE_INFINITY) {
                return this.getBigNaNEncoding(false);
            }
            return a;
        }
        return this.getEncoding(val1.add(val2, this.resultContext));
    }

    public long opSub(long a, long b) {
        double val1 = this.getHostFloat(a);
        double val2 = this.getHostFloat(b);
        return this.getEncoding(val1 - val2);
    }

    public BigInteger opSub(BigInteger a, BigInteger b) {
        BigDecimal val1 = this.getHostFloat(a);
        BigDecimal val2 = this.getHostFloat(b);
        if (val1 == BIG_NaN || val2 == BIG_NaN) {
            return this.getBigNaNEncoding(false);
        }
        if (val1 == BIG_POSITIVE_INFINITY) {
            if (val2 == BIG_POSITIVE_INFINITY) {
                return this.getBigNaNEncoding(false);
            }
            return a;
        }
        if (val1 == BIG_NEGATIVE_INFINITY) {
            if (val2 == BIG_NEGATIVE_INFINITY) {
                return this.getBigNaNEncoding(false);
            }
            return a;
        }
        return this.getEncoding(val1.subtract(val2, this.resultContext));
    }

    public long opDiv(long a, long b) {
        double val1 = this.getHostFloat(a);
        double val2 = this.getHostFloat(b);
        return this.getEncoding(val1 / val2);
    }

    public BigInteger opDiv(BigInteger a, BigInteger b) {
        BigDecimal val1 = this.getHostFloat(a);
        BigDecimal val2 = this.getHostFloat(b);
        if (val1 == BIG_NaN || val2 == BIG_NaN) {
            return this.getBigNaNEncoding(false);
        }
        if (val2.signum() == 0) {
            if (val1.signum() == 0) {
                return this.getBigNaNEncoding(false);
            }
            return this.getBigInfinityEncoding(val1.signum() < 0);
        }
        return this.getEncoding(val1.divide(val2, this.resultContext));
    }

    public long opMult(long a, long b) {
        double val1 = this.getHostFloat(a);
        double val2 = this.getHostFloat(b);
        return this.getEncoding(val1 * val2);
    }

    public BigInteger opMult(BigInteger a, BigInteger b) {
        BigDecimal val1 = this.getHostFloat(a);
        BigDecimal val2 = this.getHostFloat(b);
        if (val1 == BIG_NaN || val2 == BIG_NaN) {
            return this.getBigNaNEncoding(false);
        }
        return this.getEncoding(val1.multiply(val2, this.resultContext));
    }

    public long opNeg(long a) {
        double val = this.getHostFloat(a);
        return this.getEncoding(-val);
    }

    public BigInteger opNeg(BigInteger a) {
        BigDecimal val = this.getHostFloat(a);
        if (val == BIG_NaN) {
            return a;
        }
        return this.getEncoding(val.negate());
    }

    public long opAbs(long a) {
        double val = this.getHostFloat(a);
        return this.getEncoding(Math.abs(val));
    }

    public BigInteger opAbs(BigInteger a) {
        BigDecimal val = this.getHostFloat(a);
        if (val == BIG_NaN) {
            return a;
        }
        return this.getEncoding(val.abs());
    }

    public long opSqrt(long a) {
        double val = this.getHostFloat(a);
        return this.getEncoding(Math.sqrt(val));
    }

    public BigInteger opSqrt(BigInteger a) {
        BigDecimal val = this.getHostFloat(a);
        if (val == BIG_NaN) {
            return a;
        }
        int signum = val.signum();
        if (signum < 0) {
            return this.getBigNaNEncoding(false);
        }
        if (signum == 0) {
            return BigInteger.ZERO;
        }
        int scale = this.resultContext.getPrecision() * 2;
        BigDecimal result = val.divide(BIG_DEC_THREE, scale, 6);
        BigDecimal lastResult = BigDecimal.ZERO;
        for (int i = 0; i < 50 && (result = val.add(result.multiply(result)).divide(result.multiply(BIG_DEC_TWO), scale, 6)).compareTo(lastResult) != 0; ++i) {
            lastResult = result;
        }
        return this.getEncoding(result);
    }

    public long opInt2Float(long a, int sizein) {
        long ival = a;
        ival = Utils.zzz_sign_extend(ival, 8 * sizein - 1);
        double val = ival;
        return this.getEncoding(val);
    }

    public BigInteger opInt2Float(BigInteger a, int sizein, boolean signed) {
        a = signed ? Utils.convertToSignedValue(a, sizein) : Utils.convertToUnsignedValue(a, sizein);
        BigDecimal val = new BigDecimal(a);
        return this.getEncoding(val);
    }

    public long opFloat2Float(long a, FloatFormat outformat) {
        double val = this.getHostFloat(a);
        return outformat.getEncoding(val);
    }

    public BigInteger opFloat2Float(BigInteger a, FloatFormat outformat) {
        BigDecimal val = this.getHostFloat(a);
        if (val == BIG_NaN) {
            return outformat.getBigNaNEncoding(false);
        }
        return outformat.getEncoding(val);
    }

    public long opTrunc(long a, int sizeout) {
        double val = this.getHostFloat(a);
        long res = (long)val;
        return res &= Utils.calc_mask(sizeout);
    }

    public BigInteger opTrunc(BigInteger a, int sizeout) {
        BigDecimal val = this.getHostFloat(a);
        if (val == BIG_NaN) {
            return BigInteger.ZERO;
        }
        if (val == BIG_POSITIVE_INFINITY) {
            return BigInteger.ONE.shiftLeft(8 * this.size).subtract(BigInteger.ONE).shiftRight(1);
        }
        if (val == BIG_NEGATIVE_INFINITY) {
            return BigInteger.ONE.shiftLeft(8 * this.size - 1).negate();
        }
        BigInteger res = val.toBigInteger();
        return res;
    }

    public long opCeil(long a) {
        double val = this.getHostFloat(a);
        return this.getEncoding(Math.ceil(val));
    }

    public BigInteger opCeil(BigInteger a) {
        BigDecimal val = this.getHostFloat(a);
        if (val == BIG_NaN) {
            return a;
        }
        BigInteger intval = val.toBigInteger();
        if (intval.signum() > 0 && !val.unscaledValue().equals(intval)) {
            intval = intval.add(BigInteger.ONE);
        }
        return this.getEncoding(new BigDecimal(intval));
    }

    public long opFloor(long a) {
        double val = this.getHostFloat(a);
        return this.getEncoding(Math.floor(val));
    }

    private BigInteger floor(BigDecimal val) {
        if (val.signum() < 0) {
            try {
                return val.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                return val.toBigInteger().subtract(BigInteger.ONE);
            }
        }
        return val.toBigInteger();
    }

    public BigInteger opFloor(BigInteger a) {
        BigDecimal val = this.getHostFloat(a);
        if (val == BIG_NaN) {
            return a;
        }
        BigInteger intval = this.floor(val);
        return this.getEncoding(new BigDecimal(intval));
    }

    public long opRound(long a) {
        double val = this.getHostFloat(a);
        return this.getEncoding(Math.floor(val + 0.5));
    }

    public BigInteger opRound(BigInteger a) {
        BigDecimal val = this.getHostFloat(a);
        if (val == BIG_NaN) {
            return a;
        }
        BigInteger intval = this.floor(val.add(BigDecimal.valueOf(0.5), this.resultContext));
        return this.getEncoding(new BigDecimal(intval));
    }

    static class FloatData {
        final Floatclass type;
        final boolean sign;
        final int exp;
        final long mantisa;

        public FloatData(Floatclass type, boolean sign, int exp, long mantisa) {
            this.type = type;
            this.sign = sign;
            this.exp = exp;
            this.mantisa = mantisa;
        }
    }
}

