/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Union;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;
import java.util.ArrayList;

public class UnionDataType
extends CompositeDataTypeImpl
implements Union {
    private ArrayList<DataTypeComponent> components = new ArrayList();
    private int unionLength;

    public UnionDataType(CategoryPath path, String name) {
        this(path, name, null);
    }

    public UnionDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    public UnionDataType(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
    }

    public UnionDataType(String name) {
        this(CategoryPath.ROOT, name);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Union>";
        }
        return "";
    }

    @Override
    public boolean isNotYetDefined() {
        return this.components.size() == 0;
    }

    @Override
    public DataTypeComponent getComponent(int ordinal) {
        return this.components.get(ordinal);
    }

    @Override
    public DataTypeComponent[] getComponents() {
        return this.components.toArray(new DataTypeComponent[this.components.size()]);
    }

    @Override
    public int getNumComponents() {
        return this.components.size();
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String componentName, String comment) {
        int oldLength = this.unionLength;
        DataTypeComponent dtc = this.doAdd(dataType, length, componentName, comment);
        this.adjustInternalAlignment();
        if (oldLength != this.unionLength) {
            this.notifySizeChanged();
        }
        return dtc;
    }

    DataTypeComponent doAdd(DataType dataType, int length, String componentName, String comment) {
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        if (length < 1) {
            throw new IllegalArgumentException("Length must be >= 1!");
        }
        int dtLength = (dataType = dataType.clone(this.getDataTypeManager())).getLength();
        if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, this.components.size(), 0, componentName, comment);
        dataType.addParent(this);
        this.components.add(dtc);
        this.unionLength = Math.max(this.unionLength, length);
        return dtc;
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String componentName, String comment) {
        this.validateDataType(dataType);
        this.checkAncestry(dataType);
        dataType = dataType.clone(this.getDataTypeManager());
        int dtLength = dataType.getLength();
        if (dtLength > 0 && dtLength < length) {
            length = dtLength;
        }
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, ordinal, 0, componentName, comment);
        dataType.addParent(this);
        this.shiftOrdinals(ordinal, 1);
        this.components.add(ordinal, dtc);
        int oldLength = this.unionLength;
        this.unionLength = Math.max(this.unionLength, length);
        this.adjustInternalAlignment();
        if (oldLength != this.unionLength) {
            this.notifySizeChanged();
        }
        return dtc;
    }

    @Override
    public int getLength() {
        if (this.unionLength == 0) {
            return 1;
        }
        return this.unionLength;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.getDataTypeManager() == dtm) {
            return this;
        }
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public void delete(int ordinal) {
        int oldLength = this.unionLength;
        DataTypeComponent dtc = this.components.remove(ordinal);
        dtc.getDataType().removeParent(this);
        this.shiftOrdinals(ordinal, -1);
        this.computeUnionLength();
        this.adjustInternalAlignment();
        if (oldLength != this.unionLength) {
            this.notifySizeChanged();
        }
    }

    @Override
    public void delete(int[] ordinals) {
        for (int ordinal : ordinals) {
            this.delete(ordinal);
        }
    }

    private void computeUnionLength() {
        this.unionLength = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            this.unionLength = Math.max(this.unionLength, this.components.get(i).getLength());
        }
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null) {
            return false;
        }
        if (dt instanceof Union) {
            DataTypeComponent[] otherComps;
            Union union = (Union)dt;
            if (this.isInternallyAligned() != union.isInternallyAligned() || this.isDefaultAligned() != union.isDefaultAligned() || this.isMachineAligned() != union.isMachineAligned() || this.getMinimumAlignment() != union.getMinimumAlignment() || this.getPackingValue() != union.getPackingValue()) {
                return false;
            }
            DataTypeComponent[] myComps = this.getComponents();
            if (myComps.length != (otherComps = union.getComponents()).length) {
                return false;
            }
            for (int i = 0; i < myComps.length; ++i) {
                if (myComps[i].isEquivalent(otherComps[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void shiftOrdinals(int ordinal, int deltaOrdinal) {
        for (int i = ordinal; i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = (DataTypeComponentImpl)this.components.get(i);
            dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal);
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.adjustInternalAlignment();
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        int oldLength = this.unionLength;
        this.unionLength = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = (DataTypeComponentImpl)this.components.get(i);
            DataType tmpDt = dtc.getDataType();
            int tmpLen = tmpDt.getLength();
            if (tmpDt.isEquivalent(dt) && tmpLen > 0 && tmpLen != dtc.getLength()) {
                dtc.setLength(tmpLen);
            }
            this.unionLength = Math.max(this.unionLength, dtc.getLength());
        }
        this.adjustInternalAlignment();
        if (oldLength != this.unionLength) {
            this.notifySizeChanged();
        }
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        try {
            this.validateDataType(newDt);
            this.checkAncestry(newDt);
        }
        catch (Exception e) {
            newDt = DataType.DEFAULT;
        }
        int oldLength = this.unionLength;
        this.unionLength = 0;
        boolean changed = false;
        for (int i = 0; i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = (DataTypeComponentImpl)this.components.get(i);
            if (dtc.getDataType() != oldDt) continue;
            oldDt.removeParent(this);
            dtc.setDataType(newDt);
            newDt.addParent(this);
            int len = newDt.getLength();
            if (len > 0) {
                dtc.setLength(len);
            }
            changed = true;
        }
        if (changed) {
            this.computeUnionLength();
            this.adjustInternalAlignment();
            if (oldLength != this.unionLength) {
                this.notifySizeChanged();
            }
        }
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        boolean didDelete = false;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            DataTypeComponent dtc = this.components.get(i);
            if (dtc.getDataType() != dt) continue;
            dt.removeParent(this);
            this.components.remove(i);
            this.shiftOrdinals(i, -1);
            didDelete = true;
        }
        if (didDelete) {
            int oldLength = this.unionLength;
            this.computeUnionLength();
            this.adjustInternalAlignment();
            if (oldLength != this.unionLength) {
                this.notifySizeChanged();
            }
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Union)) {
            throw new IllegalArgumentException();
        }
        int oldLength = this.unionLength;
        this.doReplaceWith((Union)dataType);
        if (oldLength != this.unionLength) {
            this.notifySizeChanged();
        }
    }

    private void doReplaceWith(Union union) {
        for (DataTypeComponent dtc : this.components) {
            dtc.getDataType().removeParent(this);
        }
        this.components.clear();
        this.unionLength = 0;
        DataTypeComponent[] compArray = union.getComponents();
        for (int i = 0; i < compArray.length; ++i) {
            DataTypeComponent dtc = compArray[i];
            DataType dt = dtc.getDataType();
            this.validateDataType(dt);
            dt = dt.clone(this.getDataTypeManager());
            int dtLength = dt.getLength();
            if (dtLength <= 0) {
                dtLength = dtc.getLength();
            }
            this.doAdd(dt, dtLength, dtc.getFieldName(), dtc.getComment());
        }
        this.setDataAlignmentInfo(union);
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        if (this.getNumComponents() == 1) {
            DataTypeComponent dtc = this.getComponent(0);
            return dtc.getDataType().dependsOn(dt);
        }
        return false;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "UNION_" + this.getName();
    }

    public void align(DataOrganization dataOrganization) {
    }

    private void adjustLength() {
    }

    @Override
    public int getPackingValue() {
        return this.packingValue;
    }

    @Override
    public void setPackingValue(int packingValue) {
        this.packingValue = packingValue;
        this.adjustInternalAlignment();
    }

    @Override
    public void adjustInternalAlignment() {
        this.adjustLength();
    }

    @Override
    public void realign() {
        this.adjustInternalAlignment();
    }
}

