/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin;

import ghidra.app.cmd.data.CreateTypeDescriptorBackgroundCmd;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.CreateRtti4BackgroundCmd;
import ghidra.app.cmd.data.rtti.Rtti4Model;
import ghidra.app.plugin.prototype.MicrosoftCodeAnalyzerPlugin.PEUtil;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.app.util.datatype.microsoft.MSDataTypeUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.lang.UndefinedValueException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramMemoryUtil;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class RttiAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Windows x86 PE RTTI Analyzer";
    private static final String DESCRIPTION = "This analyzer finds and creates all of the RTTI metadata structures and their associated vf tables.";
    private static final String CLASS_PREFIX_CHARS = ".?A";
    public static final String TYPE_INFO_STRING = ".?AVtype_info@@";
    private DataValidationOptions validationOptions;
    private DataApplyOptions applyOptions;

    public RttiAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setSupportsOneTimeAnalysis();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before().before());
        this.setDefaultEnablement(true);
        this.validationOptions = new DataValidationOptions();
        this.applyOptions = new DataApplyOptions();
    }

    public boolean canAnalyze(Program program) {
        return PEUtil.canAnalyze(program);
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        List dataBlocks = ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)set, (String)".data", (TaskMonitor)monitor);
        List typeInfoAddresses = ProgramMemoryUtil.findString((String)TYPE_INFO_STRING, (Program)program, (List)dataBlocks, (AddressSetView)set, (TaskMonitor)monitor);
        int typeInfoCount = typeInfoAddresses.size();
        if (typeInfoCount != 1) {
            if (typeInfoCount == 0) {
                log.appendMsg(this.getName(), "Couldn't find type info structure.");
                return true;
            }
            log.appendMsg(this.getName(), "Found " + typeInfoCount + " type info structures when expecting only 1.");
            return false;
        }
        Address typeInfoStringAddress = (Address)typeInfoAddresses.get(0);
        Address typeInfoRtti0Address = TypeDescriptorModel.getBaseAddress(program, typeInfoStringAddress);
        if (typeInfoRtti0Address == null) {
            log.appendMsg(this.getName(), "Couldn't find RTTI type info structure.");
            return true;
        }
        TypeDescriptorModel typeDescriptorModel = new TypeDescriptorModel(program, typeInfoRtti0Address, this.validationOptions);
        try {
            Address commonVfTableAddress = typeDescriptorModel.getVFTableAddress();
            if (commonVfTableAddress == null) {
                log.appendMsg(this.getName(), "Couldn't get vf table address for RTTI 0 @ " + typeInfoRtti0Address + ". ");
                return false;
            }
            int alignment = program.getDefaultPointerSize();
            Set possibleTypeAddresses = ProgramMemoryUtil.findDirectReferences((Program)program, (List)dataBlocks, (int)alignment, (Address)commonVfTableAddress, (TaskMonitor)monitor);
            this.processRtti0(possibleTypeAddresses, program, monitor);
            return true;
        }
        catch (InvalidDataTypeException | UndefinedValueException e) {
            log.appendMsg(this.getName(), "Couldn't get vf table address for RTTI 0 @ " + typeInfoRtti0Address + ". " + e.getMessage());
            return false;
        }
    }

    private void processRtti0(Collection<Address> possibleRtti0Addresses, Program program, TaskMonitor monitor) throws CancelledException {
        monitor.setMaximum((long)possibleRtti0Addresses.size());
        monitor.setMessage("Creating RTTI Data...");
        int count = 0;
        for (Address rtti0Address : possibleRtti0Addresses) {
            monitor.checkCanceled();
            monitor.setProgress((long)count++);
            TypeDescriptorModel typeModel = new TypeDescriptorModel(program, rtti0Address, this.validationOptions);
            try {
                String typeName = typeModel.getTypeName();
                if (typeName == null) continue;
                if (!typeName.startsWith(CLASS_PREFIX_CHARS)) {
                }
            }
            catch (InvalidDataTypeException e) {}
            continue;
            CreateTypeDescriptorBackgroundCmd typeDescCmd = new CreateTypeDescriptorBackgroundCmd(rtti0Address, this.validationOptions, this.applyOptions);
            typeDescCmd.applyTo((DomainObject)program, monitor);
            this.processRtti4sForRtti0(program, rtti0Address, monitor);
        }
    }

    private void processRtti4sForRtti0(Program program, Address rtti0Address, TaskMonitor monitor) throws CancelledException {
        List rDataBlocks = ProgramMemoryUtil.getMemoryBlocksStartingWithName((Program)program, (AddressSetView)program.getMemory(), (String)".rdata", (TaskMonitor)monitor);
        List<Address> rtti4Addresses = RttiAnalyzer.getRtti4Addresses(program, rDataBlocks, rtti0Address, this.validationOptions, monitor);
        for (Address rtti4Address : rtti4Addresses) {
            monitor.checkCanceled();
            CreateRtti4BackgroundCmd cmd = new CreateRtti4BackgroundCmd(rtti4Address, rDataBlocks, this.validationOptions, this.applyOptions);
            cmd.applyTo((DomainObject)program, monitor);
        }
    }

    private static List<Address> getRtti4Addresses(Program program, List<MemoryBlock> rtti4Blocks, Address rtti0Address, DataValidationOptions validationOptions, TaskMonitor monitor) throws CancelledException {
        monitor.checkCanceled();
        ArrayList<Address> addresses = new ArrayList<Address>();
        int rtti0PointerOffset = Rtti4Model.getRtti0PointerComponentOffset();
        Set<Address> refsToRtti0 = RttiAnalyzer.getRefsToRtti0(program, rtti4Blocks, rtti0Address);
        for (Address refAddress : refsToRtti0) {
            Address possibleRtti4Address;
            monitor.checkCanceled();
            try {
                possibleRtti4Address = refAddress.subtractNoWrap((long)rtti0PointerOffset);
            }
            catch (AddressOverflowException e) {
                continue;
            }
            Rtti4Model rtti4Model = new Rtti4Model(program, possibleRtti4Address, validationOptions);
            try {
                rtti4Model.validate();
            }
            catch (InvalidDataTypeException e) {
                continue;
            }
            boolean refersToRtti0 = rtti4Model.refersToRtti0(rtti0Address);
            if (!refersToRtti0) continue;
            addresses.add(possibleRtti4Address);
        }
        return addresses;
    }

    private static Set<Address> getRefsToRtti0(Program program, List<MemoryBlock> dataBlocks, Address rtti0Address) throws CancelledException {
        Set refsToRtti0 = MSDataTypeUtils.is64Bit((Program)program) ? ProgramMemoryUtil.findImageBaseOffsets32((Program)program, (int)4, (Address)rtti0Address, (TaskMonitor)TaskMonitor.DUMMY) : ProgramMemoryUtil.findDirectReferences((Program)program, dataBlocks, (int)program.getDefaultPointerSize(), (Address)rtti0Address, (TaskMonitor)TaskMonitor.DUMMY);
        return refsToRtti0;
    }
}

