/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.util.StringIndex;

public class HashMapIndex
implements StringIndex {
    private final HashMap stringToIndex = new HashMap();
    private final HashMap indexToString = new HashMap();
    private final Properties stringToIndexProps = new Properties();
    private FileSystemResource file;
    private long lastModified = -1L;

    public HashMapIndex(FileSystemResource file) throws FileSystemException, IOException {
        this.file = file;
        if (!file.exists()) {
            file.makeParentDirs();
            file.getOutputStream().close();
        }
        this.load();
    }

    private void load() throws IOException, FileSystemException {
        long modTime = this.file.lastModified();
        if (modTime > this.lastModified) {
            InputStream in = this.file.getInputStream();
            this.stringToIndexProps.clear();
            this.stringToIndexProps.load(in);
            Iterator<Object> iter = this.stringToIndexProps.keySet().iterator();
            while (iter.hasNext()) {
                String uri = (String)iter.next();
                String prop = this.stringToIndexProps.getProperty(uri);
                Integer idx = new Integer(prop);
                this.stringToIndex.put(uri, idx);
                this.indexToString.put(idx, uri);
            }
            in.close();
        }
        this.lastModified = modTime;
    }

    private void save() throws IOException, FileSystemException {
        OutputStream out = this.file.getOutputStream();
        this.stringToIndexProps.store(out, "string index");
        out.close();
        this.lastModified = this.file.lastModified();
    }

    public int stringToIndex(String nsUri) {
        Integer idx = (Integer)this.stringToIndex.get(nsUri);
        if (idx == null) {
            try {
                this.load();
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Unable to load lookup table for uri: " + nsUri);
                ise.initCause(e);
                throw ise;
            }
            idx = (Integer)this.stringToIndex.get(nsUri);
        }
        if (idx == null) {
            idx = new Integer(this.indexToString.size());
            this.stringToIndex.put(nsUri, idx);
            this.indexToString.put(idx, nsUri);
            this.stringToIndexProps.put(nsUri, idx.toString());
            try {
                this.save();
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Unable to store lookup table for uri: " + nsUri);
                ise.initCause(e);
                throw ise;
            }
        }
        return idx;
    }

    public String indexToString(int i) {
        Integer idx = new Integer(i);
        String s = (String)this.indexToString.get(idx);
        if (s == null) {
            try {
                this.load();
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Unable to load lookup table for index: " + i);
                ise.initCause(e);
                throw ise;
            }
            s = (String)this.indexToString.get(idx);
        }
        return s;
    }
}

