/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import org.apache.jackrabbit.commons.repository.RepositoryFactory;
import org.apache.jackrabbit.servlet.ContextRepositoryFactory;

public class CrossContextRepositoryFactory
implements RepositoryFactory {
    private final ServletContext context;
    private final String path;
    private final String name;

    public CrossContextRepositoryFactory(ServletContext context, String path, String name) {
        this.context = context;
        this.path = path;
        this.name = name;
    }

    public Repository getRepository() throws RepositoryException {
        ServletContext context = this.context.getContext(this.path);
        if (context == null) {
            throw new RepositoryException("Repository not found: Servlet context " + this.path + " does not exist or is not accessible from context " + this.context.getServletContextName());
        }
        return new ContextRepositoryFactory(context, this.name).getRepository();
    }
}

