/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.app.cmd.module.AbstractModularizationCmd;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.graph.CodeBlockEdge;
import ghidra.program.model.block.graph.CodeBlockVertex;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.GroupPath;
import ghidra.program.util.ProgramSelection;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Set;

public class DominanceModularizationCmd
extends AbstractModularizationCmd {
    public DominanceModularizationCmd(GroupPath path, String treeName, ProgramSelection selection, CodeBlockModel blockModel) {
        super("Dominance", path, treeName, selection, blockModel);
    }

    @Override
    protected void applyModel() throws CancelledException {
        GDirectedGraph<CodeBlockVertex, CodeBlockEdge> callGraph = this.createCallGraph();
        CodeBlockVertex root = this.createRoot(callGraph, "Dominance");
        GDirectedGraph dominanceGraph = GraphAlgorithms.findDominanceTree(callGraph, (TaskMonitor)this.monitor);
        this.rebuildProgramTree((GDirectedGraph<CodeBlockVertex, GEdge<CodeBlockVertex>>)dominanceGraph, root, this.destinationModule);
    }

    private CodeBlockVertex createRoot(GDirectedGraph<CodeBlockVertex, CodeBlockEdge> graph, String name) {
        Set entryPoints = GraphAlgorithms.getEntryPoints(graph);
        if (entryPoints.size() == 1) {
            return (CodeBlockVertex)entryPoints.iterator().next();
        }
        CodeBlockVertex nexus = new CodeBlockVertex(name);
        graph.addVertex((Object)nexus);
        for (CodeBlockVertex entry : entryPoints) {
            CodeBlockEdge e = new CodeBlockEdge(nexus, entry);
            graph.addEdge((GEdge)e);
        }
        return nexus;
    }

    private void rebuildProgramTree(GDirectedGraph<CodeBlockVertex, GEdge<CodeBlockVertex>> dg, CodeBlockVertex vertex, ProgramModule module) throws CancelledException {
        Collection children = dg.getSuccessors((Object)vertex);
        if (children == null || children.isEmpty()) {
            this.makeFragment(this.program, module, vertex);
            return;
        }
        ProgramModule currentModule = this.createModule(module, vertex.getName());
        this.makeFragment(this.program, currentModule, vertex);
        for (CodeBlockVertex child : children) {
            this.monitor.checkCanceled();
            this.rebuildProgramTree(dg, child, currentModule);
        }
    }
}

