/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;

public class AssociateSymbolCmd
implements Command {
    private Reference ref;
    private String symbolName;
    private Namespace scope;
    private SymbolTable symTable;
    private String msg = "";

    public AssociateSymbolCmd(Reference ref, Namespace scope) {
        this.ref = ref;
        this.scope = scope;
        this.symbolName = scope.getSymbol().getName();
    }

    public AssociateSymbolCmd(Reference ref, String symbolName, Namespace scope) {
        this.ref = ref;
        this.symbolName = symbolName;
        this.scope = scope;
    }

    public AssociateSymbolCmd(Reference ref, String symbolName) {
        this(ref, symbolName, null);
    }

    public boolean applyTo(DomainObject obj) {
        this.symTable = ((Program)obj).getSymbolTable();
        ReferenceManager refMgr = ((Program)obj).getReferenceManager();
        Symbol s = this.symTable.getSymbol(this.symbolName, this.ref.getToAddress(), this.scope);
        if (s == null) {
            this.msg = "No symbol found for " + this.symbolName;
            return false;
        }
        refMgr.setAssociation(s, this.ref);
        return true;
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return "Set Symbol Reference Association";
    }
}

