/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ComponentProvider;
import ghidra.app.plugin.core.functioncompare.FunctionChoiceComparisonPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import java.util.Arrays;

public class MultiFunctionComparisonPanel
extends FunctionChoiceComparisonPanel {
    public MultiFunctionComparisonPanel(ComponentProvider provider, PluginTool tool, Function[] functions) {
        super(provider, tool, null, null);
        Function[] sortedFunctions = this.getSortedFunctions(functions);
        this.leftWrappedFunctions = this.getWrappedFunctions(sortedFunctions);
        this.rightWrappedFunctions = this.leftWrappedFunctions;
        if (this.leftWrappedFunctions.length >= 2) {
            Function leftFunction = this.leftIndex < this.leftWrappedFunctions.length ? this.leftWrappedFunctions[this.leftIndex].getFunction() : null;
            ++this.rightIndex;
            Function rightFunction = this.rightIndex < this.rightWrappedFunctions.length ? this.rightWrappedFunctions[this.rightIndex].getFunction() : null;
            this.loadFunctions(leftFunction, rightFunction);
        }
        if (this.leftWrappedFunctions.length > 2) {
            this.addChoicePanel();
        }
        this.createActions();
        help.registerHelp((Object)this, new HelpLocation("FunctionComparison", "Function Comparison"));
    }

    public MultiFunctionComparisonPanel(ComponentProvider provider, PluginTool tool, Function[] leftFunctions, Function[] rightFunctions) {
        super(provider, tool, null, null);
        Object[] sortedLeftFunctions = this.getSortedFunctions(leftFunctions);
        Object[] sortedRightFunctions = this.getSortedFunctions(rightFunctions);
        this.leftWrappedFunctions = this.getWrappedFunctions((Function[])sortedLeftFunctions);
        FunctionChoiceComparisonPanel.WrappedFunction[] wrappedFunctionArray = this.rightWrappedFunctions = Arrays.equals(sortedLeftFunctions, sortedRightFunctions) ? this.leftWrappedFunctions : this.getWrappedFunctions((Function[])sortedRightFunctions);
        if (this.leftWrappedFunctions.length >= 1 && this.rightWrappedFunctions.length >= 1) {
            Function rightFunction;
            Function leftFunction = this.leftIndex < this.leftWrappedFunctions.length ? this.leftWrappedFunctions[this.leftIndex].getFunction() : null;
            Function function = rightFunction = this.rightIndex < this.rightWrappedFunctions.length ? this.rightWrappedFunctions[this.rightIndex].getFunction() : null;
            if (leftFunction == rightFunction && this.rightWrappedFunctions.length > 1) {
                rightFunction = this.rightWrappedFunctions[++this.rightIndex].getFunction();
            }
            this.loadFunctions(leftFunction, rightFunction);
        }
        if (this.leftWrappedFunctions.length > 1 || this.rightWrappedFunctions.length > 1) {
            this.addChoicePanel();
        }
        this.createActions();
    }

    boolean matchesTheseFunctions(Function[] functionsL, Function[] functionsR) {
        return Arrays.equals(this.getLeftFunctions(), this.getSortedFunctions(functionsL)) && Arrays.equals(this.getRightFunctions(), this.getSortedFunctions(functionsR));
    }
}

