/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingKeyBindingAction;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.table.GTable;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.script.GhidraScriptComponentProvider;
import ghidra.app.plugin.core.script.GhidraScriptMgrPlugin;
import ghidra.app.plugin.core.script.ScriptAction;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ScriptInfo;
import ghidra.framework.Application;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.BrowserLoader;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import resources.Icons;
import resources.ResourceManager;
import utilities.util.FileUtilities;

class GhidraScriptActionManager {
    public static final String RERUN_LAST_SHARED_ACTION_NAME = "Rerun Last Script";
    public static final String GLOBAL_RERUN_LAST_SHARED_ACTION_NAME = "Global Rerun Last Script";
    private static final KeyStroke RERUN_LAST_SCRIPT_KEYSTROKE = KeyStroke.getKeyStroke(82, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40);
    private static final String SCRIPT_ACTIONS_KEY = "Scripts_Actions_Key";
    private GhidraScriptComponentProvider provider;
    private GhidraScriptMgrPlugin plugin;
    private DockingAction refreshAction;
    private DockingAction scriptDirsAction;
    private DockingAction newAction;
    private DockingAction runAction;
    private DockingAction runLastAction;
    private DockingAction globalRunLastAction;
    private DockingAction editAction;
    private DockingAction eclipseAction;
    private DockingAction deleteAction;
    private DockingAction renameAction;
    private DockingAction keyBindingAction;
    private DockingAction helpAction;
    private Map<ResourceFile, ScriptAction> actionMap = new HashMap<ResourceFile, ScriptAction>();

    GhidraScriptActionManager(GhidraScriptComponentProvider provider, GhidraScriptMgrPlugin plugin) {
        this.provider = provider;
        this.plugin = plugin;
        this.createActions();
    }

    void dispose() {
        this.actionMap.values().forEach(a -> a.dispose());
        this.actionMap.clear();
    }

    void restoreUserDefinedKeybindings(SaveState saveState) {
        String[] names;
        List<ResourceFile> dirs = GhidraScriptUtil.getScriptSourceDirectories();
        block0: for (String name : names = saveState.getNames()) {
            for (ResourceFile dir : dirs) {
                ResourceFile script = new ResourceFile(dir, name);
                if (!script.exists()) continue;
                ScriptAction action = this.createAction(script);
                String strokeStr = saveState.getString(name, null);
                if (strokeStr == null || strokeStr.length() == 0) {
                    action.setKeyBindingData(null);
                    continue;
                }
                KeyStroke stroke = DockingKeyBindingAction.parseKeyStroke((String)strokeStr);
                if (stroke == null) continue block0;
                action.setKeyBindingData(new KeyBindingData(stroke));
            }
        }
    }

    void restoreScriptsThatAreInTool(SaveState saveState) {
        String[] array;
        for (String filename : array = saveState.getStrings(SCRIPT_ACTIONS_KEY, new String[0])) {
            ScriptInfo info = GhidraScriptUtil.findScriptByName(filename);
            if (info != null) {
                this.provider.getActionManager().createAction(info.getSourceFile());
                continue;
            }
            Msg.info((Object)this, (Object)("Cannot find script for keybinding: '" + filename + "'"));
        }
    }

    void saveUserDefinedKeybindings(SaveState saveState) {
        Collection<ScriptAction> actions = this.actionMap.values();
        for (ScriptAction action : actions) {
            ResourceFile scriptFile;
            ScriptInfo info;
            if (!action.isUserDefinedKeyBinding() || (info = GhidraScriptUtil.getScriptInfo(scriptFile = action.getScript())) == null) continue;
            KeyStroke stroke = action.getKeyBinding();
            if (stroke == null) {
                saveState.putString(scriptFile.getName(), "");
                continue;
            }
            String strokeStr = DockingKeyBindingAction.parseKeyStroke((KeyStroke)stroke);
            saveState.putString(scriptFile.getName(), strokeStr);
        }
    }

    void saveScriptsThatAreInTool(SaveState saveState) {
        Set<ResourceFile> actionScriptFiles = this.actionMap.keySet();
        HashSet<String> scriptPaths = new HashSet<String>(actionScriptFiles.size());
        for (ResourceFile file : actionScriptFiles) {
            scriptPaths.add(file.getName());
        }
        String[] array = scriptPaths.toArray(new String[scriptPaths.size()]);
        saveState.putStrings(SCRIPT_ACTIONS_KEY, array);
    }

    void notifyScriptWasRun() {
        String newDesc = "Rerun " + this.provider.getLastRunScript().getName();
        this.runLastAction.firePropertyChanged("description", (Object)"", (Object)newDesc);
        this.globalRunLastAction.firePropertyChanged("description", (Object)"", (Object)newDesc);
    }

    private void createActions() {
        String runGroup = "1";
        this.runAction = new DockingAction("Run", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.provider.runScript();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof ResourceFile;
            }
        };
        this.runAction.setPopupMenuData(new MenuData(new String[]{"Run"}, (Icon)ResourceManager.loadImage((String)"images/play.png"), null));
        this.runAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/play.png"), runGroup));
        this.runAction.setDescription("Run Script");
        this.runAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.runAction);
        this.runLastAction = new RerunLastScriptAction(RERUN_LAST_SHARED_ACTION_NAME, runGroup);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.runLastAction);
        this.globalRunLastAction = new RerunLastScriptAction(GLOBAL_RERUN_LAST_SHARED_ACTION_NAME, "Xtra");
        this.plugin.getTool().addAction((DockingActionIf)this.globalRunLastAction);
        this.editAction = new DockingAction("Edit", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.provider.editScriptBuiltin();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof ResourceFile;
            }
        };
        this.editAction.setPopupMenuData(new MenuData(new String[]{"Edit with basic editor"}, (Icon)ResourceManager.loadImage((String)"images/accessories-text-editor.png"), null));
        this.editAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/accessories-text-editor.png"), null));
        this.editAction.setDescription("Edit Script with basic editor");
        this.editAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.editAction);
        this.eclipseAction = new DockingAction("EditEclipse", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.provider.editScriptEclipse();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof ResourceFile;
            }
        };
        this.eclipseAction.setPopupMenuData(new MenuData(new String[]{"Edit with Eclipse"}, (Icon)ResourceManager.loadImage((String)"images/eclipse.png"), null));
        this.eclipseAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/eclipse.png"), null));
        this.eclipseAction.setDescription("Edit Script with Eclipse");
        this.eclipseAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.eclipseAction);
        this.keyBindingAction = new DockingAction("Key Binding", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.provider.assignKeyBinding();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof ResourceFile;
            }
        };
        this.keyBindingAction.setPopupMenuData(new MenuData(new String[]{"Assign Key Binding"}, (Icon)ResourceManager.loadImage((String)"images/key.png"), null));
        this.keyBindingAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/key.png"), null));
        this.keyBindingAction.setDescription("Assign Key Binding");
        this.keyBindingAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.keyBindingAction);
        this.deleteAction = new DockingAction("Delete", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.provider.deleteScript();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof ResourceFile;
            }
        };
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, (Icon)ResourceManager.loadImage((String)"images/edit-delete.png"), null));
        this.deleteAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/edit-delete.png"), null));
        this.deleteAction.setDescription("Delete Script");
        this.deleteAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.deleteAction);
        this.renameAction = new DockingAction("Rename", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.provider.renameScript();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof ResourceFile;
            }
        };
        this.renameAction.setPopupMenuData(new MenuData(new String[]{"Rename"}, (Icon)ResourceManager.loadImage((String)"images/textfield_rename.png"), null));
        this.renameAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/textfield_rename.png"), null));
        this.renameAction.setDescription("Rename Script");
        this.renameAction.setEnabled(false);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.renameAction);
        this.newAction = new DockingAction("New", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.provider.newScript();
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof GTable || contextObject instanceof ResourceFile;
            }
        };
        this.newAction.setPopupMenuData(new MenuData(new String[]{"New"}, (Icon)ResourceManager.loadImage((String)"images/script_add.png"), null));
        this.newAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/script_add.png"), null));
        this.newAction.setDescription("Create New Script");
        this.newAction.setEnabled(true);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.newAction);
        this.refreshAction = new DockingAction("Refresh", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptUtil.refreshRequested();
                GhidraScriptActionManager.this.provider.refresh();
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof GTable || contextObject instanceof ResourceFile;
            }
        };
        this.refreshAction.setPopupMenuData(new MenuData(new String[]{"Refresh"}, (Icon)Icons.REFRESH_ICON, null));
        this.refreshAction.setToolBarData(new ToolBarData((Icon)Icons.REFRESH_ICON, null));
        this.refreshAction.setDescription("Refresh Script List");
        this.refreshAction.setEnabled(true);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.refreshAction);
        this.scriptDirsAction = new DockingAction("Script Directories", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.provider.pickPaths();
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof GTable || contextObject instanceof ResourceFile;
            }
        };
        this.scriptDirsAction.setPopupMenuData(new MenuData(new String[]{"Script Directories"}, (Icon)ResourceManager.loadImage((String)"images/text_list_bullets.png"), null));
        this.scriptDirsAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/text_list_bullets.png"), null));
        this.scriptDirsAction.setDescription("Script Directories");
        this.scriptDirsAction.setEnabled(true);
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.scriptDirsAction);
        this.helpAction = new DockingAction("Ghidra API Help", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.showGhidraScriptJavadoc();
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof GTable || contextObject instanceof ResourceFile;
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject instanceof GTable || contextObject instanceof ResourceFile;
            }
        };
        this.helpAction.setPopupMenuData(new MenuData(new String[]{"Ghidra API Help"}, (Icon)ResourceManager.loadImage((String)"images/red-cross.png"), null));
        this.helpAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/red-cross.png"), null));
        this.helpAction.setDescription("Help");
        this.helpAction.setEnabled(true);
        this.helpAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Help"));
        this.plugin.getTool().addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.helpAction);
        DockingAction globalHelpAction = new DockingAction("Ghidra API Help", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GhidraScriptActionManager.this.showGhidraScriptJavadoc();
            }

            public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
                return true;
            }
        };
        globalHelpAction.setEnabled(true);
        globalHelpAction.setHelpLocation(new HelpLocation("Misc", "Welcome_to_Ghidra_Help"));
        globalHelpAction.setMenuBarData(new MenuData(new String[]{"&Help", "Ghidra API Help"}, null, "AAAHelpContents"));
        this.plugin.getTool().addAction((DockingActionIf)globalHelpAction);
    }

    private void showGhidraScriptJavadoc() {
        if (SystemUtilities.isInDevelopmentMode()) {
            Msg.showWarn((Object)this, (Component)this.provider.getComponent(), (String)"Error Unzipping Javadoc File", (Object)"Cannot view Ghidra API Help in development mode.");
            return;
        }
        File zipFile = new File(Application.getInstallationDirectory().getFile(false), "docs/GhidraAPI_javadoc.zip");
        String version = Application.getApplicationVersion();
        File extractDir = new File(Application.getUserCacheDirectory(), "GhidraAPI_javadoc");
        File entryFile = new File(extractDir, version + "/api/ghidra/app/script/GhidraScript.html");
        LaunchJavadocTask task = new LaunchJavadocTask(zipFile, extractDir, entryFile, version);
        new TaskLauncher((Task)task, (Component)this.provider.getComponent());
    }

    HelpLocation getPathHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.scriptDirsAction.getName());
    }

    HelpLocation getKeyBindingHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.keyBindingAction.getName());
    }

    HelpLocation getRenameHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.renameAction.getName());
    }

    HelpLocation getNewHelpLocation() {
        return new HelpLocation(this.plugin.getName(), this.newAction.getName());
    }

    ScriptAction get(ResourceFile script) {
        return this.actionMap.get(script);
    }

    boolean hasScriptAction(ResourceFile script) {
        return this.actionMap.containsKey(script);
    }

    synchronized ScriptAction createAction(ResourceFile script) {
        ScriptAction action = this.actionMap.get(script);
        if (action == null) {
            action = new ScriptAction(this.plugin, script);
            this.actionMap.put(script, action);
            this.plugin.getTool().addAction((DockingActionIf)action);
        }
        return action;
    }

    synchronized void removeAction(ResourceFile script) {
        ScriptAction action = this.actionMap.remove(script);
        if (action != null) {
            action.dispose();
            this.plugin.getTool().removeAction((DockingActionIf)action);
        }
    }

    KeyStroke getKeyBinding(ResourceFile script) {
        ScriptAction action = this.actionMap.get(script);
        if (action != null) {
            return action.getKeyBinding();
        }
        return null;
    }

    private class RerunLastScriptAction
    extends DockingAction
    implements OptionsChangeListener {
        RerunLastScriptAction(String actionName, String toolbarGroup) {
            super(actionName, GhidraScriptActionManager.this.plugin.getName(), false);
            this.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/play_again.png"), toolbarGroup));
            this.setDescription("Rerun the last run script");
            this.setEnabled(false);
            DummyKeyBindingsOptionsAction action = new DummyKeyBindingsOptionsAction(GhidraScriptActionManager.RERUN_LAST_SHARED_ACTION_NAME, RERUN_LAST_SCRIPT_KEYSTROKE);
            PluginTool tool = GhidraScriptActionManager.this.plugin.getTool();
            tool.addAction((DockingActionIf)action);
            ToolOptions options = tool.getOptions("Key Bindings");
            KeyStroke keyStroke = options.getKeyStroke(this.getFullSharedActionName(), RERUN_LAST_SCRIPT_KEYSTROKE);
            if (!RERUN_LAST_SCRIPT_KEYSTROKE.equals(keyStroke)) {
                this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
            } else {
                this.setKeyBindingData(new KeyBindingData(keyStroke));
            }
            options.addOptionsChangeListener((OptionsChangeListener)this);
            this.setHelpLocation(new HelpLocation(GhidraScriptActionManager.this.plugin.getName(), "Run_Last"));
        }

        private String getFullSharedActionName() {
            return "Rerun Last Script (Tool)";
        }

        public void actionPerformed(ActionContext context) {
            GhidraScriptActionManager.this.provider.runLastScript();
        }

        public boolean isEnabledForContext(ActionContext context) {
            return GhidraScriptActionManager.this.provider.getLastRunScript() != null;
        }

        public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
            KeyStroke keyStroke = (KeyStroke)newValue;
            if (name.startsWith(GhidraScriptActionManager.RERUN_LAST_SHARED_ACTION_NAME)) {
                this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
            }
        }
    }

    private class LaunchJavadocTask
    extends Task {
        private final File zipFile;
        private final File extractDir;
        private final File entryFile;
        private final String version;

        LaunchJavadocTask(File zipFile, File extractDir, File entryFile, String version) {
            super("Extract Javadoc Task", true, true, true);
            this.zipFile = zipFile;
            this.extractDir = extractDir;
            this.entryFile = entryFile;
            this.version = version;
        }

        public void run(TaskMonitor monitor) {
            if (!this.zipFile.exists()) {
                Msg.showError((Object)GhidraScriptActionManager.this, (Component)GhidraScriptActionManager.this.provider.getComponent(), (String)"Unexpected Error Unzipping Javadoc File", (Object)("Javadoc zip file does not exist at expected path: " + this.zipFile.getAbsolutePath()));
                return;
            }
            if (this.extractDir.exists()) {
                for (File dir : this.extractDir.listFiles(File::isDirectory)) {
                    if (dir.getName().equals(this.version)) continue;
                    this.cleanup(monitor, dir);
                }
            }
            File versionedExtractDir = new File(this.extractDir, this.version);
            try (ZipFile zf = new ZipFile(this.zipFile);){
                if (versionedExtractDir.exists()) {
                    if ((long)(zf.size() + 1) == Files.walk(versionedExtractDir.toPath(), new FileVisitOption[0]).count()) {
                        this.launchJavadoc();
                        return;
                    }
                    this.cleanup(monitor, versionedExtractDir);
                }
                monitor.setMessage("Preparing to extract Ghidra API javadoc...");
                monitor.initialize((long)zf.size());
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    if (monitor.isCancelled()) {
                        this.cleanup(monitor, versionedExtractDir);
                        return;
                    }
                    ZipEntry entry = entries.nextElement();
                    monitor.setMessage("Extracting " + entry.getName() + "...");
                    this.writeZipEntry(versionedExtractDir, entry, zf.getInputStream(entry));
                    monitor.incrementProgress(1L);
                }
                monitor.setMessage("Launching native viewer for " + this.entryFile.getName());
                this.launchJavadoc();
            }
            catch (IOException e) {
                Msg.showError((Object)GhidraScriptActionManager.this, (Component)GhidraScriptActionManager.this.provider.getComponent(), (String)"Unexpected Error Unzipping Javadoc File", (Object)"Unexpected error unzipping javadoc file", (Throwable)e);
                this.cleanup(monitor, versionedExtractDir);
            }
        }

        private void cleanup(TaskMonitor monitor, File dir) {
            monitor.setMessage("Deleting " + dir.getName() + "...");
            FileUtilities.deleteDir((File)dir);
        }

        private void launchJavadoc() {
            URI URI2 = this.entryFile.toURI();
            URL URL2 = null;
            try {
                URL2 = URI2.toURL();
            }
            catch (MalformedURLException e) {
                Msg.showError((Object)GhidraScriptActionManager.this, (Component)GhidraScriptActionManager.this.provider.getComponent(), (String)"Unexpected Error Showing Script Help", (Object)"Unexpectedly could not create a URL for the GhidraScript javadoc", (Throwable)e);
                return;
            }
            BrowserLoader.display(URL2, URL2, (ServiceProvider)GhidraScriptActionManager.this.plugin.getTool());
        }

        private void writeZipEntry(File unzipDirectory, ZipEntry entry, InputStream inputStream) throws IOException {
            String zipName = entry.getName();
            if (zipName.endsWith("/")) {
                new File(unzipDirectory, zipName).mkdirs();
                return;
            }
            File file = new File(unzipDirectory, zipName);
            this.mkdirs(file);
            FileOutputStream ouputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int bytesRead = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ouputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            ouputStream.close();
        }

        private void mkdirs(File file) {
            String filename = file.getName();
            if (filename.endsWith("/")) {
                file.mkdirs();
            } else {
                File parentFile = file.getParentFile();
                parentFile.mkdirs();
            }
        }
    }
}

