/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import java.io.IOException;
import java.io.InputStream;

public class ByteProviderPaddedInputStream
extends InputStream {
    private ByteProvider provider;
    private long currentBPOffset;
    private long bpEndOffset;
    private long bpEndPadOffset;

    public ByteProviderPaddedInputStream(ByteProvider provider, long startOffset, long length, long padCount) {
        this.provider = provider;
        this.currentBPOffset = startOffset;
        this.bpEndOffset = startOffset + length;
        this.bpEndPadOffset = this.bpEndOffset + padCount;
    }

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        if (this.currentBPOffset < this.bpEndOffset) {
            return this.provider.readByte(this.currentBPOffset++) & 0xFF;
        }
        if (this.currentBPOffset < this.bpEndPadOffset) {
            ++this.currentBPOffset;
            return 0;
        }
        return -1;
    }

    @Override
    public int available() {
        return (int)Math.min(this.bpEndPadOffset - this.currentBPOffset, Integer.MAX_VALUE);
    }
}

