/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.IdentityHashMap;

public class DataTypeGraphComparator {
    private DataTypePairObserver observer;
    private IdentityHashMap<DataType, DataType> visitedTypes = new IdentityHashMap();

    public static void compare(DataType preDT, DataType postDT, DataTypePairObserver observer) {
        DataTypeGraphComparator dtgc = new DataTypeGraphComparator(observer);
        dtgc.compare(preDT, postDT);
    }

    private DataTypeGraphComparator(DataTypePairObserver observer) {
        this.observer = observer;
    }

    private void compare(DataType preDT, DataType postDT) {
        if (this.visitedTypes.containsKey(preDT)) {
            return;
        }
        this.visitedTypes.put(preDT, preDT);
        if (!this.observer.observe(preDT, postDT)) {
            return;
        }
        if (preDT instanceof Pointer && postDT instanceof Pointer) {
            this.compare((Pointer)preDT, (Pointer)postDT);
        } else if (preDT instanceof Array && postDT instanceof Array) {
            this.compare((Array)preDT, (Array)postDT);
        } else if (preDT instanceof Enum && postDT instanceof Enum) {
            this.compare((Enum)preDT, (Enum)postDT);
        } else if (preDT instanceof TypeDef && postDT instanceof TypeDef) {
            this.compare((TypeDef)preDT, (TypeDef)postDT);
        } else if (preDT instanceof FunctionDefinition && postDT instanceof FunctionDefinition) {
            this.compare((FunctionDefinition)preDT, (FunctionDefinition)postDT);
        } else if (preDT instanceof Structure && postDT instanceof Structure) {
            this.compare((Structure)preDT, (Structure)postDT);
        } else if (preDT instanceof Union && postDT instanceof Union) {
            this.compare((Union)preDT, (Union)postDT);
        }
    }

    private void compare(Pointer pre, Pointer post) {
        if (pre.getLength() != post.getLength()) {
            Msg.error((Object)this, (Object)("Ptr types don't match: " + pre + ", " + post));
            return;
        }
        this.compare(pre.getDataType(), post.getDataType());
    }

    private void compare(Enum pre, Enum post) {
        if (pre.getLength() != post.getLength()) {
            Msg.error((Object)this, (Object)("Enum data type sizes don't match: " + pre + ", " + post));
            return;
        }
    }

    private void compare(Array pre, Array post) {
        this.compare(pre.getDataType(), post.getDataType());
    }

    private void compare(TypeDef pre, TypeDef post) {
        this.compare(pre.getDataType(), post.getDataType());
    }

    private void compare(FunctionDefinition pre, FunctionDefinition post) {
        this.compare(pre.getReturnType(), post.getReturnType());
        ParameterDefinition[] preArgs = pre.getArguments();
        ParameterDefinition[] postArgs = post.getArguments();
        if (preArgs.length != postArgs.length) {
            return;
        }
        for (int i = 0; i < preArgs.length; ++i) {
            ParameterDefinition prePD = preArgs[i];
            ParameterDefinition postPD = postArgs[i];
            this.compare(prePD.getDataType(), postPD.getDataType());
        }
    }

    private void compare(Structure pre, Structure post) {
        for (DataTypeComponent dtc : pre.getComponents()) {
            DataType preDTCType = dtc.getDataType();
            DataTypeComponent postDTC = post.getComponentAt(dtc.getOffset());
            if (postDTC == null) continue;
            String dtcFN = dtc.getFieldName();
            String postFN = postDTC.getFieldName();
            if (postFN == null || !postFN.equals(dtcFN)) continue;
            this.compare(preDTCType, postDTC.getDataType());
        }
    }

    private void compare(Union pre, Union post) {
        HashMap<String, DataTypeComponent> postCompsByName = new HashMap<String, DataTypeComponent>();
        for (DataTypeComponent dtc : post.getComponents()) {
            if (dtc.getFieldName() == null) continue;
            postCompsByName.put(dtc.getFieldName(), dtc);
        }
        for (DataTypeComponent preDTC : pre.getComponents()) {
            DataTypeComponent postDTC = (DataTypeComponent)postCompsByName.get(preDTC.getFieldName());
            if (postDTC == null) continue;
            this.compare(preDTC.getDataType(), postDTC.getDataType());
        }
    }

    public static interface DataTypePairObserver {
        public boolean observe(DataType var1, DataType var2);
    }
}

