/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.MemoryLoadable;
import ghidra.app.util.bin.format.Writeable;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfSectionHeaderType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class ElfSectionHeader
implements StructConverter,
Writeable,
MemoryLoadable {
    private int sh_name;
    private int sh_type;
    private long sh_flags;
    private long sh_addr;
    private long sh_offset;
    private long sh_size;
    private int sh_link;
    private int sh_info;
    private long sh_addralign;
    private long sh_entsize;
    private FactoryBundledWithBinaryReader reader;
    private ElfHeader header;
    private String name;
    private byte[] data;
    private boolean modified = false;
    private boolean bytesChanged = false;

    static ElfSectionHeader createElfSectionHeader(FactoryBundledWithBinaryReader reader, ElfHeader header) throws IOException {
        ElfSectionHeader elfSectionHeader = (ElfSectionHeader)reader.getFactory().create(ElfSectionHeader.class, new Object[0]);
        elfSectionHeader.initElfSectionHeader(reader, header);
        return elfSectionHeader;
    }

    public ElfSectionHeader() {
    }

    private void initElfSectionHeader(FactoryBundledWithBinaryReader reader, ElfHeader header) throws IOException {
        this.reader = reader;
        this.header = header;
        this.sh_name = reader.readNextInt();
        this.sh_type = reader.readNextInt();
        if (header.is32Bit()) {
            this.sh_flags = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.sh_addr = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.sh_offset = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.sh_size = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else if (header.is64Bit()) {
            this.sh_flags = reader.readNextLong();
            this.sh_addr = reader.readNextLong();
            this.sh_offset = reader.readNextLong();
            this.sh_size = reader.readNextLong();
        }
        this.sh_link = reader.readNextInt();
        this.sh_info = reader.readNextInt();
        if (header.is32Bit()) {
            this.sh_addralign = (long)reader.readNextInt() & 0xFFFFFFFFL;
            this.sh_entsize = (long)reader.readNextInt() & 0xFFFFFFFFL;
        } else if (header.is64Bit()) {
            this.sh_addralign = reader.readNextLong();
            this.sh_entsize = reader.readNextLong();
        }
    }

    ElfSectionHeader(ElfHeader header, MemoryBlock block, int sh_name, long imageBase) throws MemoryAccessException {
        this.header = header;
        this.sh_name = sh_name;
        this.sh_type = block.isInitialized() ? 1 : 8;
        this.sh_flags = 7L;
        this.sh_addr = block.getStart().getOffset();
        this.sh_offset = block.getStart().getAddressableWordOffset() - imageBase;
        this.sh_size = block.getSize();
        this.sh_link = 0;
        this.sh_info = 0;
        this.sh_addralign = 0L;
        this.sh_entsize = 0L;
        this.name = block.getName();
        this.data = new byte[(int)this.sh_size];
        if (block.isInitialized()) {
            block.getBytes(block.getStart(), this.data);
        }
        this.modified = true;
    }

    ElfSectionHeader(ElfHeader header, String name, int sh_name, int type) {
        this.header = header;
        this.sh_name = sh_name;
        this.sh_type = type;
        this.sh_flags = 7L;
        this.sh_link = 0;
        this.sh_info = 0;
        this.sh_addralign = 0L;
        this.sh_entsize = 0L;
        this.name = name;
        this.data = new byte[0];
        this.sh_size = 0L;
        this.sh_addr = -1L;
        this.sh_offset = -1L;
    }

    public ElfHeader getElfHeader() {
        return this.header;
    }

    @Override
    public void write(RandomAccessFile raf, DataConverter dc) throws IOException {
        raf.write(dc.getBytes(this.sh_name));
        raf.write(dc.getBytes(this.sh_type));
        if (this.header.is32Bit()) {
            raf.write(dc.getBytes((int)this.sh_flags));
            raf.write(dc.getBytes((int)this.sh_addr));
            raf.write(dc.getBytes((int)this.sh_offset));
            raf.write(dc.getBytes((int)this.sh_size));
        } else if (this.header.is64Bit()) {
            raf.write(dc.getBytes(this.sh_flags));
            raf.write(dc.getBytes(this.sh_addr));
            raf.write(dc.getBytes(this.sh_offset));
            raf.write(dc.getBytes(this.sh_size));
        }
        raf.write(dc.getBytes(this.sh_link));
        raf.write(dc.getBytes(this.sh_info));
        if (this.header.is32Bit()) {
            raf.write(dc.getBytes((int)this.sh_addralign));
            raf.write(dc.getBytes((int)this.sh_entsize));
        } else if (this.header.is64Bit()) {
            raf.write(dc.getBytes(this.sh_addralign));
            raf.write(dc.getBytes(this.sh_entsize));
        }
    }

    public long getAddress() {
        return this.header.adjustAddressForPrelink(this.sh_addr);
    }

    public long getAddressAlignment() {
        return this.sh_addralign;
    }

    public long getEntrySize() {
        return this.sh_entsize;
    }

    public long getFlags() {
        return this.sh_flags;
    }

    public boolean isWritable() {
        return this.header.getLoadAdapter().isSectionWritable(this);
    }

    public boolean isExecutable() {
        return this.header.getLoadAdapter().isSectionExecutable(this);
    }

    public boolean isAlloc() {
        return this.header.getLoadAdapter().isSectionAllocated(this);
    }

    public int getInfo() {
        return this.sh_info;
    }

    public int getLink() {
        return this.sh_link;
    }

    public int getName() {
        return this.sh_name;
    }

    void updateName() throws IOException {
        if (this.sh_name == -1) {
            return;
        }
        ElfSectionHeader[] sections = this.header.getSections();
        short e_shstrndx = this.header.e_shstrndx();
        if (e_shstrndx >= sections.length) {
            int index = 0;
            for (int i = 0; i < sections.length; ++i) {
                if (sections[i] != this) continue;
                index = i;
                break;
            }
            this.name = "SECTION" + index;
        } else {
            if (this.reader == null) {
                throw new UnsupportedOperationException("This ElfSectionHeader does not have a reader");
            }
            long stringTableOffset = sections[e_shstrndx].getOffset();
            if (stringTableOffset + (long)this.sh_name < 0L) {
                Msg.error((Object)this, (Object)("Invalid name offset " + (stringTableOffset + (long)this.sh_name)));
                return;
            }
            this.name = this.reader.readAsciiString(stringTableOffset + (long)this.sh_name);
            if ("".equals(this.name)) {
                this.name = "EMPTYNAME_" + String.format("0x%x", this.sh_offset);
            }
            if (this.sh_type == 18) {
                Msg.debug((Object)this, (Object)"sh_type==SHT_SYMTAB_SHNDX");
            }
        }
    }

    public String getNameAsString() {
        return this.name;
    }

    public String toString() {
        return this.name + " - 0x" + Long.toHexString(this.sh_addr) + ":0x" + Long.toHexString(this.sh_addr + this.sh_size - 1L) + " - 0x" + Long.toHexString(this.sh_size) + "  - 0x" + Long.toHexString(this.sh_offset);
    }

    public long getOffset() {
        return this.sh_offset;
    }

    public void setSize(long size) {
        this.sh_size = size;
        this.checkSize();
    }

    public long getSize() {
        return this.sh_size;
    }

    public long getAdjustedSize() {
        return this.header.getLoadAdapter().getAdjustedSize(this);
    }

    public int getType() {
        return this.sh_type;
    }

    public String getTypeAsString() {
        ElfSectionHeaderType sectionHeaderType = this.header.getSectionHeaderType(this.sh_type);
        if (sectionHeaderType != null) {
            return sectionHeaderType.name;
        }
        return "SHT_0x" + StringUtilities.pad((String)Integer.toHexString(this.sh_type), (char)'0', (int)8);
    }

    public byte[] getData() throws IOException {
        if (this.sh_type == 8) {
            return new byte[0];
        }
        if (this.data != null) {
            return this.data;
        }
        if (this.reader == null) {
            throw new UnsupportedOperationException("This ElfSectionHeader does not have a reader");
        }
        return this.reader.readByteArray(this.sh_offset, (int)this.sh_size);
    }

    public InputStream getDataStream() throws IOException {
        if (this.reader == null) {
            throw new UnsupportedOperationException("This ElfSectionHeader does not have a reader");
        }
        return this.reader.getByteProvider().getInputStream(this.sh_offset);
    }

    public BinaryReader getReader() {
        return this.reader;
    }

    public void setData(byte[] data) {
        this.bytesChanged = true;
        if (this.sh_type == 8) {
            throw new IllegalArgumentException("Cannot set data on section with type: SHT_NOBITS");
        }
        this.data = data;
        if ((long)data.length > this.sh_size) {
            this.modified = true;
            this.sh_offset = -1L;
        }
        this.sh_size = data.length;
    }

    public boolean isBytesChanged() {
        return this.bytesChanged;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setOffset(long offset) throws IOException {
        this.modified = true;
        if (this.data == null) {
            this.data = this.getData();
        }
        this.sh_offset = offset;
    }

    public void setAddress(long addr) {
        if (!this.header.isRelocatable() && this.sh_addr == 0L) {
            throw new RuntimeException("Attempting to place non-loaded section into memory :" + this.name);
        }
        this.sh_addr = this.header.unadjustAddressForPrelink(addr);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DataType toDataType() {
        String dtName = this.header.is32Bit() ? "Elf32_Shdr" : "Elf64_Shdr";
        StructureDataType struct = new StructureDataType(new CategoryPath("/ELF"), dtName, 0);
        struct.add(DWORD, "sh_name", null);
        struct.add(this.getTypeDataType(), "sh_type", null);
        if (this.header.is32Bit()) {
            struct.add(DWORD, "sh_flags", null);
            struct.add(DWORD, "sh_addr", null);
            struct.add(DWORD, "sh_offset", null);
            struct.add(DWORD, "sh_size", null);
        } else if (this.header.is64Bit()) {
            struct.add(QWORD, "sh_flags", null);
            struct.add(QWORD, "sh_addr", null);
            struct.add(QWORD, "sh_offset", null);
            struct.add(QWORD, "sh_size", null);
        }
        struct.add(DWORD, "sh_link", null);
        struct.add(DWORD, "sh_info", null);
        if (this.header.is32Bit()) {
            struct.add(DWORD, "sh_addralign", null);
            struct.add(DWORD, "sh_entsize", null);
        } else if (this.header.is64Bit()) {
            struct.add(QWORD, "sh_addralign", null);
            struct.add(QWORD, "sh_entsize", null);
        }
        return struct;
    }

    private DataType getTypeDataType() {
        HashMap<Integer, ElfSectionHeaderType> sectionHeaderTypeMap = this.header.getSectionHeaderTypeMap();
        if (sectionHeaderTypeMap == null) {
            return DWordDataType.dataType;
        }
        Object dtName = "Elf_SectionHeaderType";
        String typeSuffix = this.header.getTypeSuffix();
        if (typeSuffix != null) {
            dtName = (String)dtName + typeSuffix;
        }
        EnumDataType typeEnum = new EnumDataType(new CategoryPath("/ELF"), (String)dtName, 4);
        for (ElfSectionHeaderType type : sectionHeaderTypeMap.values()) {
            typeEnum.add(type.name, (long)type.value);
        }
        return typeEnum;
    }

    private void checkSize() {
        if (this.sh_size > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("ELF Section is too large: 0x" + Long.toHexString(this.sh_size));
        }
    }

    public int hashCode() {
        return (int)(17L * this.sh_offset + (this.sh_offset >>> 32));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElfSectionHeader)) {
            return false;
        }
        ElfSectionHeader other = (ElfSectionHeader)obj;
        return this.reader == other.reader && this.sh_name == other.sh_name && this.sh_type == other.sh_type && this.sh_flags == other.sh_flags && this.sh_addr == other.sh_addr && this.sh_offset == other.sh_offset && this.sh_size == other.sh_size && this.sh_link == other.sh_link && this.sh_info == other.sh_info && this.sh_addralign == other.sh_addralign && this.sh_entsize == other.sh_entsize;
    }
}

