/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import java.io.IOException;
import java.util.ArrayList;

public class OmfGroupRecord
extends OmfRecord {
    private int groupNameIndex;
    private String groupName;
    private long vma = -1L;
    private GroupSubrecord[] group;

    public OmfGroupRecord(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        long max = reader.getPointerIndex() + (long)this.getRecordLength() - 1L;
        this.groupNameIndex = OmfRecord.readIndex(reader);
        ArrayList<GroupSubrecord> grouplist = new ArrayList<GroupSubrecord>();
        while (reader.getPointerIndex() < max) {
            GroupSubrecord subrec = GroupSubrecord.read(reader);
            grouplist.add(subrec);
        }
        this.readCheckSumByte(reader);
        this.group = new GroupSubrecord[grouplist.size()];
        grouplist.toArray(this.group);
    }

    public String getName() {
        return this.groupName;
    }

    public void setStartAddress(long val) {
        this.vma = val;
    }

    public long getStartAddress() {
        return this.vma;
    }

    public int getFrameDatum() {
        return 0;
    }

    public int numSegments() {
        return this.group.length;
    }

    public byte getSegmentComponentType(int i) {
        return this.group[i].componentType;
    }

    public int getSegmentIndex(int i) {
        return this.group[i].segmentIndex;
    }

    public Address getAddress(Language language) {
        AddressSpace addrSpace = language.getDefaultSpace();
        return addrSpace.getAddress(this.vma);
    }

    public void resolveNames(ArrayList<String> nameList) throws OmfException {
        if (this.groupNameIndex <= 0) {
            throw new OmfException("Cannot have unused group name");
        }
        if (this.groupNameIndex > nameList.size()) {
            throw new OmfException("Group name index out of bounds");
        }
        this.groupName = nameList.get(this.groupNameIndex - 1);
    }

    public static class GroupSubrecord {
        private byte componentType;
        private int segmentIndex;

        public static GroupSubrecord read(BinaryReader reader) throws IOException {
            GroupSubrecord subrec = new GroupSubrecord();
            subrec.componentType = reader.readNextByte();
            subrec.segmentIndex = OmfRecord.readIndex(reader);
            return subrec;
        }
    }
}

