/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.debug.OMFSegMapDesc;
import java.io.IOException;

public class OMFSegMap {
    private short cSeg;
    private short cSegLog;
    private OMFSegMapDesc[] segmentMapDesc;

    static OMFSegMap createOMFSegMap(FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        OMFSegMap omfSegMap = (OMFSegMap)reader.getFactory().create(OMFSegMap.class, new Object[0]);
        omfSegMap.initOMFSegMap(reader, ptr);
        return omfSegMap;
    }

    private void initOMFSegMap(FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        this.cSeg = reader.readShort(ptr);
        this.cSegLog = reader.readShort(ptr += 2);
        ptr += 2;
        this.segmentMapDesc = new OMFSegMapDesc[this.cSeg];
        for (int i = 0; i < this.cSeg; ++i) {
            this.segmentMapDesc[i] = OMFSegMapDesc.createOMFSegMapDesc(reader, ptr);
            ptr += 20;
        }
    }

    public short getSegmentDescriptorCount() {
        return this.cSeg;
    }

    public short getLogicalSegmentDescriptorCount() {
        return this.cSegLog;
    }

    public OMFSegMapDesc[] getSegmentDescriptor() {
        return this.segmentMapDesc;
    }
}

