/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public abstract class Relocation
implements StructConverter {
    protected int opcode;

    public abstract boolean isMatch();

    public abstract void apply(ImportStateCache var1, RelocationState var2, ContainerHeader var3, Program var4, MessageLog var5, TaskMonitor var6);

    public int getOpcode() {
        return this.opcode;
    }

    public int getSizeInBytes() {
        return 2;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dt = this.getSizeInBytes() == 2 ? WORD : DWORD;
        return new TypedefDataType(this.toString(), dt);
    }

    public String toString() {
        String className = this.getClass().getName();
        int pos = className.lastIndexOf(46);
        if (pos == -1) {
            return className;
        }
        return className.substring(pos + 1);
    }
}

