/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.dialog;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.MultiLineLabel;
import docking.widgets.OptionDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.remote.User;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CheckoutDialog
extends DialogComponentProvider {
    public static final int CHECKOUT = 0;
    public static final int DO_NOT_CHECKOUT = 1;
    private boolean exclusiveCheckout;
    private int actionID = 1;

    public CheckoutDialog(DomainFile df, User user) {
        super("Versioned File not Checked Out", true);
        this.addWorkPanel(this.buildMainPanel(df, user));
        this.setHelpLocation(new HelpLocation("ProgramManagerPlugin", "FileNotCheckedOut"));
        JButton checkoutButton = new JButton("Yes");
        checkoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckoutDialog.this.actionID = 0;
                CheckoutDialog.this.close();
            }
        });
        this.addButton(checkoutButton);
        JButton noCheckoutButton = new JButton("No");
        noCheckoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckoutDialog.this.actionID = 1;
                CheckoutDialog.this.close();
            }
        });
        this.addButton(noCheckoutButton);
    }

    public int showDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            DockingWindowManager.showDialog(null, (DialogComponentProvider)this);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DockingWindowManager.showDialog(null, (DialogComponentProvider)CheckoutDialog.this);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.actionID;
    }

    public boolean exclusiveCheckout() {
        return this.exclusiveCheckout;
    }

    private JPanel buildMainPanel(DomainFile df, User user) {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel msgPanel = new JPanel(new BorderLayout());
        JLabel warnIcon = new JLabel(OptionDialog.getIconForMessageType((int)2));
        msgPanel.add((Component)warnIcon, "West");
        MultiLineLabel msgText = new MultiLineLabel(df.getName() + " file is NOT CHECKED OUT.\nIf you want to make changes and save them\nto THIS file, then you must first check out the file.\nDo you want to Check Out this file?");
        msgText.setMaximumSize(msgText.getPreferredSize());
        msgPanel.add((Component)msgText, "Center");
        innerPanel.add((Component)msgPanel, "Center");
        this.exclusiveCheckout = true;
        if (user != null) {
            this.exclusiveCheckout = false;
            if (user.hasWritePermission()) {
                final JCheckBox exclusiveCB = new JCheckBox("Request exclusive check out");
                exclusiveCB.setSelected(false);
                exclusiveCB.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CheckoutDialog.this.exclusiveCheckout = exclusiveCB.isSelected();
                    }
                });
                JPanel cbPanel = new JPanel(new BorderLayout());
                cbPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                cbPanel.add(exclusiveCB);
                innerPanel.add((Component)cbPanel, "South");
            }
        }
        return innerPanel;
    }
}

