/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.prevayler.Clock;
import org.prevayler.Query;
import org.prevayler.foundation.Cool;
import org.prevayler.foundation.DeepCopier;
import org.prevayler.foundation.serialization.Serializer;
import org.prevayler.implementation.Capsule;
import org.prevayler.implementation.TransactionTimestamp;
import org.prevayler.implementation.publishing.TransactionPublisher;
import org.prevayler.implementation.publishing.TransactionSubscriber;
import org.prevayler.implementation.snapshot.GenericSnapshotManager;

public class PrevalentSystemGuard<P>
implements TransactionSubscriber {
    private P _prevalentSystem;
    private long _systemVersion;
    private boolean _ignoreRuntimeExceptions;
    private final Serializer _journalSerializer;

    public PrevalentSystemGuard(P prevalentSystem, long systemVersion, Serializer journalSerializer) {
        this._prevalentSystem = prevalentSystem;
        this._systemVersion = systemVersion;
        this._ignoreRuntimeExceptions = false;
        this._journalSerializer = journalSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P prevalentSystem() {
        PrevalentSystemGuard prevalentSystemGuard = this;
        synchronized (prevalentSystemGuard) {
            if (this._prevalentSystem == null) {
                throw new Error("Prevayler is no longer allowing access to the prevalent system due to an Error thrown from an earlier transaction.");
            }
            return this._prevalentSystem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeTo(TransactionPublisher publisher) throws IOException, ClassNotFoundException {
        long initialTransaction;
        PrevalentSystemGuard prevalentSystemGuard = this;
        synchronized (prevalentSystemGuard) {
            this._ignoreRuntimeExceptions = true;
            initialTransaction = this._systemVersion + 1L;
        }
        publisher.subscribe(this, initialTransaction);
        prevalentSystemGuard = this;
        synchronized (prevalentSystemGuard) {
            this._ignoreRuntimeExceptions = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(TransactionTimestamp transactionTimestamp) {
        Capsule capsule = transactionTimestamp.capsule();
        long systemVersion = transactionTimestamp.systemVersion();
        Date executionTime = transactionTimestamp.executionTime();
        PrevalentSystemGuard prevalentSystemGuard = this;
        synchronized (prevalentSystemGuard) {
            if (this._prevalentSystem == null) {
                throw new Error("Prevayler is no longer processing transactions due to an Error thrown from an earlier transaction.");
            }
            if (systemVersion != this._systemVersion + 1L) {
                throw new IllegalStateException("Attempted to apply transaction " + systemVersion + " when prevalent system was only at " + this._systemVersion);
            }
            this._systemVersion = systemVersion;
            try {
                capsule.executeOn(this._prevalentSystem, executionTime, this._journalSerializer);
            }
            catch (RuntimeException rx) {
                if (!this._ignoreRuntimeExceptions) {
                    throw rx;
                }
            }
            catch (Error error) {
                this._prevalentSystem = null;
                throw error;
            }
            finally {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R executeQuery(Query<? super P, R> sensitiveQuery, Clock clock) throws Exception {
        PrevalentSystemGuard prevalentSystemGuard = this;
        synchronized (prevalentSystemGuard) {
            if (this._prevalentSystem == null) {
                throw new Error("Prevayler is no longer processing queries due to an Error thrown from an earlier transaction.");
            }
            P p = this._prevalentSystem;
            synchronized (p) {
                return sensitiveQuery.query(this._prevalentSystem, clock.time());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File takeSnapshot(GenericSnapshotManager<P> snapshotManager) throws Exception {
        PrevalentSystemGuard prevalentSystemGuard = this;
        synchronized (prevalentSystemGuard) {
            if (this._prevalentSystem == null) {
                throw new Error("Prevayler is no longer allowing snapshots due to an Error thrown from an earlier transaction.");
            }
            P p = this._prevalentSystem;
            synchronized (p) {
                return snapshotManager.writeSnapshot(this._prevalentSystem, this._systemVersion);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrevalentSystemGuard<P> deepCopy(long systemVersion, Serializer snapshotSerializer) throws Exception {
        PrevalentSystemGuard prevalentSystemGuard = this;
        synchronized (prevalentSystemGuard) {
            while (this._systemVersion < systemVersion && this._prevalentSystem != null) {
                Cool.wait(this);
            }
            if (this._prevalentSystem == null) {
                throw new Error("Prevayler is no longer accepting transactions due to an Error thrown from an earlier transaction.");
            }
            if (this._systemVersion > systemVersion) {
                throw new IllegalStateException("Already at " + this._systemVersion + "; can't go back to " + systemVersion);
            }
            P p = this._prevalentSystem;
            synchronized (p) {
                return new PrevalentSystemGuard<Object>(DeepCopier.deepCopyParallel(this._prevalentSystem, snapshotSerializer), this._systemVersion, this._journalSerializer);
            }
        }
    }
}

